/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.overlay;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsConfig;
import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.data.EmoteClue;
import com.larsvansoest.runelite.clueitems.data.EmoteClueAssociations;
import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.data.EmoteClueItem;
import com.larsvansoest.runelite.clueitems.map.WorldMapMarker;
import com.larsvansoest.runelite.clueitems.overlay.ItemContainerWidgetData;
import com.larsvansoest.runelite.clueitems.overlay.Widget;
import com.larsvansoest.runelite.clueitems.overlay.WidgetContainer;
import com.larsvansoest.runelite.clueitems.overlay.WidgetContext;
import com.larsvansoest.runelite.clueitems.overlay.WidgetInspector;
import com.larsvansoest.runelite.clueitems.progress.ProgressManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.ImageComponent;

public class EmoteClueItemsOverlay
extends WidgetItemOverlay {
    private final EmoteClueItemsConfig config;
    private final ItemManager itemManager;
    private final ProgressManager progressManager;
    private final ItemContainerWidgetData itemContainerWidgetData;
    private final Point point;
    private final ArrayList<WorldMapMarker> worldMapMarkers;
    private final Client client;
    private final ClientThread clientThread;
    private int x;
    private int y;

    @Inject
    public EmoteClueItemsOverlay(Client client, ClientThread clientThread, ItemManager itemManager, EmoteClueItemsConfig config, ProgressManager progressManager) {
        this.client = client;
        this.itemManager = itemManager;
        this.progressManager = progressManager;
        this.clientThread = clientThread;
        this.config = config;
        this.itemContainerWidgetData = new ItemContainerWidgetData();
        this.point = new Point();
        this.worldMapMarkers = new ArrayList();
        super.showOnInterfaces(Arrays.stream(Widget.values()).mapToInt(widget -> widget.groupId).toArray());
    }

    public void addWorldMarker(WorldMapMarker marker) {
        this.worldMapMarkers.add(marker);
    }

    public void clearWorldMarkers() {
        this.worldMapMarkers.clear();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        WidgetInspector.InspectItemContainer(itemWidget, this.itemContainerWidgetData, 3);
        WidgetContainer widgetContainer = this.itemContainerWidgetData.getWidgetContainer();
        WidgetContext widgetContext = this.itemContainerWidgetData.getWidgetContext();
        if (Objects.isNull((Object)widgetContext) || Objects.isNull((Object)widgetContainer) || !this.interfaceGroupSettingEnabled(widgetContainer)) {
            return;
        }
        EmoteClueItem emoteClueItem = EmoteClueAssociations.ItemIdToEmoteClueItem.get(this.itemManager.canonicalize(itemId));
        if (Objects.isNull((Object)emoteClueItem)) {
            return;
        }
        Stream<EmoteClue> emoteClues = Arrays.stream(EmoteClueAssociations.EmoteClueItemToEmoteClues.get((Object)emoteClueItem));
        if (this.config.filterInStash()) {
            emoteClues = emoteClues.filter(emoteClue -> !this.progressManager.getStashUnitFilled(emoteClue.getStashUnit()));
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        this.x = bounds.x + bounds.width + this.getXOffset(widgetContainer);
        this.y = bounds.y;
        emoteClues.map(EmoteClue::getEmoteClueDifficulty).distinct().filter(this::difficultySettingEnabled).map(RibbonComponent::ofDifficulty).forEach(ribbon -> {
            this.point.setLocation(this.x, this.y);
            ribbon.setPreferredLocation(this.point);
            ribbon.render(graphics);
            this.y = (int)((double)this.y + (ribbon.getBounds().getHeight() + 1.0));
        });
    }

    public Dimension render(Graphics2D graphics) {
        this.clientThread.invoke(() -> this.worldMapMarkers.forEach(worldMapMarker -> worldMapMarker.rotateOrb(this.client)));
        return super.render(graphics);
    }

    private boolean difficultySettingEnabled(EmoteClueDifficulty difficulty) {
        switch (difficulty) {
            case Beginner: {
                return this.config.highlightBeginner();
            }
            case Easy: {
                return this.config.highlightEasy();
            }
            case Medium: {
                return this.config.highlightMedium();
            }
            case Hard: {
                return this.config.highlightHard();
            }
            case Elite: {
                return this.config.highlightElite();
            }
            case Master: {
                return this.config.highlightMaster();
            }
        }
        return false;
    }

    private boolean interfaceGroupSettingEnabled(WidgetContainer widgetContainer) {
        switch (widgetContainer) {
            case Bank: {
                return this.config.highlightBank();
            }
            case DepositBox: {
                return this.config.highlightDepositBox();
            }
            case Inventory: {
                return this.config.highlightInventory();
            }
            case Equipment: {
                return this.config.highlightEquipment();
            }
            case Shop: {
                return this.config.highlightShop();
            }
            case KeptOnDeath: {
                return this.config.highlightKeptOnDeath();
            }
            case GuidePrices: {
                return this.config.highlightGuidePrices();
            }
            case GroupStorage: {
                return this.config.highlightGroupStorage();
            }
        }
        return false;
    }

    private int getXOffset(WidgetContainer widgetContainer) {
        return widgetContainer == WidgetContainer.Equipment ? -10 : -5;
    }

    private static final class RibbonComponent {
        static final ImageComponent BEGINNER = new ImageComponent(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.BEGINNER);
        static final ImageComponent EASY = new ImageComponent(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.EASY);
        static final ImageComponent MEDIUM = new ImageComponent(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.MEDIUM);
        static final ImageComponent HARD = new ImageComponent(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.HARD);
        static final ImageComponent ELITE = new ImageComponent(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.ELITE);
        static final ImageComponent MASTER = new ImageComponent(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.MASTER);

        private RibbonComponent() {
        }

        public static ImageComponent ofDifficulty(EmoteClueDifficulty difficulty) {
            switch (difficulty) {
                case Beginner: {
                    return BEGINNER;
                }
                case Easy: {
                    return EASY;
                }
                case Medium: {
                    return MEDIUM;
                }
                case Hard: {
                    return HARD;
                }
                case Elite: {
                    return ELITE;
                }
            }
            return MASTER;
        }
    }
}

