/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.map;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;

public class WorldMapOrb {
    private WorldPoint worldPoint;
    private final BufferedImage orb = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB);
    private final BufferedImage orb0 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_0);
    private final BufferedImage orb90 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_90);
    private final BufferedImage orb180 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_180);
    private final BufferedImage orb270 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_270);
    private final BufferedImage orb45 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_45);
    private final BufferedImage orb135 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_135);
    private final BufferedImage orb225 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_225);
    private final BufferedImage orb315 = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.MapOrb.ORB_315);
    private BufferedImage image = new BufferedImage(40, 40, 2);

    public void setIcon(BufferedImage icon) {
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb, EmoteClueItemsImages.MapOrb.ORB, icon, 2.0, 2.0);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb0, EmoteClueItemsImages.MapOrb.ORB_0, icon, 2.0, 1.35);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb180, EmoteClueItemsImages.MapOrb.ORB_180, icon, 2.0, 3.0);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb90, EmoteClueItemsImages.MapOrb.ORB_90, icon, 5.0, 2.0);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb270, EmoteClueItemsImages.MapOrb.ORB_270, icon, 1.25, 2.0);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb225, EmoteClueItemsImages.MapOrb.ORB_225, icon, 2.0, 2.0);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb45, EmoteClueItemsImages.MapOrb.ORB_45, icon, 2.0, 2.0);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb315, EmoteClueItemsImages.MapOrb.ORB_315, icon, 2.0, 2.0);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.orb135, EmoteClueItemsImages.MapOrb.ORB_135, icon, 2.0, 2.0);
    }

    public WorldMapOrb(WorldPoint worldPoint, BufferedImage icon) {
        this.worldPoint = worldPoint;
        this.resetOrientation();
        this.setIcon(icon);
    }

    private static Point mapWorldPointToGraphicsPoint(Client client, WorldPoint worldPoint) {
        RenderOverview ro = client.getRenderOverview();
        if (!ro.getWorldMapData().surfaceContainsPosition(worldPoint.getX(), worldPoint.getY())) {
            return null;
        }
        float pixelsPerTile = ro.getWorldMapZoom();
        Widget map = client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map != null) {
            Rectangle worldMapRect = map.getBounds();
            int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
            int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
            Point worldMapPosition = ro.getWorldMapPosition();
            int yTileMax = worldMapPosition.getY() - heightInTiles / 2;
            int yTileOffset = (yTileMax - worldPoint.getY() - 1) * -1;
            int xTileOffset = worldPoint.getX() + widthInTiles / 2 - worldMapPosition.getX();
            int xGraphDiff = (int)((float)xTileOffset * pixelsPerTile);
            int yGraphDiff = (int)((float)yTileOffset * pixelsPerTile);
            yGraphDiff = (int)((double)yGraphDiff - ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            xGraphDiff = (int)((double)xGraphDiff + ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            yGraphDiff = worldMapRect.height - yGraphDiff;
            return new Point(xGraphDiff += (int)worldMapRect.getX(), yGraphDiff += (int)worldMapRect.getY());
        }
        return null;
    }

    private static Rectangle getWorldMapClipArea(Client client) {
        Widget widget = client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        return widget == null ? null : widget.getBounds();
    }

    public void resetOrientation() {
        this.setImage(-1);
    }

    public void updateOrientation(Client client) {
        Rectangle mapViewArea = WorldMapOrb.getWorldMapClipArea(client);
        Point drawPoint = WorldMapOrb.mapWorldPointToGraphicsPoint(client, this.worldPoint);
        if (mapViewArea != null && drawPoint != null && !mapViewArea.contains(drawPoint.getX(), drawPoint.getY())) {
            int rotation = this.getRotation(drawPoint.getX(), drawPoint.getY(), (int)mapViewArea.getMinX(), (int)mapViewArea.getMaxX(), (int)mapViewArea.getMinY(), (int)mapViewArea.getMaxY());
            this.setImage(rotation);
        }
    }

    private BufferedImage getBuffer(int rotation) {
        switch (rotation) {
            case 0: {
                return this.orb0;
            }
            case 45: {
                return this.orb45;
            }
            case 90: {
                return this.orb90;
            }
            case 135: {
                return this.orb135;
            }
            case 180: {
                return this.orb180;
            }
            case 225: {
                return this.orb225;
            }
            case 270: {
                return this.orb270;
            }
            case 315: {
                return this.orb315;
            }
        }
        return this.orb;
    }

    private void setImage(int rotation) {
        this.image = this.getBuffer(rotation);
    }

    private int getRotation(int x, int y, int minX, int maxX, int minY, int maxY) {
        if (x <= minX) {
            return this.getLeftRotation(y, minY, maxY);
        }
        if (x <= maxX) {
            return this.getCenterRotation(y, minY, maxY);
        }
        return this.getRightRotation(y, minY, maxY);
    }

    private int getLeftRotation(double y, double minY, double maxY) {
        if (y <= minY) {
            return 315;
        }
        if (y <= maxY) {
            return 270;
        }
        return 225;
    }

    private int getCenterRotation(double y, double minY, double maxY) {
        if (y <= minY) {
            return 0;
        }
        return 180;
    }

    private int getRightRotation(int y, int minY, int maxY) {
        if (y <= minY) {
            return 45;
        }
        if (y <= maxY) {
            return 90;
        }
        return 135;
    }

    public void setWorldPoint(WorldPoint worldPoint) {
        this.worldPoint = worldPoint;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

