/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.map;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.map.WorldMapOrb;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;

public class WorldMapMarker
extends WorldMapPoint {
    private final BufferedImage marker = EmoteClueItemsImages.Utils.createBufferFromImage(EmoteClueItemsImages.RuneLite.CLUE_ARROW);
    private final Point markerPoint = new Point(this.marker.getWidth() / 2, this.marker.getHeight());
    private final WorldMapOrb orb;

    public WorldMapMarker(WorldPoint worldPoint, BufferedImage icon, String name) {
        super(worldPoint, icon);
        super.setSnapToEdge(true);
        super.setJumpOnClick(true);
        super.setName(name);
        this.orb = new WorldMapOrb(worldPoint, icon);
        this.setIcon(icon);
    }

    public void rotateOrb(Client client) {
        this.orb.updateOrientation(client);
        if (super.isCurrentlyEdgeSnapped()) {
            super.setImage(this.orb.getImage());
        }
    }

    public void setIcon(BufferedImage icon) {
        this.orb.setIcon(icon);
        EmoteClueItemsImages.Utils.drawIconWithBackground(this.marker, EmoteClueItemsImages.RuneLite.CLUE_ARROW, icon, 2.0, 2.5);
    }

    public void onEdgeSnap() {
        this.orb.resetOrientation();
        super.setImagePoint(null);
    }

    public void onEdgeUnsnap() {
        super.setImage(this.marker);
        super.setImagePoint(this.markerPoint);
    }

    public void setWorldPoint(WorldPoint worldPoint) {
        super.setWorldPoint(worldPoint);
        this.orb.setWorldPoint(worldPoint);
    }
}

