/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems;

import com.google.inject.Provides;
import com.larsvansoest.runelite.clueitems.EmoteClueItemsConfig;
import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.data.StashUnit;
import com.larsvansoest.runelite.clueitems.map.StashUnitWorldMapMarker;
import com.larsvansoest.runelite.clueitems.overlay.EmoteClueItemsOverlay;
import com.larsvansoest.runelite.clueitems.overlay.Widget;
import com.larsvansoest.runelite.clueitems.overlay.WidgetInspector;
import com.larsvansoest.runelite.clueitems.progress.ProgressManager;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPanel;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Emote Clue Items", description="Highlight required items for emote clue steps.", tags={"emote", "clue", "item", "items", "scroll"})
public class EmoteClueItemsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EmoteClueItemsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EmoteClueItemsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private StashUnitWorldMapMarker stashUnitWorldMapMarker = null;
    private EmoteClueItemsOverlay overlay;
    private NavigationButton navigationButton;
    private ProgressManager progressManager;
    private EmoteClueItemsPanel emoteClueItemsPanel;
    private boolean updateStashBuiltStatusOnNextGameTick;
    private boolean showUnopenedInterfaceNotification;
    private Integer cachedPlayerConstructionLevel;
    private boolean readWatsonOnNextGameTick;
    private boolean isPlayerLoggedIn;

    protected void startUp() {
        EmoteClueItemsPalette emoteClueItemsPalette = EmoteClueItemsPalette.RUNELITE;
        this.emoteClueItemsPanel = new EmoteClueItemsPanel(emoteClueItemsPalette, this.itemManager, this::onUserSetStashUnitFillStatus, this::addStashUnitMarkerToMap, this::removeStashUnitMarkerFromMap, "Emote Clue Items", "v4.2.1", "https://github.com/larsvansoest/emote-clue-items", "https://www.paypal.com/donate/?hosted_button_id=72AFNGL28LFEN");
        this.progressManager = new ProgressManager(this.client, this.clientThread, this.configManager, this.config, this.itemManager, this.emoteClueItemsPanel::setEmoteClueItemQuantity, this.emoteClueItemsPanel::setEmoteClueItemCollectionLogStatus, this.emoteClueItemsPanel::setEmoteClueItemStatus);
        this.navigationButton = NavigationButton.builder().tooltip("Emote Clue Items").icon(ImageUtil.resizeCanvas((BufferedImage)EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.ALL, (int)16, (int)16)).priority(7).panel((PluginPanel)this.emoteClueItemsPanel).build();
        this.toggleCollectionLog(this.config.showNavigation());
        this.overlay = new EmoteClueItemsOverlay(this.client, this.clientThread, this.itemManager, this.config, this.progressManager);
        this.overlayManager.add((Overlay)this.overlay);
        this.reset();
    }

    private void onUserSetStashUnitFillStatus(StashUnit stashUnit, Boolean filled) {
        this.progressManager.setStashUnitFilled(stashUnit, filled);
    }

    private void reset() {
        this.progressManager.reset();
        this.emoteClueItemsPanel.reset();
        String loginDisclaimer = "To start display of progression, please login first.";
        for (StashUnit stashUnit : StashUnit.values()) {
            this.emoteClueItemsPanel.turnOnSTASHFilledButton(stashUnit);
            this.emoteClueItemsPanel.turnOffSTASHFilledButton(stashUnit, new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.WAITING), "To start display of progression, please login first.");
        }
        this.emoteClueItemsPanel.setEmoteClueItemGridDisclaimer("To start display of progression, please login first.");
        this.emoteClueItemsPanel.setSTASHUnitGridDisclaimer("To start display of progression, please login first.");
        this.updateStashBuiltStatusOnNextGameTick = false;
        this.readWatsonOnNextGameTick = false;
        this.showUnopenedInterfaceNotification = this.config.notifyUnopenedInterfaces();
        this.cachedPlayerConstructionLevel = null;
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.onPlayerLoggedIn();
        }
        this.removeStashUnitMarkerFromMap();
    }

    private void addStashUnitMarkerToMap(StashUnit stashUnit, boolean built) {
        this.removeStashUnitMarkerFromMap();
        if (Objects.isNull((Object)this.stashUnitWorldMapMarker)) {
            this.stashUnitWorldMapMarker = new StashUnitWorldMapMarker(stashUnit, built);
        }
        this.stashUnitWorldMapMarker.setStashUnit(stashUnit, built);
        this.worldMapPointManager.add((WorldMapPoint)this.stashUnitWorldMapMarker);
        this.overlay.addWorldMarker(this.stashUnitWorldMapMarker);
    }

    private void removeStashUnitMarkerFromMap() {
        this.worldMapPointManager.remove((WorldMapPoint)this.stashUnitWorldMapMarker);
        this.overlay.clearWorldMarkers();
    }

    private void updateStashUnitBuildStatuses() {
        this.clientThread.invoke(() -> {
            for (StashUnit stashUnit : StashUnit.values()) {
                this.client.runScript(new Object[]{1479, stashUnit.getStashUnit().getObjectId(), 0, 0, 0});
                boolean built = this.client.getIntStack()[0] == 1;
                this.emoteClueItemsPanel.turnOnSTASHFilledButton(stashUnit);
                this.emoteClueItemsPanel.setSTASHUnitStatus(stashUnit, built, this.progressManager.getStashUnitFilled(stashUnit));
            }
        });
    }

    private void onPlayerLoggedIn() {
        this.progressManager.validateConfig();
        this.updateStashBuiltStatusOnNextGameTick = true;
        this.emoteClueItemsPanel.removeEmoteClueItemGridDisclaimer();
        this.emoteClueItemsPanel.removeSTASHUnitGridDisclaimer();
        this.clientThread.invoke(this::setupUnopenedInterfaceNotification);
        this.clientThread.invoke(() -> {
            int playerConstructionLevel = this.client.getBoostedSkillLevel(Skill.CONSTRUCTION);
            this.updatePlayerConstructionLevel(playerConstructionLevel);
        });
        this.emoteClueItemsPanel.enableMapLinks();
    }

    private void updatePlayerConstructionLevel(Integer level) {
        if (!Objects.equals(this.cachedPlayerConstructionLevel, level)) {
            this.cachedPlayerConstructionLevel = level;
            this.emoteClueItemsPanel.setPlayerConstructionLevel(level);
        }
    }

    private void setupUnopenedInterfaceNotification() {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.emoteClueItemsPanel.removeEmoteClueItemGridDisclaimer();
                if (this.showUnopenedInterfaceNotification) {
                    List<String> unopenedInterfaces = this.progressManager.getUnopenedInterfaces();
                    if (this.config.notifyUnopenedInterfaces() && unopenedInterfaces.size() > 0) {
                        String notification = String.format("Not all items may be displayed. Please open your %s first.", String.join((CharSequence)", ", unopenedInterfaces));
                        this.emoteClueItemsPanel.setEmoteClueItemGridDisclaimer(notification, () -> {
                            this.showUnopenedInterfaceNotification = false;
                        });
                    }
                }
            }
        });
    }

    private void toggleCollectionLog(boolean visible) {
        if (visible) {
            this.clientToolbar.addNavigation(this.navigationButton);
        } else {
            this.clientToolbar.removeNavigation(this.navigationButton);
        }
    }

    @Subscribe
    protected void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == Widget.WATSON_NOTICE_BOARD.groupId && this.config.autoSyncWatsonBoard()) {
            this.readWatsonOnNextGameTick = true;
        }
    }

    @Subscribe
    protected void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == Widget.WATSON_NOTICE_BOARD.groupId) {
            this.readWatsonOnNextGameTick = false;
        }
    }

    @Subscribe
    protected void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.reset();
            this.isPlayerLoggedIn = false;
        }
        if (!this.isPlayerLoggedIn && event.getGameState() == GameState.LOGGED_IN) {
            this.onPlayerLoggedIn();
            this.isPlayerLoggedIn = true;
        }
    }

    @Subscribe
    protected void onStatChanged(StatChanged event) {
        if (Objects.equals(event.getSkill(), Skill.CONSTRUCTION)) {
            this.updatePlayerConstructionLevel(event.getLevel());
        }
    }

    @Subscribe
    protected void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.SPAM && event.getMessage().equals("You build a STASH unit.")) {
            this.updateStashUnitBuildStatuses();
        }
    }

    @Subscribe
    protected void onItemContainerChanged(ItemContainerChanged event) {
        this.progressManager.processInventoryChanges(event.getContainerId(), event.getItemContainer().getItems());
        this.clientThread.invoke(this::setupUnopenedInterfaceNotification);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.updateStashBuiltStatusOnNextGameTick) {
            this.updateStashBuiltStatusOnNextGameTick = false;
            this.updateStashUnitBuildStatuses();
        }
        if (this.readWatsonOnNextGameTick) {
            boolean readComplete = WidgetInspector.TryReadWatsonBoard(this.client, difficulty -> (watsonLocation, filled) -> {
                StashUnit stashUnit = StashUnit.fromWatsonLocation(watsonLocation, difficulty);
                if (Objects.nonNull((Object)stashUnit)) {
                    this.progressManager.setStashUnitFilled(stashUnit, (boolean)filled);
                    this.emoteClueItemsPanel.setStashUnitFilledStatus(stashUnit, (boolean)filled);
                }
            });
            this.readWatsonOnNextGameTick = !readComplete;
        }
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged event) {
        String key = event.getKey();
        boolean isNull = Objects.isNull(event.getNewValue());
        boolean isTrue = !isNull && event.getNewValue().equals("true");
        boolean isTrueOrDefaultTrue = isNull || isTrue;
        boolean isTrueOrDefaultFalse = !isNull && isTrue;
        switch (key) {
            case "TrackBank": {
                this.progressManager.toggleBankTracking(isTrueOrDefaultTrue);
                this.setupUnopenedInterfaceNotification();
                break;
            }
            case "TrackInventory": {
                this.progressManager.toggleInventoryTracking(isTrueOrDefaultTrue);
                this.setupUnopenedInterfaceNotification();
                break;
            }
            case "TrackEquipment": {
                this.progressManager.toggleEquipmentTracking(isTrueOrDefaultTrue);
                this.setupUnopenedInterfaceNotification();
                break;
            }
            case "TrackGroupStorage": {
                this.progressManager.toggleGroupStorageTracking(isTrueOrDefaultFalse);
                this.setupUnopenedInterfaceNotification();
                break;
            }
            case "NotifyUnopenedInterfaces": {
                this.showUnopenedInterfaceNotification = isTrueOrDefaultTrue;
                this.setupUnopenedInterfaceNotification();
                break;
            }
            case "ShowNavigation": {
                this.toggleCollectionLog(isTrueOrDefaultTrue);
                break;
            }
            case "AutoSyncWatsonBoard": {
                boolean isWatsonBoardOpen = Objects.nonNull(this.client.getWidget(493, 0));
                this.readWatsonOnNextGameTick = isWatsonBoardOpen && isTrueOrDefaultFalse;
                break;
            }
        }
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.removeStashUnitMarkerFromMap();
    }

    @Provides
    EmoteClueItemsConfig provideConfig(ConfigManager configManager) {
        return (EmoteClueItemsConfig)configManager.getConfig(EmoteClueItemsConfig.class);
    }
}

