/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsPlugin;
import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.data.StashUnit;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Objects;
import net.runelite.client.util.ImageUtil;

public abstract class EmoteClueItemsImages {
    private static final String folder = "/images";

    private static BufferedImage getBufferedImage(String folder, String name) {
        return ImageUtil.loadImageResource(EmoteClueItemsPlugin.class, (String)EmoteClueItemsImages.path(folder, name));
    }

    private static String path(String current, String next) {
        return String.format("%s/%s", current, next);
    }

    public static final class Icons {
        private static final String folder = EmoteClueItemsImages.path("/images", "icons");
        public static final BufferedImage CLOSE = EmoteClueItemsImages.getBufferedImage(folder, "close.png");
        public static final BufferedImage GITHUB = EmoteClueItemsImages.getBufferedImage(folder, "github.png");
        public static final BufferedImage PAYPAL = EmoteClueItemsImages.getBufferedImage(folder, "paypal.png");
        public static final BufferedImage QUESTION = EmoteClueItemsImages.getBufferedImage(folder, "question.png");

        private Icons() {
        }

        public static final class SortType {
            private static final String folder = EmoteClueItemsImages.path(folder, "sort-type");
            public static final BufferedImage NAME_ASCENDING = EmoteClueItemsImages.getBufferedImage(folder, "name-ascending.png");
            public static final BufferedImage NAME_DESCENDING = EmoteClueItemsImages.getBufferedImage(folder, "name-descending.png");
            public static final BufferedImage QUANTITY_ASCENDING = EmoteClueItemsImages.getBufferedImage(folder, "quantity-ascending.png");
            public static final BufferedImage QUANTITY_DESCENDING = EmoteClueItemsImages.getBufferedImage(folder, "quantity-descending.png");

            private SortType() {
            }
        }

        public static final class RuneScape {
            private static final String folder = EmoteClueItemsImages.path(folder, "runescape");
            public static final BufferedImage INVENTORY = EmoteClueItemsImages.getBufferedImage(folder, "inventory.png");

            private RuneScape() {
            }

            public static final class StashUnit {
                private static final String folder = EmoteClueItemsImages.path(folder, "stash-unit");
                public static final BufferedImage BUSH = EmoteClueItemsImages.getBufferedImage(folder, "bush.png");
                public static final BufferedImage BUSH_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "bush-small.png");
                public static final BufferedImage BUSH_BUILT = EmoteClueItemsImages.getBufferedImage(folder, "bush-built.png");
                public static final BufferedImage BUSH_BUILT_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "bush-built-small.png");
                public static final BufferedImage CRATE = EmoteClueItemsImages.getBufferedImage(folder, "crate.png");
                public static final BufferedImage CRATE_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "crate-small.png");
                public static final BufferedImage CRATE_BUILT = EmoteClueItemsImages.getBufferedImage(folder, "crate-built.png");
                public static final BufferedImage CRATE_BUILT_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "crate-built-small.png");
                public static final BufferedImage HOLE = EmoteClueItemsImages.getBufferedImage(folder, "hole.png");
                public static final BufferedImage HOLE_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "hole-small.png");
                public static final BufferedImage HOLE_BUILT = EmoteClueItemsImages.getBufferedImage(folder, "hole-built.png");
                public static final BufferedImage HOLE_BUILT_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "hole-built-small.png");
                public static final BufferedImage ROCK = EmoteClueItemsImages.getBufferedImage(folder, "rock.png");
                public static final BufferedImage ROCK_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "rock-small.png");
                public static final BufferedImage ROCK_BUILT = EmoteClueItemsImages.getBufferedImage(folder, "rock-built.png");
                public static final BufferedImage ROCK_BUILT_SMALL = EmoteClueItemsImages.getBufferedImage(folder, "rock-built-small.png");

                private StashUnit() {
                }

                public static BufferedImage get(StashUnit.Type type, boolean built, boolean small) {
                    if (built) {
                        if (small) {
                            return StashUnit.getBuiltSmall(type);
                        }
                        return StashUnit.getBuilt(type);
                    }
                    if (small) {
                        return StashUnit.getSmall(type);
                    }
                    return StashUnit.get(type);
                }

                private static BufferedImage get(StashUnit.Type type) {
                    switch (type) {
                        case Bush: {
                            return BUSH;
                        }
                        case Hole: {
                            return HOLE;
                        }
                        case Rock: {
                            return ROCK;
                        }
                    }
                    return CRATE;
                }

                private static BufferedImage getBuilt(StashUnit.Type type) {
                    switch (type) {
                        case Bush: {
                            return BUSH_BUILT;
                        }
                        case Hole: {
                            return HOLE_BUILT;
                        }
                        case Rock: {
                            return ROCK_BUILT;
                        }
                    }
                    return CRATE_BUILT;
                }

                private static BufferedImage getSmall(StashUnit.Type type) {
                    switch (type) {
                        case Bush: {
                            return BUSH_SMALL;
                        }
                        case Hole: {
                            return HOLE_SMALL;
                        }
                        case Rock: {
                            return ROCK_SMALL;
                        }
                    }
                    return CRATE_SMALL;
                }

                private static BufferedImage getBuiltSmall(StashUnit.Type type) {
                    switch (type) {
                        case Bush: {
                            return BUSH_BUILT_SMALL;
                        }
                        case Hole: {
                            return HOLE_BUILT_SMALL;
                        }
                        case Rock: {
                            return ROCK_BUILT_SMALL;
                        }
                    }
                    return CRATE_BUILT_SMALL;
                }
            }

            public static final class EmoteClue {
                private static final String folder = EmoteClueItemsImages.path(folder, "emote-clue");

                private EmoteClue() {
                }

                public static final class Scroll {
                    private static final String folder = EmoteClueItemsImages.path(folder, "scroll");
                    public static final BufferedImage BEGINNER = EmoteClueItemsImages.getBufferedImage(folder, "beginner.png");
                    public static final BufferedImage EASY = EmoteClueItemsImages.getBufferedImage(folder, "easy.png");
                    public static final BufferedImage MEDIUM = EmoteClueItemsImages.getBufferedImage(folder, "medium.png");
                    public static final BufferedImage HARD = EmoteClueItemsImages.getBufferedImage(folder, "hard.png");
                    public static final BufferedImage ELITE = EmoteClueItemsImages.getBufferedImage(folder, "elite.png");
                    public static final BufferedImage MASTER = EmoteClueItemsImages.getBufferedImage(folder, "master.png");

                    private Scroll() {
                    }

                    public static BufferedImage get(EmoteClueDifficulty emoteClueDifficulty) {
                        switch (emoteClueDifficulty) {
                            case Beginner: {
                                return BEGINNER;
                            }
                            case Easy: {
                                return EASY;
                            }
                            case Medium: {
                                return MEDIUM;
                            }
                            case Hard: {
                                return HARD;
                            }
                            case Elite: {
                                return ELITE;
                            }
                            case Master: {
                                return MASTER;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                }

                public static final class Ribbon {
                    private static final String folder = EmoteClueItemsImages.path(folder, "ribbon");
                    public static final BufferedImage ALL = EmoteClueItemsImages.getBufferedImage(folder, "all.png");
                    public static final BufferedImage BEGINNER = EmoteClueItemsImages.getBufferedImage(folder, "beginner.png");
                    public static final BufferedImage EASY = EmoteClueItemsImages.getBufferedImage(folder, "easy.png");
                    public static final BufferedImage MEDIUM = EmoteClueItemsImages.getBufferedImage(folder, "medium.png");
                    public static final BufferedImage HARD = EmoteClueItemsImages.getBufferedImage(folder, "hard.png");
                    public static final BufferedImage ELITE = EmoteClueItemsImages.getBufferedImage(folder, "elite.png");
                    public static final BufferedImage MASTER = EmoteClueItemsImages.getBufferedImage(folder, "master.png");

                    private Ribbon() {
                    }

                    public static BufferedImage get(EmoteClueDifficulty emoteClueDifficulty) {
                        switch (emoteClueDifficulty) {
                            case Beginner: {
                                return BEGINNER;
                            }
                            case Easy: {
                                return EASY;
                            }
                            case Medium: {
                                return MEDIUM;
                            }
                            case Hard: {
                                return HARD;
                            }
                            case Elite: {
                                return ELITE;
                            }
                            case Master: {
                                return MASTER;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                }
            }
        }

        public static final class Location {
            private static final String folder = EmoteClueItemsImages.path(folder, "location");
            public static final BufferedImage PIN = EmoteClueItemsImages.getBufferedImage(folder, "pin.png");
            public static final BufferedImage PIN_DELETE = EmoteClueItemsImages.getBufferedImage(folder, "pin-delete.png");

            private Location() {
            }
        }

        public static final class Chevron {
            private static final String folder = EmoteClueItemsImages.path(folder, "chevron");
            public static final BufferedImage DOWN = EmoteClueItemsImages.getBufferedImage(folder, "down.png");
            public static final BufferedImage LEFT = EmoteClueItemsImages.getBufferedImage(folder, "left.png");

            private Chevron() {
            }
        }

        public static final class CheckSquare {
            private static final String folder = EmoteClueItemsImages.path(folder, "check-square");
            public static final BufferedImage UNKNOWN = EmoteClueItemsImages.getBufferedImage(folder, "unknown.png");
            public static final BufferedImage COMPLETE = EmoteClueItemsImages.getBufferedImage(folder, "complete.png");
            public static final BufferedImage INCOMPLETE = EmoteClueItemsImages.getBufferedImage(folder, "incomplete.png");
            public static final BufferedImage INCOMPLETE_EMPTY = EmoteClueItemsImages.getBufferedImage(folder, "incomplete-empty.png");
            public static final BufferedImage IN_PROGRESS = EmoteClueItemsImages.getBufferedImage(folder, "in-progress.png");
            public static final BufferedImage WAITING = EmoteClueItemsImages.getBufferedImage(folder, "waiting.png");
            public static final BufferedImage UNBUILT = EmoteClueItemsImages.getBufferedImage(folder, "unbuilt.png");

            private CheckSquare() {
            }
        }
    }

    public static final class MapOrb {
        private static final String folder = EmoteClueItemsImages.path("/images", "map-orb");
        public static final BufferedImage ORB = EmoteClueItemsImages.getBufferedImage(folder, "orb.png");
        public static final BufferedImage ORB_0 = EmoteClueItemsImages.getBufferedImage(folder, "orb-0.png");
        public static final BufferedImage ORB_90 = EmoteClueItemsImages.getBufferedImage(folder, "orb-90.png");
        public static final BufferedImage ORB_180 = EmoteClueItemsImages.getBufferedImage(folder, "orb-180.png");
        public static final BufferedImage ORB_270 = EmoteClueItemsImages.getBufferedImage(folder, "orb-270.png");
        public static final BufferedImage ORB_45 = EmoteClueItemsImages.getBufferedImage(folder, "orb-45.png");
        public static final BufferedImage ORB_135 = EmoteClueItemsImages.getBufferedImage(folder, "orb-135.png");
        public static final BufferedImage ORB_225 = EmoteClueItemsImages.getBufferedImage(folder, "orb-225.png");
        public static final BufferedImage ORB_315 = EmoteClueItemsImages.getBufferedImage(folder, "orb-315.png");

        private MapOrb() {
        }
    }

    public static final class RuneLite {
        private static final String folder = "/util";
        public static final BufferedImage CLUE_ARROW = EmoteClueItemsImages.getBufferedImage("/util", "clue_arrow.png");

        private RuneLite() {
        }
    }

    public static final class Utils {
        private static final Color TRANSPARENT = new Color(0, 0, 0, 0);

        private Utils() {
        }

        public static BufferedImage createBufferFromImage(BufferedImage image) {
            return ImageUtil.fillImage((BufferedImage)image, (Color)TRANSPARENT);
        }

        public static void drawIconWithBackground(BufferedImage bufferedImage, BufferedImage background, BufferedImage icon, double devideX, double devideY) {
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.drawImage((Image)background, 0, 0, null);
            if (Objects.nonNull(icon) && devideX != 0.0 && devideY != 0.0) {
                int x = Math.max((int)((double)(background.getWidth() - icon.getWidth()) / devideX), 0);
                int y = Math.max((int)((double)(background.getHeight() - icon.getHeight()) / devideY), 0);
                g2d.drawImage((Image)icon, x, y, null);
            }
            g2d.dispose();
        }
    }
}

