/*
 * Decompiled with CFR 0.152.
 */
package com.grounditemsounds;

import com.google.inject.Provides;
import com.grounditemsounds.GroundItemSoundsConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.ItemComposition;
import net.runelite.api.TileItem;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsPlugin;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ground Item Sounds")
@PluginDependency(value=GroundItemsPlugin.class)
public class GroundItemSoundsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GroundItemSoundsPlugin.class);
    @Inject
    private GroundItemSoundsConfig config;
    @Inject
    private GroundItemsConfig groundItemsConfig;
    @Inject
    private ItemManager itemManager;
    private static final File GROUND_ITEM_SOUNDS_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "ground-item-sounds");
    private static final File HIGHLIGHTED_SOUND_FILE = new File(GROUND_ITEM_SOUNDS_DIR, "highlighted_sound.wav");
    private static final File LOW_SOUND_FILE = new File(GROUND_ITEM_SOUNDS_DIR, "low_sound.wav");
    private static final File MEDIUM_SOUND_FILE = new File(GROUND_ITEM_SOUNDS_DIR, "medium_sound.wav");
    private static final File HIGH_SOUND_FILE = new File(GROUND_ITEM_SOUNDS_DIR, "high_sound.wav");
    private static final File INSANE_SOUND_FILE = new File(GROUND_ITEM_SOUNDS_DIR, "insane_sound.wav");
    private static final File[] SOUND_FILES = new File[]{HIGHLIGHTED_SOUND_FILE, LOW_SOUND_FILE, MEDIUM_SOUND_FILE, HIGH_SOUND_FILE, INSANE_SOUND_FILE};
    private List<String> highlightedItemsList = new CopyOnWriteArrayList<String>();
    private Clip clip = null;

    @Provides
    GroundItemSoundsConfig provideConfig(ConfigManager configManager) {
        return (GroundItemSoundsConfig)configManager.getConfig(GroundItemSoundsConfig.class);
    }

    protected void startUp() {
        this.initSoundFiles();
        this.updateHighlightedItemsList();
    }

    protected void shutDown() {
        this.clip.close();
        this.clip = null;
        this.highlightedItemsList = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("grounditems") && configChanged.getKey().equals("highlightedItems")) {
            this.updateHighlightedItemsList();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        int id = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        String name = itemComposition.getName().toLowerCase();
        if (this.config.highlightSound() && this.highlightedItemsList.contains(name)) {
            this.playSound(HIGHLIGHTED_SOUND_FILE, this.config.highlightVolume());
        }
        int quantity = item.getQuantity();
        int gePrice = this.itemManager.getItemPrice(id) * quantity;
        int haPrice = itemComposition.getHaPrice() * quantity;
        int value = this.getValueByMode(gePrice, haPrice);
        if (this.config.lowValueSound() && value >= this.groundItemsConfig.lowValuePrice() && value < this.groundItemsConfig.mediumValuePrice()) {
            this.playSound(LOW_SOUND_FILE, this.config.lowValueVolume());
        }
        if (this.config.mediumValueSound() && value >= this.groundItemsConfig.mediumValuePrice() && value < this.groundItemsConfig.highValuePrice()) {
            this.playSound(MEDIUM_SOUND_FILE, this.config.mediumValueVolume());
        }
        if (this.config.highValueSound() && value >= this.groundItemsConfig.highValuePrice() && value < this.groundItemsConfig.insaneValuePrice()) {
            this.playSound(HIGH_SOUND_FILE, this.config.highValueVolume());
        }
        if (this.config.insaneValueSound() && value >= this.groundItemsConfig.insaneValuePrice()) {
            this.playSound(INSANE_SOUND_FILE, this.config.insaneValueVolume());
        }
    }

    private void playSound(File f, int volume) {
        try {
            AudioInputStream is = AudioSystem.getAudioInputStream(f);
            AudioFormat format = is.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(is);
            this.setVolume(volume);
            this.clip.start();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Sound file error", (Throwable)e);
        }
    }

    private void setVolume(int volume) {
        float vol = (float)volume / 100.0f;
        FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        gainControl.setValue(20.0f * (float)Math.log10(vol *= (float)this.config.masterVolume() / 100.0f));
    }

    private void initSoundFiles() {
        if (!GROUND_ITEM_SOUNDS_DIR.exists()) {
            GROUND_ITEM_SOUNDS_DIR.mkdirs();
        }
        for (File f : SOUND_FILES) {
            try {
                int bytesRead;
                if (f.exists()) continue;
                InputStream stream = GroundItemSoundsPlugin.class.getClassLoader().getResourceAsStream(f.getName());
                FileOutputStream out = new FileOutputStream(f);
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
                ((OutputStream)out).close();
                stream.close();
            }
            catch (Exception e) {
                log.debug("GroundItemSoundsPlugin - " + e + ": " + f);
            }
        }
    }

    private int getValueByMode(int gePrice, int haPrice) {
        switch (this.groundItemsConfig.valueCalculationMode()) {
            case GE: {
                return gePrice;
            }
            case HA: {
                return haPrice;
            }
        }
        return Math.max(gePrice, haPrice);
    }

    private void updateHighlightedItemsList() {
        if (!this.groundItemsConfig.getHighlightItems().isEmpty()) {
            this.highlightedItemsList = Text.fromCSV((String)this.groundItemsConfig.getHighlightItems().toLowerCase());
        }
    }
}

