/*
 * Decompiled with CFR 0.152.
 */
package com.identificator;

import com.google.inject.Inject;
import com.identificator.IdentificatorPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.NpcOverrides;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class IdentificatorOverlay
extends Overlay {
    private final IdentificatorPlugin plugin;
    private final Client client;
    private final TooltipManager tooltipManager;

    @Inject
    IdentificatorOverlay(IdentificatorPlugin plugin, Client client, TooltipManager tooltipManager) {
        this.plugin = plugin;
        this.client = client;
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.triggerWithShift && !this.client.isKeyPressed(81)) {
            return null;
        }
        if (this.plugin.showOverheadInfo) {
            for (NPC npc : this.client.getCachedNPCs()) {
                this.renderNpc(graphics, npc);
            }
            for (Player player : this.client.getPlayers()) {
                this.renderPlayer(graphics, player);
            }
            Tile[][] tiles = this.client.getScene().getTiles()[this.client.getPlane()];
            WorldPoint location = this.client.getLocalPlayer().getWorldLocation();
            int radius = 20;
            int width = tiles.length;
            int height = tiles[0].length;
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Tile tile = tiles[i][j];
                    if (tile == null || location.distanceTo(tile.getWorldLocation()) > 20) continue;
                    StringBuilder text = new StringBuilder();
                    if (this.plugin.showGameObjectId) {
                        text.append(this.gameObjectsToText(tile.getGameObjects()));
                    }
                    if (this.plugin.showGroundObjectId) {
                        text.append(this.objectToText(text, (TileObject)tile.getGroundObject()));
                    }
                    if (this.plugin.showDecorativeObjectId) {
                        text.append(this.objectToText(text, (TileObject)tile.getDecorativeObject()));
                    }
                    if (this.plugin.showWallObjectId) {
                        text.append(this.objectToText(text, (TileObject)tile.getWallObject()));
                    }
                    if (this.plugin.showGroundItemId) {
                        String textGroundItems = this.groundItemsToText(tile.getGroundItems());
                        text.append(text.length() > 0 && textGroundItems.length() > 0 ? ", " : "").append(textGroundItems);
                    }
                    Point textLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)tile.getLocalLocation(), (String)text.toString(), (int)40);
                    if (text.length() <= 0 || textLocation == null) continue;
                    OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)("(ID: " + text.toString() + ")"), (Color)this.plugin.colourOverhead);
                }
            }
        }
        if (this.plugin.showHoverInfo && !this.plugin.hoverText.isEmpty() && this.isHoveringGameScene()) {
            this.tooltipManager.add(new Tooltip(ColorUtil.wrapWithColorTag((String)this.plugin.hoverText, (Color)this.plugin.colourHover)));
        }
        return null;
    }

    private boolean isHoveringGameScene() {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        for (int i = menuEntries.length - 1; i >= 0; --i) {
            if (!MenuAction.WALK.equals((Object)menuEntries[i].getType())) continue;
            return true;
        }
        return false;
    }

    private void renderNpc(Graphics2D graphics, NPC npc) {
        NpcOverrides modelOverrides;
        if (this.plugin.exclude(npc)) {
            return;
        }
        Object text = "";
        if (this.plugin.showNpcId) {
            text = (String)text + "(ID: " + npc.getId() + ")";
        }
        if (this.plugin.showNpcAnimationId) {
            text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(A: " + npc.getAnimation() + ")";
        }
        if (this.plugin.showNpcPoseAnimationId) {
            text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(P: " + npc.getPoseAnimation() + ")";
        }
        if (this.plugin.showNpcGraphicId) {
            text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(G: " + npc.getGraphic() + ")";
        }
        if ((modelOverrides = npc.getModelOverrides()) != null) {
            if (this.plugin.showNpcOverrideModelIds && modelOverrides.getModelIds() != null) {
                text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(M: " + Arrays.toString(modelOverrides.getModelIds()) + ")";
            }
            if (this.plugin.showNpcOverrideColours && modelOverrides.getColorToReplaceWith() != null) {
                text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(C: " + Arrays.toString(modelOverrides.getColorToReplaceWith()) + ")";
            }
            if (this.plugin.showNpcOverrideTextures && modelOverrides.getTextureToReplaceWith() != null) {
                text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(T: " + Arrays.toString(modelOverrides.getTextureToReplaceWith()) + ")";
            }
        }
        if (((String)text).length() <= 0) {
            return;
        }
        Point textLocation = npc.getCanvasTextLocation(graphics, (String)text, npc.getLogicalHeight() + 40);
        if (textLocation != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)this.plugin.colourOverhead);
        }
    }

    private void renderPlayer(Graphics2D graphics, Player player) {
        if (player == null) {
            return;
        }
        Object text = "";
        if (this.plugin.showPlayerAnimationId) {
            text = (String)text + "(A: " + player.getAnimation() + ")";
        }
        if (this.plugin.showPlayerPoseAnimationId) {
            text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(P: " + player.getPoseAnimation() + ")";
        }
        if (this.plugin.showPlayerGraphicId) {
            text = (String)text + (((String)text).length() == 0 ? "" : " ") + "(G: " + player.getGraphic() + ")";
        }
        if (((String)text).length() <= 0) {
            return;
        }
        Point textLocation = player.getCanvasTextLocation(graphics, (String)text, player.getLogicalHeight() + 40);
        if (textLocation != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)this.plugin.colourOverhead);
        }
    }

    private String objectToText(StringBuilder text, TileObject tileObject) {
        if (tileObject == null) {
            return "";
        }
        return (text.length() > 0 ? ", " : "") + tileObject.getId();
    }

    private String gameObjectsToText(GameObject[] gameObjects) {
        StringBuilder text = new StringBuilder();
        if (!this.plugin.showGameObjectId || gameObjects == null) {
            return text.toString();
        }
        for (GameObject gameObject : gameObjects) {
            Animation animation;
            if (!this.plugin.isGameObject(gameObject)) continue;
            text.append(text.length() > 0 ? ", " : "").append(gameObject.getId());
            if (!this.plugin.showGameObjectAnimationId || !(gameObject.getRenderable() instanceof DynamicObject) || (animation = ((DynamicObject)gameObject.getRenderable()).getAnimation()) == null) continue;
            text.append(" (A: ").append(animation.getId()).append(")");
        }
        return text.toString();
    }

    private String groundItemsToText(List<TileItem> tileItems) {
        StringBuilder text = new StringBuilder();
        if (!this.plugin.showGroundItemId || tileItems == null) {
            return text.toString();
        }
        for (TileItem tileItem : tileItems) {
            if (tileItem == null) continue;
            text.append(text.length() > 0 ? ", " : "").append(tileItem.getId());
        }
        return text.toString();
    }
}

