/*
 * Decompiled with CFR 0.152.
 */
package com.EfficientFletching;

import com.EfficientFletching.EfficientFletchingOverlay;
import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="efficient-fletching")
public class EfficientFletchingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EfficientFletchingPlugin.class);
    int setsLeft;
    int imageToUse;
    float shortTimer;
    boolean correctOptionSelected;
    boolean enchantingBolts;
    EfficientFletchingOverlay counter;
    private static final Set<Integer> FLETCHING_ANIMATION_IDS = ImmutableSet.of((Object)8477, (Object)8474, (Object)8472, (Object)8479, (Object)8473, (Object)8476, (Object[])new Integer[]{8478, 8475, 8481, 8480});
    String[] headlessArrows = new String[]{"Feather", "Arrow shaft"};
    String[] bronzeArrows = new String[]{"Headless arrow", "Bronze arrowtips"};
    String[] ironArrows = new String[]{"Headless arrow", "Iron arrowtips"};
    String[] steelArrows = new String[]{"Headless arrow", "Steel arrowtips"};
    String[] mithrilArrows = new String[]{"Headless arrow", "Mithril arrowtips"};
    String[] broadArrows = new String[]{"Headless arrow", "Broad arrowheads"};
    String[] adamantArrows = new String[]{"Headless arrow", "Adamant arrowtips"};
    String[] runeArrows = new String[]{"Headless arrow", "Rune arrowtips"};
    String[] amethystArrows = new String[]{"Headless arrow", "Amethyst arrowtips"};
    String[] dragonArrows = new String[]{"Headless arrow", "Dragon arrowtips"};
    String[] opalDragonBolts = new String[]{"Opal bolt tips", "Dragon bolts"};
    String[] jadeDragonBolts = new String[]{"Jade bolt tips", "Dragon bolts"};
    String[] pearlDragonBolts = new String[]{"Pearl bolt tips", "Dragon bolts"};
    String[] topazDragonBolts = new String[]{"Topaz bolt tips", "Dragon bolts"};
    String[] sapphireDragonBolts = new String[]{"Sapphire bolt tips", "Dragon bolts"};
    String[] emeraldDragonBolts = new String[]{"Emerald bolt tips", "Dragon bolts"};
    String[] rubyDragonBolts = new String[]{"Ruby bolt tips", "Dragon bolts"};
    String[] diamondDragonBolts = new String[]{"Diamond bolt tips", "Dragon bolts"};
    String[] dragonstoneDragonBolts = new String[]{"Dragonstone bolt tips", "Dragon bolts"};
    String[] onyxDragonBolts = new String[]{"Onyx bolt tips", "Dragon bolts"};
    String[] opalBolts = new String[]{"Opal bolt tips", "Bronze bolts"};
    String[] jadeBolts = new String[]{"Jade bolt tips", "Blurite bolts"};
    String[] pearlBolts = new String[]{"Pearl bolt tips", "Iron bolts"};
    String[] topazBolts = new String[]{"Topaz bolt tips", "Steel bolts"};
    String[] barbBolts = new String[]{"Barb bolttips", "Bronze bolts"};
    String[] sapphireBolts = new String[]{"Sapphire bolt tips", "Mithril bolts"};
    String[] emeraldBolts = new String[]{"Emerald bolt tips", "Mithril bolts"};
    String[] rubyBolts = new String[]{"Ruby bolt tips", "Adamant bolts"};
    String[] diamondBolts = new String[]{"Diamond bolt tips", "Adamant bolts"};
    String[] dragonstoneBolts = new String[]{"Dragonstone bolt tips", "Runite bolts"};
    String[] onyxBolts = new String[]{"Onyx bolt tips", "Runite bolts"};
    String[] amethystBolts = new String[]{"Amethyst bolt tips", "Broad bolts"};
    String[] bronzeJavelin = new String[]{"Bronze javelin heads", "Javelin shaft"};
    String[] ironJavelin = new String[]{"Iron javelin heads", "Javelin shaft"};
    String[] steelJavelin = new String[]{"Steel javelin heads", "Javelin shaft"};
    String[] mithrilJavelin = new String[]{"Mithril javelin heads", "Javelin shaft"};
    String[] adamantJavelin = new String[]{"Adamant javelin heads", "Javelin shaft"};
    String[] runeJavelin = new String[]{"Rune javelin heads", "Javelin shaft"};
    String[] amethystJavelin = new String[]{"Amethyst javelin heads", "Javelin shaft"};
    String[] dragonJavelin = new String[]{"Dragon javelin heads", "Javelin shaft"};
    int HEADLESS_ARROWS = 53;
    int DRAGON_BOLTS = 21905;
    int JAVELIN_SHAFT = 19584;
    int EMERALD_BOLTS = 9338;
    int RUBY_BOLTS_E = 9242;
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;

    protected void startUp() throws Exception {
        this.setsLeft = 0;
        this.shortTimer = 30.0f;
        this.correctOptionSelected = false;
        this.enchantingBolts = false;
        this.counter = null;
    }

    protected void shutDown() throws Exception {
        this.closeCounter();
    }

    private void updateCounter() {
        if (this.counter == null) {
            this.counter = new EfficientFletchingOverlay((BufferedImage)this.itemManager.getImage(this.imageToUse), this, this.setsLeft);
            this.infoBoxManager.addInfoBox((InfoBox)this.counter);
        } else {
            this.counter.addSets(this.setsLeft);
            this.counter.setImage((BufferedImage)this.itemManager.getImage(this.imageToUse));
            this.infoBoxManager.updateInfoBoxImage((InfoBox)this.counter);
        }
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        this.shortTimer = (float)((double)this.shortTimer - 0.6);
        if (this.shortTimer <= 0.0f) {
            this.closeCounter();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        if ((event.getSkill() == Skill.FLETCHING || event.getSkill() == Skill.MAGIC) && this.correctOptionSelected) {
            this.enchantingBolts = false;
            this.shortTimer = 30.0f;
            --this.setsLeft;
            this.updateCounter();
            if (this.setsLeft == 0) {
                this.correctOptionSelected = false;
            }
        } else {
            this.correctOptionSelected = false;
        }
    }

    public static boolean containsWords(String inputString, String[] items) {
        boolean found = true;
        for (String item : items) {
            if (inputString.contains(item)) continue;
            found = false;
            break;
        }
        return found;
    }

    private void closeCounter() {
        if (this.counter != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.counter);
            this.counter = null;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        String message = chatMessage.getMessage();
        if (this.enchantingBolts && message.equals("The magic of the runes coaxes out the true nature of the gem tips.")) {
            this.imageToUse = this.RUBY_BOLTS_E;
            this.correctOptionSelected = true;
            this.setsLeft = 10;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        String target = menuOptionClicked.getMenuTarget();
        if (EfficientFletchingPlugin.containsWords(target, this.headlessArrows) || EfficientFletchingPlugin.containsWords(target, this.bronzeArrows) || EfficientFletchingPlugin.containsWords(target, this.ironArrows) || EfficientFletchingPlugin.containsWords(target, this.steelArrows) || EfficientFletchingPlugin.containsWords(target, this.mithrilArrows) || EfficientFletchingPlugin.containsWords(target, this.broadArrows) || EfficientFletchingPlugin.containsWords(target, this.adamantArrows) || EfficientFletchingPlugin.containsWords(target, this.runeArrows) || EfficientFletchingPlugin.containsWords(target, this.amethystArrows) || EfficientFletchingPlugin.containsWords(target, this.dragonArrows)) {
            this.imageToUse = this.HEADLESS_ARROWS;
            this.correctOptionSelected = true;
            this.setsLeft = 10;
        } else if (EfficientFletchingPlugin.containsWords(target, this.opalDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.jadeDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.pearlDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.topazDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.sapphireDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.emeraldDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.rubyDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.diamondDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.dragonstoneDragonBolts) || EfficientFletchingPlugin.containsWords(target, this.onyxDragonBolts)) {
            this.imageToUse = this.DRAGON_BOLTS;
            this.correctOptionSelected = true;
            this.setsLeft = 10;
        } else if (EfficientFletchingPlugin.containsWords(target, this.opalBolts) || EfficientFletchingPlugin.containsWords(target, this.jadeBolts) || EfficientFletchingPlugin.containsWords(target, this.pearlBolts) || EfficientFletchingPlugin.containsWords(target, this.topazBolts) || EfficientFletchingPlugin.containsWords(target, this.barbBolts) || EfficientFletchingPlugin.containsWords(target, this.sapphireBolts) || EfficientFletchingPlugin.containsWords(target, this.emeraldBolts) || EfficientFletchingPlugin.containsWords(target, this.rubyBolts) || EfficientFletchingPlugin.containsWords(target, this.diamondBolts) || EfficientFletchingPlugin.containsWords(target, this.dragonstoneBolts) || EfficientFletchingPlugin.containsWords(target, this.onyxBolts) || EfficientFletchingPlugin.containsWords(target, this.amethystBolts)) {
            this.imageToUse = this.EMERALD_BOLTS;
            this.correctOptionSelected = true;
            this.setsLeft = 10;
        } else if (EfficientFletchingPlugin.containsWords(target, this.bronzeJavelin) || EfficientFletchingPlugin.containsWords(target, this.ironJavelin) || EfficientFletchingPlugin.containsWords(target, this.steelJavelin) || EfficientFletchingPlugin.containsWords(target, this.mithrilJavelin) || EfficientFletchingPlugin.containsWords(target, this.adamantJavelin) || EfficientFletchingPlugin.containsWords(target, this.runeJavelin) || EfficientFletchingPlugin.containsWords(target, this.amethystJavelin) || EfficientFletchingPlugin.containsWords(target, this.dragonJavelin)) {
            this.imageToUse = this.JAVELIN_SHAFT;
            this.correctOptionSelected = true;
            this.setsLeft = 10;
        } else if (String.valueOf(menuOptionClicked.getMenuTarget()).contains("Enchant Crossbow Bolt")) {
            this.enchantingBolts = true;
        } else if (String.valueOf(menuOptionClicked.getMenuAction()).equals("ITEM_USE_ON_WIDGET_ITEM")) {
            this.correctOptionSelected = false;
        }
    }
}

