/*
 * Decompiled with CFR 0.152.
 */
package com.raidtracker.ui;

import com.raidtracker.RaidTracker;
import com.raidtracker.ui.RaidTrackerPanel;
import com.raidtracker.ui.RaidUniques;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;

public class SplitChanger
extends JPanel {
    public final RaidTracker raidTracker;
    private final ItemManager itemManager;
    private final RaidTrackerPanel raidTrackerPanel;
    private boolean locked = false;
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public SplitChanger(ItemManager itemManager, RaidTracker raidTracker, RaidTrackerPanel raidTrackerPanel) {
        this.itemManager = itemManager;
        this.raidTracker = raidTracker;
        this.raidTrackerPanel = raidTrackerPanel;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(3, 5, 5, 5));
        this.add(this.getImagePanel());
        this.add(this.getVarPanel());
    }

    private JPanel getImagePanel() {
        AsyncBufferedImage image = this.itemManager.getImage(this.getByName(this.raidTracker.getSpecialLoot()).getItemID(), 1, false);
        JPanel iconWrapper = new JPanel();
        iconWrapper.setLayout(new BoxLayout(iconWrapper, 1));
        iconWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JLabel icon = new JLabel();
        icon.setIcon(new ImageIcon(this.resizeImage((BufferedImage)image)));
        icon.setVerticalAlignment(0);
        icon.setHorizontalAlignment(0);
        icon.setBorder(new EmptyBorder(0, 0, 0, 0));
        icon.setToolTipText(this.raidTracker.getSpecialLoot());
        image.onLoaded(() -> {
            icon.setIcon(new ImageIcon(this.resizeImage((BufferedImage)image)));
            icon.revalidate();
            icon.repaint();
        });
        JLabel date = this.textPanel(this.getDateText());
        date.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        iconWrapper.add(date);
        iconWrapper.add(Box.createRigidArea(new Dimension(0, 10)));
        iconWrapper.add(icon);
        iconWrapper.add(Box.createRigidArea(new Dimension(0, 10)));
        return iconWrapper;
    }

    private JPanel getVarPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(5, 5, 5, 0));
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel splitReceivedWrapper = new JPanel();
        splitReceivedWrapper.setLayout(new GridLayout(0, 2));
        JLabel splitReceivedLabel = this.textPanel("Split Amount: ");
        splitReceivedLabel.setHorizontalAlignment(2);
        splitReceivedWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JTextField splitReceived = this.getTextField();
        splitReceived.setText(SplitChanger.format(this.atleastZero(this.raidTracker.getLootSplitReceived())));
        splitReceived.setToolTipText(NumberFormat.getInstance().format(this.atleastZero(this.raidTracker.getLootSplitReceived())));
        splitReceived.getDocument().addDocumentListener(e -> {
            int value;
            if (!this.locked && (value = SplitChanger.parse(splitReceived.getText())) != this.raidTracker.getLootSplitReceived() && value != -5) {
                this.raidTracker.setLootSplitReceived(value);
                if (this.raidTracker.isFreeForAll()) {
                    this.raidTracker.setSpecialLootValue(value);
                } else {
                    this.raidTracker.setSpecialLootValue(value * this.raidTracker.getTeamSize());
                    this.setSplit();
                }
                splitReceived.setToolTipText(NumberFormat.getInstance().format(this.atleastZero(this.raidTracker.getLootSplitReceived())));
                this.variablesChanged();
            }
        });
        splitReceived.addActionListener(e -> splitReceived.setText(SplitChanger.format(this.atleastZero(this.raidTracker.getLootSplitReceived()))));
        splitReceivedWrapper.add(splitReceivedLabel);
        splitReceivedWrapper.add(splitReceived);
        JPanel ffaWrapper = new JPanel();
        ffaWrapper.setLayout(new GridLayout(0, 2));
        ffaWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JCheckBox ffa = new JCheckBox("FFA?");
        ffa.setBorder(new EmptyBorder(0, 15, 0, 0));
        ffa.setSelected(this.raidTracker.isFreeForAll());
        ffa.addActionListener(e -> {
            this.raidTracker.setFreeForAll(ffa.isSelected());
            this.locked = true;
            if (ffa.isSelected()) {
                this.setFFA();
            } else {
                this.setSplit();
            }
            splitReceived.setText(SplitChanger.format(this.atleastZero(this.raidTracker.getLootSplitReceived())));
            splitReceived.setToolTipText(NumberFormat.getInstance().format(this.atleastZero(this.raidTracker.getLootSplitReceived())));
            this.variablesChanged();
            this.locked = false;
        });
        JPanel ReceivedWrapper = new JPanel();
        ReceivedWrapper.setLayout(new BoxLayout(ReceivedWrapper, 1));
        ReceivedWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JLabel receivedBy = this.textPanel("received by: ");
        receivedBy.setForeground(ColorScheme.LIGHT_GRAY_COLOR.brighter());
        JLabel receiver = this.textPanel(this.fixSpaces(this.raidTracker.getSpecialLootReceiver()));
        receiver.setForeground(ColorScheme.LIGHT_GRAY_COLOR.brighter());
        ReceivedWrapper.add(receivedBy);
        ReceivedWrapper.add(receiver);
        ffaWrapper.add(ReceivedWrapper);
        ffaWrapper.add(ffa);
        JPanel teamSizeWrapper = new JPanel();
        teamSizeWrapper.setLayout(new GridLayout(0, 2));
        JLabel teamSizeLabel = this.textPanel("Team Size: ");
        teamSizeLabel.setHorizontalAlignment(2);
        teamSizeWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        SpinnerNumberModel model = new SpinnerNumberModel(Math.min(Math.max(1, this.raidTracker.getTeamSize()), 100), 1, 100, 1);
        JSpinner teamSize = new JSpinner(model);
        teamSize.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JComponent editor = teamSize.getEditor();
        JFormattedTextField spinnerTextField = ((JSpinner.DefaultEditor)editor).getTextField();
        spinnerTextField.setColumns(2);
        teamSize.addChangeListener(e -> {
            this.locked = true;
            this.raidTracker.setTeamSize(Math.min(Math.max(1, Integer.parseInt(teamSize.getValue().toString())), 100));
            this.setSplit();
            splitReceived.setText(SplitChanger.format(this.atleastZero(this.raidTracker.getLootSplitReceived())));
            splitReceived.setToolTipText(NumberFormat.getInstance().format(this.atleastZero(this.raidTracker.getLootSplitReceived())));
            this.variablesChanged();
            this.locked = false;
        });
        teamSizeWrapper.add(teamSizeLabel);
        teamSizeWrapper.add(teamSize);
        panel.add(ffaWrapper);
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        panel.add(splitReceivedWrapper);
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        panel.add(teamSizeWrapper);
        return panel;
    }

    private JTextField getTextField() {
        JTextField textField = new JTextField();
        textField.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textField.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        textField.setAlignmentX(1.0f);
        return textField;
    }

    private int atleastZero(int maybeLessThanZero) {
        return Math.max(maybeLessThanZero, 0);
    }

    private void variablesChanged() {
        this.raidTrackerPanel.setUpdateButton(true);
    }

    private void setFFA() {
        boolean inOwnName = this.raidTracker.isSpecialLootInOwnName();
        if (inOwnName) {
            this.raidTracker.setLootSplitReceived(this.raidTracker.getSpecialLootValue());
            this.raidTracker.setLootSplitPaid(-1);
        } else {
            this.raidTracker.setLootSplitPaid(-1);
            this.raidTracker.setLootSplitReceived(-1);
        }
    }

    private void setSplit() {
        boolean inOwnName = this.raidTracker.isSpecialLootInOwnName();
        int splitSize = this.raidTracker.getSpecialLootValue() / this.raidTracker.getTeamSize();
        if (!this.raidTracker.isFreeForAll()) {
            if (inOwnName) {
                this.raidTracker.setLootSplitPaid(splitSize);
            } else {
                this.raidTracker.setLootSplitPaid(-1);
            }
            this.raidTracker.setLootSplitReceived(splitSize);
        }
    }

    private JLabel textPanel(String text) {
        return this.raidTrackerPanel.textPanel(text);
    }

    private BufferedImage resizeImage(BufferedImage before) {
        return this.raidTrackerPanel.resizeImage(before, 1.75, 1);
    }

    private String getDateText() {
        LocalDate date = Instant.ofEpochMilli(this.raidTracker.getDate()).atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        LocalDate lastWeek = today.minusDays(7L);
        LocalDate lastMonth = today.minusDays(30L);
        LocalDate lastYear = today.minusDays(365L);
        String dateText = date.equals(today) ? "today" : (date.equals(yesterday) ? "yesterday" : (date.isAfter(lastWeek) ? "last week" : (date.isAfter(lastMonth) ? "last month" : (date.isAfter(lastYear) ? "last year" : "a long time ago"))));
        return dateText;
    }

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return SplitChanger.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + SplitChanger.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 1000L;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static int parse(String s) {
        if (s == null || s.length() == 0) {
            return -5;
        }
        char c = s.charAt(s.length() - 1);
        if (Character.isLetter(c)) {
            int multiplier;
            if (c == 'k') {
                multiplier = 1000;
            } else if (c == 'm') {
                multiplier = 1000000;
            } else if (c == 'b') {
                multiplier = 1000000000;
            } else {
                return -5;
            }
            String substr = s.substring(0, s.length() - 1);
            if (SplitChanger.isNumeric(substr)) {
                return (int)Math.round(Double.parseDouble(substr) * (double)multiplier);
            }
        } else if (SplitChanger.isNumeric(s)) {
            return (int)Math.round(Double.parseDouble(s));
        }
        return -5;
    }

    public static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public String fixSpaces(String s) {
        return this.unescapeJavaString(s.replace("\u00ef\u00bf\u00bd", " ").replace("\u00c2\u00a0", " "));
    }

    private RaidUniques getByName(String name) {
        EnumSet<RaidUniques> uniquesList = this.getUniquesList();
        for (RaidUniques unique : uniquesList) {
            if (!unique.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return unique;
        }
        return RaidUniques.OLMLET;
    }

    EnumSet<RaidUniques> getUniquesList() {
        if (this.raidTrackerPanel.isTob()) {
            return this.raidTrackerPanel.getTobUniques();
        }
        return this.raidTrackerPanel.getCoxUniques();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String unescapeJavaString(String st) {
        if (st == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(st.length());
        int i = 0;
        while (true) {
            block19: {
                int ch;
                block17: {
                    char nextChar;
                    block18: {
                        if (i >= st.length()) {
                            return sb.toString();
                        }
                        ch = st.charAt(i);
                        if (ch != 92) break block17;
                        char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block18;
                        String code = "" + nextChar;
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = code + st.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt(code, 8));
                        break block19;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block19;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }

    public RaidTracker getRaidTracker() {
        return this.raidTracker;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "m");
        suffixes.put(1000000000L, "b");
    }

    @FunctionalInterface
    public static interface SimpleDocumentListener
    extends DocumentListener {
        public void update(DocumentEvent var1);

        @Override
        default public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }
    }
}

