/*
 * Decompiled with CFR 0.152.
 */
package com.raidtracker.ui;

import com.raidtracker.RaidTracker;
import com.raidtracker.RaidTrackerConfig;
import com.raidtracker.RaidTrackerItem;
import com.raidtracker.filereadwriter.FileReadWriter;
import com.raidtracker.ui.RaidUniques;
import com.raidtracker.ui.SplitChanger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.api.ItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaidTrackerPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(RaidTrackerPanel.class);
    private ItemManager itemManager;
    private final FileReadWriter fw;
    private final RaidTrackerConfig config;
    private final ClientThread clientThread;
    private ArrayList<RaidTracker> RTList;
    private ArrayList<RaidTracker> tobRTList;
    private final HashMap<String, RaidTracker> UUIDMap = new LinkedHashMap<String, RaidTracker>();
    private final HashMap<String, RaidTracker> TobUUIDMap = new LinkedHashMap<String, RaidTracker>();
    private boolean loaded = false;
    private final JPanel panel = new JPanel();
    private JButton update;
    private String dateFilter = "All Time";
    private String cmFilter = "CM & Normal";
    private String mvpFilter = "Both";
    private String teamSizeFilter = "All sizes";
    private boolean isTob = false;
    private JPanel regularDrops = new JPanel();
    EnumSet<RaidUniques> tobUniques = EnumSet.of(RaidUniques.AVERNIC, new RaidUniques[]{RaidUniques.RAPIER, RaidUniques.SANGSTAFF, RaidUniques.JUSTI_FACEGUARD, RaidUniques.JUSTI_CHESTGUARD, RaidUniques.JUSTI_LEGGUARDS, RaidUniques.SCYTHE, RaidUniques.LILZIK});
    EnumSet<RaidUniques> coxUniques = EnumSet.of(RaidUniques.DEX, new RaidUniques[]{RaidUniques.ARCANE, RaidUniques.TWISTED_BUCKLER, RaidUniques.DHCB, RaidUniques.DINNY_B, RaidUniques.ANCESTRAL_HAT, RaidUniques.ANCESTRAL_TOP, RaidUniques.ANCESTRAL_BOTTOM, RaidUniques.DRAGON_CLAWS, RaidUniques.ELDER_MAUL, RaidUniques.KODAI, RaidUniques.TWISTED_BOW, RaidUniques.DUST, RaidUniques.TWISTED_KIT, RaidUniques.OLMLET});
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public RaidTrackerPanel(ItemManager itemManager, FileReadWriter fw, RaidTrackerConfig config, ClientThread clientThread) {
        this.itemManager = itemManager;
        this.fw = fw;
        this.config = config;
        this.clientThread = clientThread;
        this.panel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.add(this.panel, "North");
        this.updateView();
    }

    private void updateView() {
        this.panel.removeAll();
        JPanel title = this.getTitle();
        JPanel filterPanel = this.getFilterPanel();
        JPanel killsLoggedPanel = this.getKillsLoggedPanel();
        JPanel uniquesPanel = this.getUniquesPanel();
        JPanel pointsPanel = this.getPointsPanel();
        JPanel splitsEarnedPanel = this.getSplitsEarnedPanel();
        JPanel changePurples = this.getChangePurples();
        JPanel mvpPanel = this.getMvpPanel();
        JPanel timeSplitsPanel = this.getTimeSplitsPanel();
        if (this.config.showRegularDrops()) {
            SwingUtilities.invokeLater(() -> {
                this.regularDrops = this.getRegularDropsPanel();
                this.panel.removeAll();
                if (this.config.showTitle()) {
                    this.panel.add(title);
                }
                if (this.config.showFilters()) {
                    this.panel.add(filterPanel);
                }
                this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
                if (this.config.showKillsLogged()) {
                    this.panel.add(killsLoggedPanel);
                    this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
                }
                if (this.config.showUniquesTable()) {
                    this.panel.add((Component)uniquesPanel, "Center");
                    this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
                }
                if (this.isTob && this.config.showMVPs()) {
                    this.panel.add(mvpPanel);
                    this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
                } else if (this.config.showPoints()) {
                    this.panel.add(pointsPanel);
                    this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
                }
                if (this.config.showSplitGPEarned()) {
                    this.panel.add(splitsEarnedPanel);
                    this.panel.add(Box.createRigidArea(new Dimension(0, 15)));
                }
                if (this.config.showTimeSplits()) {
                    this.panel.add(timeSplitsPanel);
                    this.panel.add(Box.createRigidArea(new Dimension(0, 15)));
                }
                if (this.config.showRegularDrops()) {
                    this.panel.add(this.regularDrops);
                    this.panel.add(Box.createRigidArea(new Dimension(0, 15)));
                }
                if (this.config.showSplitChanger()) {
                    this.panel.add(changePurples);
                }
                this.panel.revalidate();
                this.panel.repaint();
            });
        }
        if (this.config.showTitle()) {
            this.panel.add(title);
        }
        if (this.config.showFilters()) {
            this.panel.add(filterPanel);
        }
        this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
        if (this.config.showKillsLogged()) {
            this.panel.add(killsLoggedPanel);
            this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        if (this.config.showUniquesTable()) {
            this.panel.add((Component)uniquesPanel, "Center");
            this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        if (this.isTob && this.config.showMVPs()) {
            this.panel.add(mvpPanel);
            this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
        } else if (this.config.showPoints()) {
            this.panel.add(pointsPanel);
            this.panel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        if (this.config.showSplitGPEarned()) {
            this.panel.add(splitsEarnedPanel);
            this.panel.add(Box.createRigidArea(new Dimension(0, 15)));
        }
        if (this.config.showTimeSplits()) {
            this.panel.add(timeSplitsPanel);
            this.panel.add(Box.createRigidArea(new Dimension(0, 15)));
        }
        if (this.config.showRegularDrops()) {
            this.panel.add(this.regularDrops);
            this.panel.add(Box.createRigidArea(new Dimension(0, 15)));
        }
        if (this.config.showSplitChanger()) {
            this.panel.add(changePurples);
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private JPanel getTitle() {
        JPanel title = new JPanel();
        title.setBorder(new EmptyBorder(3, 0, 10, 0));
        title.setLayout(new BoxLayout(title, 1));
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.setLayout(new GridLayout(0, 2));
        buttonWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel coxButtonWrapper = new JPanel();
        coxButtonWrapper.setLayout(new GridLayout(0, 1));
        JButton coxButton = new JButton();
        coxButton.setText("Chambers of Xeric");
        coxButton.setForeground(Color.white);
        coxButton.setFont(FontManager.getRunescapeSmallFont());
        coxButton.setContentAreaFilled(false);
        coxButton.setOpaque(false);
        coxButton.setFocusable(false);
        coxButton.setBorderPainted(false);
        coxButton.setBorder(new EmptyBorder(10, 0, 10, 0));
        if (this.isTob) {
            coxButtonWrapper.setBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.LIGHT_GRAY_COLOR.darker()));
        } else {
            coxButtonWrapper.setBorder(new MatteBorder(1, 1, 0, 1, ColorScheme.LIGHT_GRAY_COLOR.darker()));
        }
        coxButton.setFocusPainted(false);
        coxButton.setToolTipText("Show Chambers of Xeric Loot");
        coxButton.addActionListener(e -> {
            if (this.isTob) {
                this.isTob = false;
                this.updateView();
            }
        });
        JPanel tobButtonWrapper = new JPanel();
        tobButtonWrapper.setLayout(new GridLayout(0, 1));
        JButton tobButton = new JButton();
        tobButton.setText("Theatre of Blood");
        tobButton.setForeground(Color.white);
        tobButton.setFont(FontManager.getRunescapeSmallFont());
        tobButton.setContentAreaFilled(false);
        tobButton.setFocusable(false);
        tobButton.setBorderPainted(false);
        tobButton.setBorder(new EmptyBorder(7, 0, 7, 0));
        if (this.isTob) {
            tobButtonWrapper.setBorder(new MatteBorder(1, 1, 0, 1, ColorScheme.LIGHT_GRAY_COLOR.darker()));
            coxButton.setOpaque(false);
        } else {
            tobButtonWrapper.setBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.LIGHT_GRAY_COLOR.darker()));
        }
        tobButton.setFocusPainted(false);
        tobButton.setToolTipText("Show Theatre of Blood Loot");
        tobButton.addActionListener(e -> {
            if (!this.isTob) {
                this.isTob = true;
                this.updateView();
            }
        });
        coxButtonWrapper.add(coxButton);
        tobButtonWrapper.add(tobButton);
        buttonWrapper.add(coxButtonWrapper);
        buttonWrapper.add(tobButtonWrapper);
        JPanel titleLabelWrapper = new JPanel();
        JLabel titleLabel = new JLabel("COX and TOB Data Tracker");
        titleLabel.setForeground(Color.WHITE);
        titleLabel.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.LIGHT_GRAY_COLOR.darker()), new EmptyBorder(0, 20, 5, 20)));
        titleLabelWrapper.add((Component)titleLabel, "Center");
        title.add(titleLabelWrapper);
        title.add(buttonWrapper);
        return title;
    }

    private JPanel getUniquesPanel() {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 1));
        JPanel title = new JPanel();
        title.setLayout(new GridLayout(0, 3));
        title.setBorder(new EmptyBorder(3, 3, 3, 3));
        title.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel drop = this.textPanel("Drop");
        JLabel titleSeen = this.textPanel("Seen");
        JLabel titleReceived = this.textPanel("Received");
        title.add(drop);
        title.add(titleReceived);
        title.add(titleSeen);
        JPanel uniques = new JPanel();
        uniques.setLayout(new GridLayout(0, 3));
        uniques.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        uniques.setBorder(new EmptyBorder(5, 5, 5, 5));
        int totalUniques = 0;
        int totalOwnName = 0;
        for (RaidUniques unique : this.getUniquesList()) {
            ArrayList<RaidTracker> l2;
            ArrayList<RaidTracker> l;
            boolean isKit = false;
            boolean isDust = false;
            boolean isPet = false;
            AsyncBufferedImage image = this.itemManager.getImage(unique.getItemID(), 1, false);
            JLabel icon = new JLabel();
            icon.setIcon(new ImageIcon(this.resizeImage((BufferedImage)image, 0.7, 2)));
            uniques.add(icon);
            image.onLoaded(() -> {
                icon.setIcon(new ImageIcon(this.resizeImage((BufferedImage)image, 0.7, 2)));
                icon.revalidate();
                icon.repaint();
            });
            switch (unique.getName()) {
                case "Metamorphic Dust": {
                    l = this.filterDustReceivers();
                    l2 = this.filterOwnDusts(l);
                    isDust = true;
                    break;
                }
                case "Twisted Kit": {
                    l = this.filterKitReceivers();
                    l2 = this.filterOwnKits(l);
                    isKit = true;
                    break;
                }
                case "Olmlet": 
                case "Lil' Zik": {
                    l = this.filterPetReceivers();
                    l2 = this.filterOwnPets(l);
                    isPet = true;
                    break;
                }
                default: {
                    l = this.filterRTListByName(unique.getName());
                    l2 = this.filterOwnDrops(l);
                }
            }
            String amountSeen = Integer.toString(l.size());
            String amountReceived = Integer.toString(l2.size());
            JLabel received = new JLabel(amountReceived, 2);
            JLabel seen = new JLabel(amountSeen, 2);
            received.setForeground(Color.WHITE);
            received.setFont(FontManager.getRunescapeSmallFont());
            seen.setForeground(Color.WHITE);
            seen.setFont(FontManager.getRunescapeSmallFont());
            String tooltip = this.getUniqueToolTip(unique, l.size(), l2.size());
            if (!(isDust || isKit || isPet)) {
                totalUniques += l.size();
                totalOwnName += l2.size();
            }
            int bottomBorder = 1;
            if (isPet) {
                bottomBorder = 0;
            }
            icon.setToolTipText(tooltip);
            icon.setBorder(new MatteBorder(0, 0, bottomBorder, 1, ColorScheme.LIGHT_GRAY_COLOR.darker()));
            icon.setVerticalAlignment(0);
            icon.setHorizontalAlignment(0);
            received.setToolTipText(tooltip);
            received.setBorder(new MatteBorder(0, 0, bottomBorder, 1, ColorScheme.LIGHT_GRAY_COLOR.darker()));
            received.setVerticalAlignment(0);
            received.setHorizontalAlignment(0);
            seen.setToolTipText(tooltip);
            seen.setBorder(new MatteBorder(0, 0, bottomBorder, 0, ColorScheme.LIGHT_GRAY_COLOR.darker()));
            seen.setVerticalAlignment(0);
            seen.setHorizontalAlignment(0);
            uniques.add(received);
            uniques.add(seen);
        }
        JPanel total = new JPanel();
        total.setLayout(new GridLayout(0, 3));
        total.setBorder(new EmptyBorder(3, 3, 3, 3));
        total.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel totalText = this.textPanel("Total Purples:");
        JLabel totalOwnNameLabel = this.textPanel(Integer.toString(totalOwnName));
        JLabel totalUniquesLabel = this.textPanel(Integer.toString(totalUniques));
        total.add(totalText);
        total.add(totalOwnNameLabel);
        total.add(totalUniquesLabel);
        wrapper.add(title);
        wrapper.add(uniques);
        wrapper.add(total);
        return wrapper;
    }

    private JPanel getPointsPanel() {
        JPanel points = new JPanel();
        points.setLayout(new GridLayout(0, 2));
        points.setBorder(new EmptyBorder(3, 3, 3, 3));
        points.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel personalTitle = this.textPanel("Personal Points");
        JLabel totalTitle = this.textPanel("Total Points");
        points.add(personalTitle);
        points.add(totalTitle);
        int personalPoints = 0;
        int totalPoints = 0;
        if (this.loaded) {
            personalPoints = this.atleastZero(this.getFilteredRTList().stream().mapToInt(RaidTracker::getPersonalPoints).sum());
            totalPoints = this.atleastZero(this.getFilteredRTList().stream().mapToInt(RaidTracker::getTotalPoints).sum());
        }
        JLabel personalPointsLabel = this.textPanel(RaidTrackerPanel.format(personalPoints));
        personalPointsLabel.setToolTipText(NumberFormat.getInstance().format(personalPoints) + " Personal Points");
        personalTitle.setToolTipText(NumberFormat.getInstance().format(personalPoints) + " Personal Points");
        JLabel totalPointsLabel = this.textPanel(RaidTrackerPanel.format(totalPoints));
        totalPointsLabel.setToolTipText(NumberFormat.getInstance().format(totalPoints) + " Total Points");
        totalTitle.setToolTipText(NumberFormat.getInstance().format(totalPoints) + " Total Points");
        points.add(personalPointsLabel);
        points.add(totalPointsLabel);
        return points;
    }

    private JPanel getSplitsEarnedPanel() {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridLayout(0, 2));
        wrapper.setBorder(new EmptyBorder(3, 3, 3, 3));
        wrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        int splitGP = 0;
        if (this.loaded) {
            splitGP = this.atleastZero(this.getFilteredRTList().stream().mapToInt(RaidTracker::getLootSplitReceived).sum());
        }
        JLabel textLabel = this.textPanel("Split GP earned:");
        textLabel.setToolTipText("GP earned counting the split GP you earned from a drop");
        JLabel valueLabel = this.textPanel(RaidTrackerPanel.format(splitGP));
        valueLabel.setToolTipText(NumberFormat.getInstance().format(splitGP) + " gp");
        if (splitGP > 1000000) {
            valueLabel.setForeground(Color.GREEN);
        }
        wrapper.add(textLabel);
        wrapper.add(valueLabel);
        return wrapper;
    }

    private JPanel getKillsLoggedPanel() {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridLayout(0, 2));
        wrapper.setBorder(new EmptyBorder(3, 3, 3, 3));
        wrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        int killsLogged = 0;
        if (this.loaded) {
            killsLogged = this.getDistinctKills(this.getFilteredRTList()).size();
        }
        JLabel textLabel = this.textPanel("Kills Logged:");
        JLabel valueLabel = this.textPanel(Integer.toString(killsLogged));
        wrapper.add(textLabel);
        wrapper.add(valueLabel);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPanel getRegularDropsPanel() {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 1));
        if (this.loaded) {
            HashMap<Integer, Integer> priceMap;
            Map<Object, Object> uniqueIDs = new HashMap();
            try {
                uniqueIDs = this.getDistinctRegularDrops().get();
                priceMap = new HashMap<Integer, Integer>();
            }
            catch (InterruptedException | ExecutionException e) {
                HashMap<Integer, Integer> priceMap2;
                try {
                    uniqueIDs = new HashMap();
                    priceMap2 = new HashMap<Integer, Integer>();
                }
                catch (Throwable throwable) {
                    HashMap<Integer, Integer> priceMap3 = new HashMap<Integer, Integer>();
                    for (RaidTrackerItem raidTrackerItem : uniqueIDs.values()) {
                        priceMap3.put(raidTrackerItem.getId(), raidTrackerItem.getPrice());
                    }
                    if (uniqueIDs.values().size() > 0) {
                        for (RaidTracker raidTracker : this.getFilteredRTList()) {
                            for (RaidTrackerItem raidTrackerItem : raidTracker.getLootList()) {
                                RaidTrackerItem raidTrackerItem2 = (RaidTrackerItem)uniqueIDs.get(raidTrackerItem.getId());
                                if (raidTrackerItem2 == null || raidTrackerItem2.getId() == 12073) continue;
                                int qty = raidTrackerItem2.getQuantity();
                                raidTrackerItem2.setQuantity(qty + raidTrackerItem.getQuantity());
                                raidTrackerItem2.setPrice((Integer)priceMap3.get(raidTrackerItem.getId()) * raidTrackerItem2.getQuantity());
                                uniqueIDs.replace(raidTrackerItem.getId(), raidTrackerItem2);
                            }
                        }
                        ArrayList<Object> regularDropsList = new ArrayList<Object>(uniqueIDs.values());
                        regularDropsList.sort((o2, o1) -> Integer.compare(o1.getPrice(), o2.getPrice()));
                        int n = regularDropsList.stream().mapToInt(RaidTrackerItem::getPrice).sum();
                        JPanel drops = new JPanel();
                        drops.setLayout(new GridLayout(0, 5));
                        for (RaidTrackerItem raidTrackerItem : regularDropsList) {
                            AsyncBufferedImage image = this.itemManager.getImage(raidTrackerItem.getId(), raidTrackerItem.getQuantity(), raidTrackerItem.getQuantity() > 1);
                            JPanel iconWrapper = new JPanel();
                            iconWrapper.setPreferredSize(new Dimension(40, 40));
                            iconWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                            JLabel icon = new JLabel();
                            image.addTo(icon);
                            icon.setBorder(new EmptyBorder(0, 5, 0, 0));
                            image.onLoaded(() -> {
                                image.addTo(icon);
                                icon.revalidate();
                                icon.repaint();
                            });
                            iconWrapper.add((Component)icon, "Center");
                            iconWrapper.setBorder(new MatteBorder(1, 0, 0, 1, ColorScheme.DARK_GRAY_COLOR));
                            iconWrapper.setToolTipText(this.getRegularToolTip(raidTrackerItem));
                            drops.add(iconWrapper);
                        }
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new GridLayout(0, 2));
                        jPanel.setBorder(new EmptyBorder(3, 20, 3, 10));
                        jPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
                        JLabel jLabel = this.textPanel("Regular Drops");
                        jLabel.setHorizontalAlignment(2);
                        JLabel valueLabel = this.textPanel(RaidTrackerPanel.format(n) + " gp");
                        valueLabel.setHorizontalAlignment(4);
                        valueLabel.setForeground(Color.LIGHT_GRAY.darker());
                        valueLabel.setToolTipText(NumberFormat.getInstance().format(n));
                        jPanel.add(jLabel);
                        jPanel.add(valueLabel);
                        wrapper.add(jPanel);
                        wrapper.add(drops);
                    }
                    throw throwable;
                }
                for (RaidTrackerItem raidTrackerItem : uniqueIDs.values()) {
                    priceMap2.put(raidTrackerItem.getId(), raidTrackerItem.getPrice());
                }
                if (uniqueIDs.values().size() > 0) {
                    for (RaidTracker raidTracker : this.getFilteredRTList()) {
                        for (RaidTrackerItem raidTrackerItem : raidTracker.getLootList()) {
                            RaidTrackerItem raidTrackerItem3 = (RaidTrackerItem)uniqueIDs.get(raidTrackerItem.getId());
                            if (raidTrackerItem3 == null || raidTrackerItem3.getId() == 12073) continue;
                            int qty = raidTrackerItem3.getQuantity();
                            raidTrackerItem3.setQuantity(qty + raidTrackerItem.getQuantity());
                            raidTrackerItem3.setPrice((Integer)priceMap2.get(raidTrackerItem.getId()) * raidTrackerItem3.getQuantity());
                            uniqueIDs.replace(raidTrackerItem.getId(), raidTrackerItem3);
                        }
                    }
                    ArrayList<Object> regularDropsList = new ArrayList<Object>(uniqueIDs.values());
                    regularDropsList.sort((o2, o1) -> Integer.compare(o1.getPrice(), o2.getPrice()));
                    int n = regularDropsList.stream().mapToInt(RaidTrackerItem::getPrice).sum();
                    JPanel drops = new JPanel();
                    drops.setLayout(new GridLayout(0, 5));
                    Iterator iterator = regularDropsList.iterator();
                    while (iterator.hasNext()) {
                        RaidTrackerItem raidTrackerItem = (RaidTrackerItem)iterator.next();
                        AsyncBufferedImage image = this.itemManager.getImage(raidTrackerItem.getId(), raidTrackerItem.getQuantity(), raidTrackerItem.getQuantity() > 1);
                        JPanel iconWrapper = new JPanel();
                        iconWrapper.setPreferredSize(new Dimension(40, 40));
                        iconWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                        JLabel icon = new JLabel();
                        image.addTo(icon);
                        icon.setBorder(new EmptyBorder(0, 5, 0, 0));
                        image.onLoaded(() -> {
                            image.addTo(icon);
                            icon.revalidate();
                            icon.repaint();
                        });
                        iconWrapper.add((Component)icon, "Center");
                        iconWrapper.setBorder(new MatteBorder(1, 0, 0, 1, ColorScheme.DARK_GRAY_COLOR));
                        iconWrapper.setToolTipText(this.getRegularToolTip(raidTrackerItem));
                        drops.add(iconWrapper);
                    }
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new GridLayout(0, 2));
                    jPanel.setBorder(new EmptyBorder(3, 20, 3, 10));
                    jPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
                    JLabel jLabel = this.textPanel("Regular Drops");
                    jLabel.setHorizontalAlignment(2);
                    JLabel valueLabel = this.textPanel(RaidTrackerPanel.format(n) + " gp");
                    valueLabel.setHorizontalAlignment(4);
                    valueLabel.setForeground(Color.LIGHT_GRAY.darker());
                    valueLabel.setToolTipText(NumberFormat.getInstance().format(n));
                    jPanel.add(jLabel);
                    jPanel.add(valueLabel);
                    wrapper.add(jPanel);
                    wrapper.add(drops);
                }
            }
            for (RaidTrackerItem raidTrackerItem : uniqueIDs.values()) {
                priceMap.put(raidTrackerItem.getId(), raidTrackerItem.getPrice());
            }
            if (uniqueIDs.values().size() > 0) {
                for (RaidTracker raidTracker : this.getFilteredRTList()) {
                    for (RaidTrackerItem raidTrackerItem : raidTracker.getLootList()) {
                        RaidTrackerItem raidTrackerItem4 = (RaidTrackerItem)uniqueIDs.get(raidTrackerItem.getId());
                        if (raidTrackerItem4 == null || raidTrackerItem4.getId() == 12073) continue;
                        int qty = raidTrackerItem4.getQuantity();
                        raidTrackerItem4.setQuantity(qty + raidTrackerItem.getQuantity());
                        raidTrackerItem4.setPrice((Integer)priceMap.get(raidTrackerItem.getId()) * raidTrackerItem4.getQuantity());
                        uniqueIDs.replace(raidTrackerItem.getId(), raidTrackerItem4);
                    }
                }
                ArrayList<Object> regularDropsList = new ArrayList<Object>(uniqueIDs.values());
                regularDropsList.sort((o2, o1) -> Integer.compare(o1.getPrice(), o2.getPrice()));
                int n = regularDropsList.stream().mapToInt(RaidTrackerItem::getPrice).sum();
                JPanel drops = new JPanel();
                drops.setLayout(new GridLayout(0, 5));
                for (RaidTrackerItem raidTrackerItem : regularDropsList) {
                    AsyncBufferedImage image = this.itemManager.getImage(raidTrackerItem.getId(), raidTrackerItem.getQuantity(), raidTrackerItem.getQuantity() > 1);
                    JPanel iconWrapper = new JPanel();
                    iconWrapper.setPreferredSize(new Dimension(40, 40));
                    iconWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                    JLabel icon = new JLabel();
                    image.addTo(icon);
                    icon.setBorder(new EmptyBorder(0, 5, 0, 0));
                    image.onLoaded(() -> {
                        image.addTo(icon);
                        icon.revalidate();
                        icon.repaint();
                    });
                    iconWrapper.add((Component)icon, "Center");
                    iconWrapper.setBorder(new MatteBorder(1, 0, 0, 1, ColorScheme.DARK_GRAY_COLOR));
                    iconWrapper.setToolTipText(this.getRegularToolTip(raidTrackerItem));
                    drops.add(iconWrapper);
                }
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(0, 2));
                jPanel.setBorder(new EmptyBorder(3, 20, 3, 10));
                jPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
                JLabel jLabel = this.textPanel("Regular Drops");
                jLabel.setHorizontalAlignment(2);
                JLabel valueLabel = this.textPanel(RaidTrackerPanel.format(n) + " gp");
                valueLabel.setHorizontalAlignment(4);
                valueLabel.setForeground(Color.LIGHT_GRAY.darker());
                valueLabel.setToolTipText(NumberFormat.getInstance().format(n));
                jPanel.add(jLabel);
                jPanel.add(valueLabel);
                wrapper.add(jPanel);
                wrapper.add(drops);
            }
        }
        return wrapper;
    }

    private JPanel getChangePurples() {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 1));
        ArrayList<SplitChanger> SCList = new ArrayList<SplitChanger>();
        JPanel titleWrapper = new JPanel();
        titleWrapper.setLayout(new GridBagLayout());
        titleWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        titleWrapper.setBorder(new EmptyBorder(3, 3, 3, 3));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        JLabel changes = this.textPanel("Change Purple Splits");
        changes.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.update = new JButton();
        this.update.setText("Update");
        this.update.setFont(FontManager.getRunescapeSmallFont());
        this.update.setPreferredSize(new Dimension(60, 20));
        this.update.setEnabled(false);
        this.update.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.update.setFocusPainted(false);
        this.update.setToolTipText("Nothing to update");
        this.update.addActionListener(e -> {
            if (this.isTob) {
                SCList.forEach(SC -> {
                    RaidTracker tempRaidTracker = SC.getRaidTracker();
                    this.TobUUIDMap.put(tempRaidTracker.getUniqueID(), tempRaidTracker);
                });
                this.tobRTList = new ArrayList<RaidTracker>(this.TobUUIDMap.values());
                this.fw.updateRTList(this.tobRTList, true);
            } else {
                SCList.forEach(SC -> {
                    RaidTracker tempRaidTracker = SC.getRaidTracker();
                    this.UUIDMap.put(tempRaidTracker.getUniqueID(), tempRaidTracker);
                });
                this.RTList = new ArrayList<RaidTracker>(this.UUIDMap.values());
                this.fw.updateRTList(this.RTList);
            }
            this.updateView();
        });
        c.anchor = 17;
        titleWrapper.add((Component)changes, c);
        ++c.gridx;
        c.anchor = 13;
        titleWrapper.add((Component)this.update, c);
        if (this.loaded) {
            ArrayList<RaidTracker> purpleList = this.filterPurples();
            purpleList.sort((o2, o1) -> Long.compare(o1.getDate(), o2.getDate()));
            if (purpleList.size() > 0) {
                wrapper.add(titleWrapper);
                wrapper.add(Box.createRigidArea(new Dimension(0, 2)));
                for (int i = 0; i < Math.min(purpleList.size(), 10); ++i) {
                    RaidTracker RT = purpleList.get(i);
                    SplitChanger SC = new SplitChanger(this.itemManager, RT, this);
                    SCList.add(SC);
                    wrapper.add(SC);
                    wrapper.add(Box.createRigidArea(new Dimension(0, 7)));
                }
            }
        }
        return wrapper;
    }

    private JPanel getFilterPanel() {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridBagLayout());
        wrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        wrapper.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel filter = this.textPanel("Filter kills logged");
        filter.setHorizontalAlignment(2);
        filter.setBorder(new EmptyBorder(0, 0, 0, 17));
        c.anchor = 17;
        wrapper.add(filter);
        JComboBox<String> choices = new JComboBox<String>(new String[]{"All Time", "12 Hours", "Today", "3 Days", "Week", "Month", "3 Months", "Year", "X Kills"});
        choices.setSelectedItem(this.dateFilter);
        choices.setPreferredSize(new Dimension(100, 25));
        choices.setFocusable(false);
        choices.addActionListener(e -> {
            this.dateFilter = choices.getSelectedItem().toString();
            if (this.dateFilter.equals("X Kills")) {
                choices.setToolTipText("X can be changed in the settings");
            } else {
                choices.setToolTipText(null);
            }
            if (this.loaded) {
                this.updateView();
            }
        });
        JComboBox<String> cm = new JComboBox<String>(new String[]{"CM & Normal", "Normal Only", "CM Only"});
        cm.setFocusable(false);
        cm.setPreferredSize(new Dimension(110, 25));
        cm.setSelectedItem(this.cmFilter);
        cm.addActionListener(e -> {
            this.cmFilter = cm.getSelectedItem().toString();
            if (this.loaded) {
                this.updateView();
            }
        });
        JComboBox<String> mvp = new JComboBox<String>(new String[]{"Both", "My MVP", "Not My MVP"});
        mvp.setFocusable(false);
        mvp.setPreferredSize(new Dimension(110, 25));
        mvp.setSelectedItem(this.mvpFilter);
        mvp.addActionListener(e -> {
            this.mvpFilter = mvp.getSelectedItem().toString();
            if (this.loaded) {
                this.updateView();
            }
        });
        JComboBox<String> teamSize = this.isTob ? new JComboBox<String>(new String[]{"All sizes", "Solo", "Duo", "Trio", "4-man", "5-man"}) : new JComboBox<String>(new String[]{"All sizes", "Solo", "Duo", "Trio", "4-man", "5-man", "6-man", "7-man", "8-10 Players", "11-14 Players", "15-24 Players", "24+ Players"});
        teamSize.setFocusable(false);
        teamSize.setPreferredSize(new Dimension(110, 25));
        teamSize.setSelectedItem(this.teamSizeFilter);
        teamSize.addActionListener(e -> {
            this.teamSizeFilter = teamSize.getSelectedItem().toString();
            if (this.loaded) {
                this.updateView();
            }
        });
        c.gridy = 1;
        wrapper.add(Box.createRigidArea(new Dimension(0, 5)), c);
        c.gridy = 2;
        wrapper.add(choices, c);
        c.gridx = 1;
        c.anchor = 13;
        if (this.isTob) {
            wrapper.add(mvp, c);
        } else {
            wrapper.add(cm, c);
        }
        c.gridy = 3;
        wrapper.add(Box.createRigidArea(new Dimension(0, 2)), c);
        c.gridy = 4;
        wrapper.add(teamSize, c);
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.setPreferredSize(new Dimension(50, 20));
        buttonWrapper.setLayout(new GridLayout(0, 2, 2, 0));
        buttonWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        final BufferedImage refreshIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"refresh-grey.png");
        final BufferedImage refreshHover = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"refresh-white.png");
        final BufferedImage deleteIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"delete-grey.png");
        final BufferedImage deleteHover = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"delete-white.png");
        final JButton refresh = this.imageButton(refreshIcon);
        refresh.setToolTipText("Refresh kills logged");
        refresh.addActionListener(e -> {
            if (this.loaded) {
                this.loadRTList();
            }
        });
        final JButton delete = this.imageButton(deleteIcon);
        delete.setToolTipText("Delete all logged kills");
        delete.addActionListener(e -> {
            if (this.loaded) {
                this.clearData();
            }
        });
        refresh.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                refresh.setIcon(new ImageIcon(refreshHover));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                refresh.setIcon(new ImageIcon(refreshIcon));
            }
        });
        delete.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                delete.setIcon(new ImageIcon(deleteHover));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                delete.setIcon(new ImageIcon(deleteIcon));
            }
        });
        buttonWrapper.add(refresh);
        buttonWrapper.add(delete);
        c.gridy = 0;
        wrapper.add((Component)buttonWrapper, c);
        return wrapper;
    }

    private JPanel getMvpPanel() {
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridLayout(0, 2));
        wrapper.setBorder(new EmptyBorder(3, 3, 3, 3));
        wrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        int mvpAmount = 0;
        if (this.loaded) {
            mvpAmount = this.tobRTList.stream().mapToInt(RT -> {
                if (RT.isMvpInOwnName()) {
                    return 1;
                }
                return 0;
            }).sum();
        }
        JLabel textLabel = this.textPanel("Total MVP's:");
        JLabel valueLabel = this.textPanel(Integer.toString(mvpAmount));
        wrapper.add(textLabel);
        wrapper.add(valueLabel);
        return wrapper;
    }

    private JPanel getTimeSplitsPanel() {
        JPanel wrapper = new JPanel();
        if (this.loaded) {
            wrapper.setLayout(new BoxLayout(wrapper, 1));
            wrapper.setBorder(new EmptyBorder(3, 0, 0, 0));
            wrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            JPanel title = new JPanel();
            title.setBorder(new EmptyBorder(3, 20, 3, 10));
            title.setLayout(new GridLayout(0, 1));
            title.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            JLabel textLabel = this.textPanel("Best Recorded Times");
            title.add(textLabel);
            JPanel timeTable = new JPanel();
            timeTable.setLayout(new GridLayout(0, 2));
            timeTable.setBorder(new EmptyBorder(5, 3, 1, 3));
            timeTable.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (this.isTob) {
                timeTable.add(this.textPanel("Maiden Time", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getMaidenTime() > 0).min(Comparator.comparing(RaidTracker::getMaidenTime)).orElse(new RaidTracker()).getMaidenTime()), 1));
                timeTable.add(this.textPanel("Bloat Time", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getBloatTime() > 0).min(Comparator.comparing(RaidTracker::getBloatTime)).orElse(new RaidTracker()).getBloatTime()), 1));
                timeTable.add(this.textPanel("Nylo Time", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getNyloTime() > 0).min(Comparator.comparing(RaidTracker::getNyloTime)).orElse(new RaidTracker()).getNyloTime()), 1));
                timeTable.add(this.textPanel("Sotetseg Time", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getSotetsegTime() > 0).min(Comparator.comparing(RaidTracker::getSotetsegTime)).orElse(new RaidTracker()).getSotetsegTime()), 1));
                timeTable.add(this.textPanel("Xarpus Time", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getNyloTime() > 0).min(Comparator.comparing(RaidTracker::getXarpusTime)).orElse(new RaidTracker()).getXarpusTime()), 1));
                timeTable.add(this.textPanel("Verzik Time", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getVerzikTime() > 0).min(Comparator.comparing(RaidTracker::getVerzikTime)).orElse(new RaidTracker()).getVerzikTime()), 1));
            } else {
                int middleTime;
                timeTable.add(this.textPanel("Upper Level", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getUpperTime() > 0).min(Comparator.comparing(RaidTracker::getUpperTime)).orElse(new RaidTracker()).getUpperTime()), 1));
                if (!this.cmFilter.equals("Normal Only") && (middleTime = this.getFilteredRTList().stream().filter(RT -> RT.getMiddleTime() > 0).filter(RT -> RT.getMiddleTime() > 0).min(Comparator.comparing(RaidTracker::getMiddleTime)).orElse(new RaidTracker()).getMiddleTime()) > 0) {
                    timeTable.add(this.textPanel("Middle Level", 0));
                    timeTable.add(this.textPanel(this.secondsToMinuteString(middleTime), 1));
                }
                timeTable.add(this.textPanel("Lower Level", 0));
                timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getLowerTime() > 0).min(Comparator.comparing(RaidTracker::getLowerTime)).orElse(new RaidTracker()).getLowerTime()), 1));
                timeTable.add(this.textPanel("Olm Time", 0));
                RaidTracker olmTimeRT = this.getFilteredRTList().stream().filter(RT -> RT.getLowerTime() > 0 && RT.getRaidTime() > 0).min(Comparator.comparingInt(o -> o.getRaidTime() - o.getLowerTime())).orElse(new RaidTracker());
                timeTable.add(this.textPanel(this.secondsToMinuteString(olmTimeRT.getRaidTime() - olmTimeRT.getLowerTime()), 1));
            }
            timeTable.add(this.textPanel("Overall Time", 2));
            timeTable.add(this.textPanel(this.secondsToMinuteString(this.getFilteredRTList().stream().filter(RT -> RT.getRaidTime() > 0).min(Comparator.comparing(RaidTracker::getRaidTime)).orElse(new RaidTracker()).getRaidTime()), 3));
            wrapper.add(title);
            wrapper.add(timeTable);
        }
        return wrapper;
    }

    public void setUpdateButton(boolean b) {
        this.update.setEnabled(b);
        this.update.setBackground(ColorScheme.BRAND_ORANGE);
        this.update.setToolTipText("Update");
    }

    public JLabel textPanel(String text) {
        JLabel label = new JLabel();
        label.setText(text);
        label.setForeground(Color.WHITE);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
        label.setFont(FontManager.getRunescapeSmallFont());
        return label;
    }

    public JLabel textPanel(String text, int borderOptions) {
        JLabel label = new JLabel();
        label.setText(text);
        label.setForeground(Color.WHITE);
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
        label.setFont(FontManager.getRunescapeSmallFont());
        if (borderOptions == 0) {
            label.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 1, ColorScheme.LIGHT_GRAY_COLOR.darker()), new EmptyBorder(5, 3, 5, 3)));
        } else if (borderOptions == 1) {
            label.setBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.LIGHT_GRAY_COLOR.darker()));
        } else if (borderOptions == 2) {
            label.setBorder(new MatteBorder(0, 0, 0, 1, ColorScheme.LIGHT_GRAY_COLOR.darker()));
        } else {
            label.setBorder(new MatteBorder(0, 0, 0, 0, ColorScheme.LIGHT_GRAY_COLOR.darker()));
        }
        return label;
    }

    public BufferedImage resizeImage(BufferedImage before, double scale, int af) {
        int w = before.getWidth();
        int h = before.getHeight();
        int w2 = (int)((double)w * scale);
        int h2 = (int)((double)h * scale);
        BufferedImage after = new BufferedImage(w2, h2, before.getType());
        AffineTransform scaleInstance = AffineTransform.getScaleInstance(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(scaleInstance, af);
        scaleOp.filter(before, after);
        return after;
    }

    public JButton imageButton(BufferedImage image) {
        JButton b = new JButton();
        b.setIcon(new ImageIcon(image));
        b.setOpaque(false);
        b.setContentAreaFilled(false);
        b.setBorderPainted(false);
        b.setFocusPainted(false);
        return b;
    }

    public void loadRTList() {
        this.RTList = this.fw.readFromFile();
        for (RaidTracker RT : this.RTList) {
            this.UUIDMap.put(RT.getUniqueID(), RT);
        }
        this.tobRTList = this.fw.readFromFile(true);
        for (RaidTracker RT : this.tobRTList) {
            this.TobUUIDMap.put(RT.getUniqueID(), RT);
        }
        this.loaded = true;
        this.updateView();
    }

    public ArrayList<RaidTracker> filterRTListByName(String name) {
        if (this.loaded) {
            return this.getFilteredRTList().stream().filter(RT -> name.toLowerCase().equals(RT.getSpecialLoot().toLowerCase())).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterKitReceivers() {
        if (this.loaded) {
            return this.getFilteredRTList().stream().filter(RT -> !RT.getKitReceiver().isEmpty()).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterDustReceivers() {
        if (this.loaded) {
            return this.getFilteredRTList().stream().filter(RT -> !RT.getDustReceiver().isEmpty()).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterPetReceivers() {
        if (this.loaded) {
            return this.getFilteredRTList().stream().filter(RT -> !RT.getPetReceiver().isEmpty()).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterOwnDrops(ArrayList<RaidTracker> l) {
        if (this.loaded) {
            return l.stream().filter(RT -> {
                if (RT.getSpecialLoot().isEmpty() || RT.getLootList().size() == 0) {
                    return false;
                }
                return RT.getLootList().get(0).getId() == this.getByName(RT.getSpecialLoot()).getItemID();
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterOwnKits(ArrayList<RaidTracker> l) {
        if (this.loaded) {
            return l.stream().filter(RT -> RT.getLootList().stream().anyMatch(loot -> loot.getId() == 24670)).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterOwnDusts(ArrayList<RaidTracker> l) {
        if (this.loaded) {
            return l.stream().filter(RT -> RT.getLootList().stream().anyMatch(loot -> loot.getId() == 22386)).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterOwnPets(ArrayList<RaidTracker> l) {
        if (this.loaded) {
            return l.stream().filter(RaidTracker::isPetInMyName).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public ArrayList<RaidTracker> filterPurples() {
        if (this.loaded) {
            return this.getFilteredRTList().stream().filter(RT -> {
                for (RaidUniques unique : this.getUniquesList()) {
                    if (!unique.getName().toLowerCase().equals(RT.getSpecialLoot().toLowerCase())) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        return new ArrayList<RaidTracker>();
    }

    public String getUniqueToolTip(RaidUniques unique, int amountSeen, int amountReceived) {
        return "<html>" + unique.getName() + "<br>Received: " + amountReceived + "x<br>Seen: " + amountSeen + "x";
    }

    public String getRegularToolTip(RaidTrackerItem drop) {
        return "<html>" + drop.getName() + " x " + drop.getQuantity() + "<br>Price: " + RaidTrackerPanel.format(drop.getPrice()) + " gp";
    }

    public void addDrop(RaidTracker RT, boolean update) {
        if (RT.isInTheatreOfBlood()) {
            this.tobRTList.add(RT);
        } else {
            this.RTList.add(RT);
        }
        if (update) {
            if (RT.isInTheatreOfBlood()) {
                this.TobUUIDMap.put(RT.getUniqueID(), RT);
            } else {
                this.UUIDMap.put(RT.getUniqueID(), RT);
            }
            this.updateView();
        }
    }

    public void addDrop(RaidTracker RT) {
        this.addDrop(RT, true);
    }

    public int atleastZero(int maybeLessThanZero) {
        return Math.max(maybeLessThanZero, 0);
    }

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return RaidTrackerPanel.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + RaidTrackerPanel.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 100L);
        boolean hasDecimal = truncated < 1000L;
        return hasDecimal ? (double)truncated / 100.0 + suffix : truncated / 100L + suffix;
    }

    public Future<Map<Integer, RaidTrackerItem>> getDistinctRegularDrops() {
        CompletableFuture<Map<Integer, RaidTrackerItem>> future = new CompletableFuture<Map<Integer, RaidTrackerItem>>();
        this.clientThread.invokeLater(() -> {
            if (this.loaded) {
                HashSet<Integer> uniqueIDs = new HashSet<Integer>();
                int clues = 0;
                for (RaidTracker raidTracker : this.getFilteredRTList()) {
                    for (RaidTrackerItem item : raidTracker.getLootList()) {
                        boolean addToSet = true;
                        for (RaidUniques unique : this.getUniquesList()) {
                            if (item.getId() != unique.getItemID()) continue;
                            addToSet = false;
                            break;
                        }
                        if (item.getName().toLowerCase().contains("clue")) {
                            addToSet = false;
                            ++clues;
                        }
                        if (!addToSet) continue;
                        uniqueIDs.add(item.id);
                    }
                }
                HashMap<Integer, RaidTrackerItem> m = new HashMap<Integer, RaidTrackerItem>();
                for (final Integer i : uniqueIDs) {
                    final ItemComposition IC = this.itemManager.getItemComposition(i.intValue());
                    m.put(i, new RaidTrackerItem(){
                        {
                            this.name = IC.getName();
                            this.id = i;
                            this.quantity = 0;
                            this.price = RaidTrackerPanel.this.itemManager.getItemPrice(i.intValue());
                        }
                    });
                }
                if (clues > 0) {
                    final int n = clues;
                    m.put(12073, new RaidTrackerItem(){
                        {
                            this.name = "Clue scroll (elite)";
                            this.id = 12073;
                            this.quantity = n;
                            this.price = RaidTrackerPanel.this.itemManager.getItemPrice(12073);
                        }
                    });
                }
                future.complete(m);
                return;
            }
            future.complete(new HashMap());
        });
        return future;
    }

    private ArrayList<RaidTracker> getFilteredRTList() {
        if (!this.loaded) {
            return new ArrayList<RaidTracker>();
        }
        ArrayList<RaidTracker> tempRTList = this.isTob ? (this.mvpFilter.equals("Both") ? this.tobRTList : (this.mvpFilter.equals("My MVP") ? this.tobRTList.stream().filter(RaidTracker::isMvpInOwnName).collect(Collectors.toCollection(ArrayList::new)) : this.tobRTList.stream().filter(RT -> !RT.isMvpInOwnName()).collect(Collectors.toCollection(ArrayList::new)))) : (this.cmFilter.equals("CM & Normal") ? this.RTList : (this.cmFilter.equals("CM Only") ? this.RTList.stream().filter(RaidTracker::isChallengeMode).collect(Collectors.toCollection(ArrayList::new)) : this.RTList.stream().filter(RT -> !RT.isChallengeMode()).collect(Collectors.toCollection(ArrayList::new))));
        switch (this.teamSizeFilter) {
            case "Solo": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() == 1).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "Duo": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() == 2).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "Trio": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() == 3).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "4-man": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() == 4).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "5-man": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() == 5).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "6-man": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() == 6).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "7-man": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() == 7).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "8-10 Players": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() >= 8 && RT.getTeamSize() <= 10).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "11-14 Players": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() >= 11 && RT.getTeamSize() <= 14).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
            case "15-24 Players": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() >= 15 && RT.getTeamSize() <= 24).collect(Collectors.toCollection(ArrayList::new));
            }
            case "24+ Players": {
                tempRTList = tempRTList.stream().filter(RT -> RT.getTeamSize() >= 25).collect(Collectors.toCollection(ArrayList::new));
                break;
            }
        }
        long now = System.currentTimeMillis();
        long last12Hours = now - 43200000L;
        long yesterday = now - 86400000L;
        long last3Days = now - 259200000L;
        long lastWeek = now - 604800000L;
        long lastMonth = now - 2629746000L;
        long last3Months = now - 7889400000L;
        long lastYear = now - 31536000000L;
        switch (this.dateFilter) {
            case "All Time": {
                return tempRTList;
            }
            case "12 Hours": {
                return tempRTList.stream().filter(RT -> RT.getDate() > last12Hours).collect(Collectors.toCollection(ArrayList::new));
            }
            case "Today": {
                return tempRTList.stream().filter(RT -> RT.getDate() > yesterday).collect(Collectors.toCollection(ArrayList::new));
            }
            case "3 Days": {
                return tempRTList.stream().filter(RT -> RT.getDate() > last3Days).collect(Collectors.toCollection(ArrayList::new));
            }
            case "Week": {
                return tempRTList.stream().filter(RT -> RT.getDate() > lastWeek).collect(Collectors.toCollection(ArrayList::new));
            }
            case "Month": {
                return tempRTList.stream().filter(RT -> RT.getDate() > lastMonth).collect(Collectors.toCollection(ArrayList::new));
            }
            case "3 Months": {
                return tempRTList.stream().filter(RT -> RT.getDate() > last3Months).collect(Collectors.toCollection(ArrayList::new));
            }
            case "Year": {
                return tempRTList.stream().filter(RT -> RT.getDate() > lastYear).collect(Collectors.toCollection(ArrayList::new));
            }
            case "X Kills": {
                ArrayList<RaidTracker> tempUniqueKills = this.getDistinctKills(tempRTList);
                ArrayList<RaidTracker> uniqueKills = new ArrayList<RaidTracker>(tempUniqueKills.subList(Math.max(tempUniqueKills.size() - this.config.lastXKills(), 0), tempUniqueKills.size()));
                return tempRTList.stream().filter(RT -> uniqueKills.stream().anyMatch(temp -> RT.getKillCountID().equals(temp.getKillCountID()))).collect(Collectors.toCollection(ArrayList::new));
            }
        }
        return this.RTList;
    }

    public EnumSet<RaidUniques> getUniquesList() {
        if (this.isTob) {
            return this.tobUniques;
        }
        return this.coxUniques;
    }

    public RaidUniques getByName(String name) {
        EnumSet<RaidUniques> uniquesList = this.getUniquesList();
        for (RaidUniques unique : uniquesList) {
            if (!unique.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return unique;
        }
        return RaidUniques.OLMLET;
    }

    public ArrayList<RaidTracker> getDistinctKills(ArrayList<RaidTracker> tempRTList) {
        LinkedHashMap<String, RaidTracker> tempUUIDMap = new LinkedHashMap<String, RaidTracker>();
        for (RaidTracker RT : tempRTList) {
            tempUUIDMap.put(RT.getKillCountID(), RT);
        }
        return new ArrayList<RaidTracker>(((HashMap)tempUUIDMap).values());
    }

    private void clearData() {
        int delete = JOptionPane.showConfirmDialog(this.getRootPane(), "<html>Are you sure you want to clear all data for this tab?<br/>There is no way to undo this action.</html>", "Warning", 0);
        if (delete == 0) {
            if (!this.fw.delete(this.isTob)) {
                JOptionPane.showMessageDialog(this.getRootPane(), "Unable to clear stored data, please try again.");
                return;
            }
            this.loadRTList();
        }
    }

    private String secondsToMinuteString(int seconds) {
        if (seconds < 0) {
            return "No time";
        }
        return seconds / 60 + ":" + (seconds % 60 < 10 ? "0" : "") + seconds % 60;
    }

    public void setItemManager(ItemManager itemManager) {
        this.itemManager = itemManager;
    }

    public void setRTList(ArrayList<RaidTracker> RTList) {
        this.RTList = RTList;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public void setCmFilter(String cmFilter) {
        this.cmFilter = cmFilter;
    }

    public void setMvpFilter(String mvpFilter) {
        this.mvpFilter = mvpFilter;
    }

    public void setTeamSizeFilter(String teamSizeFilter) {
        this.teamSizeFilter = teamSizeFilter;
    }

    public boolean isTob() {
        return this.isTob;
    }

    public EnumSet<RaidUniques> getTobUniques() {
        return this.tobUniques;
    }

    public EnumSet<RaidUniques> getCoxUniques() {
        return this.coxUniques;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "m");
        suffixes.put(1000000000L, "b");
    }
}

