/*
 * Decompiled with CFR 0.152.
 */
package com.raidtracker.filereadwriter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.raidtracker.RaidTracker;
import com.raidtracker.RaidTrackerItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.runelite.client.RuneLite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReadWriter {
    private static final Logger log = LoggerFactory.getLogger(FileReadWriter.class);
    private String username;
    private String coxDir;
    private String tobDir;

    public void writeToFile(RaidTracker raidTracker) {
        String dir = raidTracker.isInTheatreOfBlood() ? this.tobDir : this.coxDir;
        try {
            log.info("writer started");
            Gson gson = new GsonBuilder().create();
            JsonParser parser = new JsonParser();
            String fileName = dir + "\\raid_tracker_data.log";
            FileWriter fw = new FileWriter(fileName, true);
            gson.toJson(parser.parse(this.getJSONString(raidTracker, gson, parser)), (Appendable)fw);
            fw.append("\n");
            fw.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage() + " in writeToFile");
        }
    }

    public String getJSONString(RaidTracker raidTracker, Gson gson, JsonParser parser) {
        JsonObject RTJson = parser.parse(gson.toJson((Object)raidTracker)).getAsJsonObject();
        ArrayList<RaidTrackerItem> lootList = raidTracker.getLootList();
        JsonArray lootListToString = new JsonArray();
        for (RaidTrackerItem item : lootList) {
            lootListToString.add(parser.parse(gson.toJson((Object)item, new TypeToken<RaidTrackerItem>(){}.getType())));
        }
        RTJson.addProperty("lootList", lootListToString.toString());
        return RTJson.toString().replace("\\\"", "\"").replace("\"[", "[").replace("]\"", "]");
    }

    public ArrayList<RaidTracker> readFromFile(String alternateFile, boolean isTob) {
        String dir = isTob ? this.tobDir : this.coxDir;
        Object fileName = alternateFile.length() != 0 ? alternateFile : dir + "\\raid_tracker_data.log";
        try {
            String line;
            Gson gson = new GsonBuilder().create();
            JsonParser parser = new JsonParser();
            BufferedReader bufferedreader = new BufferedReader(new FileReader((String)fileName));
            ArrayList<RaidTracker> RTList = new ArrayList<RaidTracker>();
            while ((line = bufferedreader.readLine()) != null && line.length() > 0) {
                try {
                    RaidTracker parsed = (RaidTracker)gson.fromJson(parser.parse(line), RaidTracker.class);
                    RTList.add(parsed);
                }
                catch (JsonSyntaxException e) {
                    System.out.println("Bad line: " + line);
                }
            }
            bufferedreader.close();
            return RTList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<RaidTracker>();
        }
    }

    public ArrayList<RaidTracker> readFromFile() {
        return this.readFromFile("", false);
    }

    public ArrayList<RaidTracker> readFromFile(boolean isTob) {
        return this.readFromFile("", isTob);
    }

    public void createFolders() {
        File dir = new File(RuneLite.RUNELITE_DIR, "raid-data tracker");
        this.IGNORE_RESULT(dir.mkdir());
        dir = new File(dir, this.username);
        this.IGNORE_RESULT(dir.mkdir());
        File dir_cox = new File(dir, "cox");
        File dir_tob = new File(dir, "tob");
        this.IGNORE_RESULT(dir_cox.mkdir());
        this.IGNORE_RESULT(dir_tob.mkdir());
        File newCoxFile = new File(dir_cox + "\\raid_tracker_data.log");
        File newTobFile = new File(dir_tob + "\\raid_tracker_data.log");
        try {
            this.IGNORE_RESULT(newCoxFile.createNewFile());
            this.IGNORE_RESULT(newTobFile.createNewFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.coxDir = dir_cox.getAbsolutePath();
        this.tobDir = dir_tob.getAbsolutePath();
    }

    public void updateUsername(String username) {
        this.username = username;
        this.createFolders();
    }

    public void updateRTList(ArrayList<RaidTracker> RTList, boolean isTob) {
        String dir = isTob ? this.tobDir : this.coxDir;
        try {
            Gson gson = new GsonBuilder().create();
            JsonParser parser = new JsonParser();
            String fileName = dir + "\\raid_tracker_data.log";
            FileWriter fw = new FileWriter(fileName, false);
            for (RaidTracker RT : RTList) {
                if (RT.getLootSplitPaid() > 0) {
                    RT.setSpecialLootInOwnName(true);
                } else {
                    RT.setSpecialLootInOwnName(RT.getLootList().size() > 0 && RT.getLootList().get(0).getName().toLowerCase().equals(RT.getSpecialLoot().toLowerCase()));
                }
                gson.toJson(parser.parse(this.getJSONString(RT, gson, parser)), (Appendable)fw);
                fw.append("\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateRTList(ArrayList<RaidTracker> RTList) {
        this.updateRTList(RTList, false);
    }

    public boolean delete(boolean isTob) {
        String dir = isTob ? this.tobDir : this.coxDir;
        File newFile = new File(dir + "\\raid_tracker_data.log");
        boolean isDeleted = newFile.delete();
        try {
            this.IGNORE_RESULT(newFile.createNewFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public void IGNORE_RESULT(boolean b) {
    }

    public String getUsername() {
        return this.username;
    }
}

