/*
 * Decompiled with CFR 0.152.
 */
package com.raidtracker;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.raidtracker.RaidTracker;
import com.raidtracker.RaidTrackerConfig;
import com.raidtracker.RaidTrackerItem;
import com.raidtracker.filereadwriter.FileReadWriter;
import com.raidtracker.ui.RaidTrackerPanel;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Raid Data Tracker")
public class RaidTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RaidTrackerPlugin.class);
    private static final String LEVEL_COMPLETE_MESSAGE = "complete! Duration:";
    private static final String RAID_COMPLETE_MESSAGE = "Congratulations - your raid is complete!";
    private static final String DUST_RECIPIENTS = "Dust recipients: ";
    private static final String TWISTED_KIT_RECIPIENTS = "Twisted Kit recipients: ";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private RaidTrackerConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private RaidTracker raidTracker;
    private static final WorldPoint TEMP_LOCATION = new WorldPoint(3360, 5152, 2);
    private RaidTrackerPanel panel;
    private NavigationButton navButton;
    private FileReadWriter fw = new FileReadWriter();
    private boolean writerStarted = false;

    @Provides
    RaidTrackerConfig provideConfig(ConfigManager configManager) {
        return (RaidTrackerConfig)configManager.getConfig(RaidTrackerConfig.class);
    }

    protected void startUp() {
        this.panel = new RaidTrackerPanel(this.itemManager, this.fw, this.config, this.clientThread);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel-icon.png");
        this.navButton = NavigationButton.builder().tooltip("Raid Data Tracker").priority(6).icon(icon).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN) || this.client.getGameState().equals((Object)GameState.LOADING)) {
            this.fw.updateUsername(this.client.getUsername());
            SwingUtilities.invokeLater(() -> this.panel.loadRTList());
        }
    }

    protected void shutDown() {
        this.raidTracker.setInRaidChambers(false);
        this.clientToolbar.removeNavigation(this.navButton);
        this.reset();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        boolean tempInTob;
        boolean tempInRaid = this.client.getVar(5432) == 1;
        boolean bl = tempInTob = this.client.getVar(6440) > 1;
        if (tempInRaid ^ this.raidTracker.isInRaidChambers()) {
            if (tempInRaid && this.raidTracker.isLoggedIn()) {
                this.checkRaidPresence();
            } else if (this.raidTracker.isRaidComplete() && !this.raidTracker.isChestOpened()) {
                if (this.writerStarted) {
                    return;
                }
                this.fw.writeToFile(this.raidTracker);
                this.writerStarted = true;
                SwingUtilities.invokeLater(() -> {
                    this.panel.addDrop(this.raidTracker);
                    this.reset();
                });
            }
        }
        if (tempInTob ^ this.raidTracker.isInTheatreOfBlood()) {
            if (tempInTob && this.raidTracker.isLoggedIn()) {
                this.checkTobPresence();
            } else if (this.raidTracker.isRaidComplete()) {
                if (this.writerStarted) {
                    return;
                }
                this.fw.writeToFile(this.raidTracker);
                this.writerStarted = true;
                SwingUtilities.invokeLater(() -> {
                    this.panel.addDrop(this.raidTracker);
                    this.reset();
                });
            } else {
                this.reset();
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGING_IN) {
            this.fw.updateUsername(this.client.getUsername());
            SwingUtilities.invokeLater(() -> this.panel.loadRTList());
        }
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getWorldLocation().equals((Object)TEMP_LOCATION)) {
                return;
            }
        } else if (this.client.getGameState() == GameState.LOGIN_SCREEN || this.client.getGameState() == GameState.CONNECTION_LOST) {
            this.raidTracker.setLoggedIn(false);
        } else if (this.client.getGameState() == GameState.HOPPING) {
            this.reset();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        this.checkChatMessage(event, this.raidTracker);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        switch (event.getGroupId()) {
            case 539: {
                if (this.raidTracker.isChestOpened() || !this.raidTracker.isRaidComplete()) {
                    return;
                }
                this.raidTracker.setChestOpened(true);
                ItemContainer rewardItemContainer = this.client.getItemContainer(InventoryID.CHAMBERS_OF_XERIC_CHEST);
                if (rewardItemContainer == null) {
                    return;
                }
                if (this.writerStarted) {
                    return;
                }
                this.raidTracker.setLootList(this.lootListFactory(rewardItemContainer.getItems()));
                this.fw.writeToFile(this.raidTracker);
                this.writerStarted = true;
                SwingUtilities.invokeLater(() -> {
                    this.panel.addDrop(this.raidTracker);
                    this.reset();
                });
                break;
            }
            case 28: {
                if (this.raidTracker.isChestOpened() || !this.raidTracker.isRaidComplete()) {
                    return;
                }
                this.raidTracker.setChestOpened(true);
                ItemContainer rewardItemContainer = this.client.getItemContainer(InventoryID.THEATRE_OF_BLOOD_CHEST);
                if (rewardItemContainer == null) {
                    return;
                }
                this.raidTracker.setLootList(this.lootListFactory(rewardItemContainer.getItems()));
                break;
            }
            case 459: {
                AtomicReference<String> mvp = new AtomicReference<String>("");
                AtomicReference<String> player1 = new AtomicReference<String>("");
                AtomicReference<String> player2 = new AtomicReference<String>("");
                AtomicReference<String> player3 = new AtomicReference<String>("");
                AtomicReference<String> player4 = new AtomicReference<String>("");
                AtomicReference<String> player5 = new AtomicReference<String>("");
                AtomicInteger deathsPlayer1 = new AtomicInteger();
                AtomicInteger deathsPlayer2 = new AtomicInteger();
                AtomicInteger deathsPlayer3 = new AtomicInteger();
                AtomicInteger deathsPlayer4 = new AtomicInteger();
                AtomicInteger deathsPlayer5 = new AtomicInteger();
                this.clientThread.invokeLater(() -> {
                    mvp.set(this.getWidgetText(this.client.getWidget(459, 14)));
                    player1.set(this.getWidgetText(this.client.getWidget(459, 22)));
                    player2.set(this.getWidgetText(this.client.getWidget(459, 24)));
                    player3.set(this.getWidgetText(this.client.getWidget(459, 26)));
                    player4.set(this.getWidgetText(this.client.getWidget(459, 28)));
                    player5.set(this.getWidgetText(this.client.getWidget(459, 30)));
                    deathsPlayer1.set(this.getWidgetNumber(this.client.getWidget(459, 23)));
                    deathsPlayer2.set(this.getWidgetNumber(this.client.getWidget(459, 25)));
                    deathsPlayer3.set(this.getWidgetNumber(this.client.getWidget(459, 27)));
                    deathsPlayer4.set(this.getWidgetNumber(this.client.getWidget(459, 29)));
                    deathsPlayer5.set(this.getWidgetNumber(this.client.getWidget(459, 31)));
                    this.raidTracker.setMvp((String)mvp.get());
                    this.raidTracker.setTobPlayer1((String)player1.get());
                    this.raidTracker.setTobPlayer2((String)player2.get());
                    this.raidTracker.setTobPlayer3((String)player3.get());
                    this.raidTracker.setTobPlayer4((String)player4.get());
                    this.raidTracker.setTobPlayer5((String)player5.get());
                    this.raidTracker.setTobPlayer1DeathCount(deathsPlayer1.get());
                    this.raidTracker.setTobPlayer2DeathCount(deathsPlayer2.get());
                    this.raidTracker.setTobPlayer3DeathCount(deathsPlayer3.get());
                    this.raidTracker.setTobPlayer4DeathCount(deathsPlayer4.get());
                    this.raidTracker.setTobPlayer5DeathCount(deathsPlayer5.get());
                    if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null) {
                        this.raidTracker.setMvpInOwnName(((String)mvp.get()).toLowerCase().equals(this.client.getLocalPlayer().getName().toLowerCase()));
                    }
                });
            }
        }
    }

    private String getWidgetText(Widget widget) {
        if (widget == null) {
            return "";
        }
        if (widget.getText().equals("-")) {
            return "";
        }
        return widget.getText();
    }

    private int getWidgetNumber(Widget widget) {
        if (widget == null) {
            return 0;
        }
        if (widget.getText().equals("-")) {
            return 0;
        }
        return Integer.parseInt(widget.getText());
    }

    public void checkChatMessage(ChatMessage event, RaidTracker raidTracker) {
        raidTracker.setLoggedIn(true);
        String playerName = "";
        if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null) {
            playerName = this.client.getLocalPlayer().getName();
        }
        if ((raidTracker.isInRaidChambers() || raidTracker.isInTheatreOfBlood()) && (event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION || event.getType() == ChatMessageType.GAMEMESSAGE)) {
            RaidTracker altRT;
            String message = this.unescapeJavaString(Text.removeTags((String)event.getMessage()));
            if (message.contains(LEVEL_COMPLETE_MESSAGE)) {
                String timeString = message.split("complete! Duration: ")[1];
                if (message.startsWith("Upper")) {
                    raidTracker.setUpperTime(this.stringTimeToSeconds(timeString.split(" ")[timeString.split(" ").length - 1]));
                }
                if (message.startsWith("Middle")) {
                    raidTracker.setMiddleTime(this.stringTimeToSeconds(timeString.split(" ")[timeString.split(" ").length - 1]));
                }
                if (message.startsWith("Lower")) {
                    raidTracker.setLowerTime(this.stringTimeToSeconds(timeString.split(" ")[timeString.split(" ").length - 1]));
                }
                if (message.toLowerCase().contains("shamans")) {
                    raidTracker.setShamansTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("vasa")) {
                    raidTracker.setVasaTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("vanguards")) {
                    raidTracker.setVanguardsTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("mystics")) {
                    raidTracker.setMysticsTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("tekton")) {
                    raidTracker.setTektonTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("muttadiles")) {
                    raidTracker.setMuttadilesTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("vespula")) {
                    raidTracker.setVespulaTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("ice demon")) {
                    raidTracker.setIceDemonTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("thieving")) {
                    raidTracker.setThievingTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("tightrope")) {
                    raidTracker.setTightropeTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
                if (message.toLowerCase().contains("crabs")) {
                    raidTracker.setCrabsTime(this.stringTimeToSeconds(timeString.split(" ")[0]));
                }
            }
            if (message.startsWith(RAID_COMPLETE_MESSAGE)) {
                raidTracker.setTotalPoints(this.client.getVar(5431));
                raidTracker.setPersonalPoints(this.client.getVar(5422));
                raidTracker.setPercentage((double)raidTracker.getPersonalPoints() / ((double)raidTracker.getTotalPoints() / 100.0));
                raidTracker.setTeamSize(this.client.getVar(5424));
                raidTracker.setRaidComplete(true);
                raidTracker.setDate(System.currentTimeMillis());
            }
            if (message.toLowerCase().contains("wave '")) {
                String wave;
                switch (wave = message.toLowerCase().split("'")[1]) {
                    case "the maiden of sugadinti": {
                        raidTracker.setMaidenTime(this.stringTimeToSeconds(message.toLowerCase().split("duration: ")[1].split(" total")[0]));
                        break;
                    }
                    case "the pestilent bloat": {
                        raidTracker.setBloatTime(this.stringTimeToSeconds(message.toLowerCase().split("duration: ")[1].split(" total")[0]));
                        break;
                    }
                    case "the nylocas": {
                        raidTracker.setNyloTime(this.stringTimeToSeconds(message.toLowerCase().split("duration: ")[1].split(" total")[0]));
                        break;
                    }
                    case "sotetseg": {
                        raidTracker.setSotetsegTime(this.stringTimeToSeconds(message.toLowerCase().split("duration: ")[1].split(" total")[0]));
                        break;
                    }
                    case "xarpus": {
                        raidTracker.setXarpusTime(this.stringTimeToSeconds(message.toLowerCase().split("duration: ")[1].split(" total")[0]));
                        break;
                    }
                    case "the final challenge": {
                        raidTracker.setVerzikTime(this.stringTimeToSeconds(message.toLowerCase().split("duration: ")[1].split("theatre")[0]));
                    }
                }
            }
            if (message.toLowerCase().contains("theatre of blood wave completion")) {
                raidTracker.setRaidTime(this.stringTimeToSeconds(message.toLowerCase().split("time: ")[1].split("personal")[0]));
            }
            if (raidTracker.isRaidComplete() && message.contains("Team size:")) {
                raidTracker.setRaidTime(this.stringTimeToSeconds(message.split("Duration: ")[1].split(" ")[0]));
            }
            if (message.contains("count is:")) {
                raidTracker.setChallengeMode(message.contains("Chambers of Xeric Challenge Mode"));
                raidTracker.setCompletionCount(Integer.parseInt(message.split("count is:")[1].trim().replace(".", "")));
                if (raidTracker.isInTheatreOfBlood()) {
                    int teamSize = 0;
                    for (int i = 6442; i < 6447; ++i) {
                        if (this.client.getVarbitValue(i) == 0) continue;
                        ++teamSize;
                    }
                    raidTracker.setTeamSize(teamSize);
                    raidTracker.setRaidComplete(true);
                }
            }
            if (raidTracker.isRaidComplete() && message.contains("-") && !message.startsWith(RAID_COMPLETE_MESSAGE)) {
                if (!raidTracker.getSpecialLootReceiver().isEmpty()) {
                    RaidTracker altRT2 = this.copyData();
                    altRT2.setSpecialLootReceiver(message.split(" - ")[0]);
                    altRT2.setSpecialLoot(message.split(" - ")[1]);
                    altRT2.setSpecialLootInOwnName(altRT2.getSpecialLootReceiver().toLowerCase().trim().equals(playerName.toLowerCase().trim()));
                    altRT2.setSpecialLootValue(((ItemPrice)this.itemManager.search(raidTracker.getSpecialLoot()).get(0)).getPrice());
                    this.setSplits(altRT2);
                    this.fw.writeToFile(altRT2);
                    SwingUtilities.invokeLater(() -> this.panel.addDrop(altRT2, false));
                } else {
                    raidTracker.setSpecialLootReceiver(message.split(" - ")[0]);
                    raidTracker.setSpecialLoot(message.split(" - ")[1]);
                    raidTracker.setSpecialLootValue(((ItemPrice)this.itemManager.search(raidTracker.getSpecialLoot()).get(0)).getPrice());
                    raidTracker.setSpecialLootInOwnName(raidTracker.getSpecialLootReceiver().toLowerCase().trim().equals(playerName.toLowerCase().trim()));
                    this.setSplits(raidTracker);
                }
            }
            if (raidTracker.isRaidComplete() && message.toLowerCase().contains("found something special") && !message.toLowerCase().contains("lil' zik")) {
                raidTracker.setSpecialLootReceiver(message.split(" found something special: ")[0]);
                raidTracker.setSpecialLoot(message.split(" found something special: ")[1]);
                raidTracker.setSpecialLootValue(((ItemPrice)this.itemManager.search(raidTracker.getSpecialLoot()).get(0)).getPrice());
                raidTracker.setSpecialLootInOwnName(raidTracker.getSpecialLootReceiver().toLowerCase().trim().equals(playerName.toLowerCase().trim()));
            }
            if (raidTracker.isRaidComplete() && message.startsWith(TWISTED_KIT_RECIPIENTS)) {
                String[] recipients;
                for (String recip : recipients = message.split(TWISTED_KIT_RECIPIENTS)[1].split(",")) {
                    if (raidTracker.getKitReceiver().isEmpty()) {
                        raidTracker.setKitReceiver(recip.trim());
                        continue;
                    }
                    altRT = this.copyData();
                    altRT.setKitReceiver(recip.trim());
                    this.fw.writeToFile(altRT);
                    SwingUtilities.invokeLater(() -> this.panel.addDrop(altRT, false));
                }
            }
            if (raidTracker.isRaidComplete() && message.startsWith(DUST_RECIPIENTS)) {
                String[] recipients;
                for (String recip : recipients = message.split(DUST_RECIPIENTS)[1].split(",")) {
                    if (raidTracker.getDustReceiver().isEmpty()) {
                        raidTracker.setDustReceiver(recip.trim());
                        continue;
                    }
                    altRT = this.copyData();
                    altRT.setDustReceiver(recip.trim());
                    this.fw.writeToFile(altRT);
                    SwingUtilities.invokeLater(() -> this.panel.addDrop(altRT, false));
                }
            }
            if (raidTracker.isRaidComplete() && (message.toLowerCase().contains("olmlet") || message.toLowerCase().contains("lil' zik")) || message.toLowerCase().contains("would have been followed")) {
                boolean inOwnName = false;
                boolean duplicate = message.toLowerCase().contains("would have been followed");
                if (playerName.equals(message.split(" ")[0]) || duplicate) {
                    inOwnName = true;
                }
                if (!raidTracker.getPetReceiver().isEmpty()) {
                    RaidTracker altRT3 = this.copyData();
                    if (duplicate) {
                        altRT3.setPetReceiver(playerName);
                    } else {
                        altRT3.setPetReceiver(message.split(" ")[0]);
                    }
                    altRT3.setPetInMyName(inOwnName);
                    this.fw.writeToFile(altRT3);
                    SwingUtilities.invokeLater(() -> this.panel.addDrop(altRT3, false));
                } else {
                    if (duplicate) {
                        raidTracker.setPetReceiver(playerName);
                    } else {
                        raidTracker.setPetReceiver(message.split(" ")[0]);
                    }
                    raidTracker.setPetInMyName(inOwnName);
                }
            }
        }
    }

    public void setSplits(RaidTracker raidTracker) {
        int lootSplit = raidTracker.getSpecialLootValue() / raidTracker.getTeamSize();
        int cutoff = this.config.FFACutoff();
        if (raidTracker.getSpecialLoot().length() > 0) {
            if (this.config.defaultFFA() || lootSplit < cutoff) {
                raidTracker.setFreeForAll(true);
                if (raidTracker.isSpecialLootInOwnName()) {
                    raidTracker.setLootSplitReceived(raidTracker.getSpecialLootValue());
                }
            } else if (raidTracker.isSpecialLootInOwnName()) {
                raidTracker.setLootSplitPaid(raidTracker.getSpecialLootValue() - lootSplit);
                raidTracker.setLootSplitReceived(lootSplit);
            } else {
                raidTracker.setLootSplitReceived(lootSplit);
            }
        }
    }

    public ArrayList<RaidTrackerItem> lootListFactory(Item[] items) {
        ArrayList<RaidTrackerItem> lootList = new ArrayList<RaidTrackerItem>();
        Arrays.stream(items).filter(item -> item.getId() > -1).forEach(item -> {
            final ItemComposition comp = this.itemManager.getItemComposition(item.getId());
            lootList.add(new RaidTrackerItem((Item)item){
                final /* synthetic */ Item val$item;
                {
                    this.val$item = item;
                    this.name = comp.getName();
                    this.id = comp.getId();
                    this.quantity = this.val$item.getQuantity();
                    this.price = comp.getPrice() * this.quantity;
                }
            });
        });
        return lootList;
    }

    private void checkRaidPresence() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.raidTracker.setInRaidChambers(this.client.getVar(5432) == 1);
    }

    private void checkTobPresence() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.raidTracker.setInTheatreOfBlood(this.client.getVar(6440) > 1);
    }

    private int stringTimeToSeconds(String s) {
        String[] split = s.split(":");
        return split.length == 3 ? Integer.parseInt(split[0]) * 3600 + Integer.parseInt(split[1]) * 60 + Math.round(Float.parseFloat(split[2])) : Integer.parseInt(split[0]) * 60 + Math.round(Float.parseFloat(split[1]));
    }

    public RaidTracker copyData() {
        RaidTracker RT = new RaidTracker();
        RT.setDate(this.raidTracker.getDate());
        RT.setTeamSize(this.raidTracker.getTeamSize());
        RT.setChallengeMode(this.raidTracker.isChallengeMode());
        RT.setInTheatreOfBlood(this.raidTracker.isInTheatreOfBlood());
        RT.setCompletionCount(this.raidTracker.getCompletionCount());
        RT.setKillCountID(this.raidTracker.getKillCountID());
        return RT;
    }

    private void reset() {
        this.raidTracker = new RaidTracker();
        this.writerStarted = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String unescapeJavaString(String st) {
        if (st == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(st.length());
        int i = 0;
        while (true) {
            block19: {
                int ch;
                block17: {
                    char nextChar;
                    block18: {
                        if (i >= st.length()) {
                            return sb.toString();
                        }
                        ch = st.charAt(i);
                        if (ch != 92) break block17;
                        char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block18;
                        String code = "" + nextChar;
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = code + st.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt(code, 8));
                        break block19;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block19;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }

    public void setPanel(RaidTrackerPanel panel) {
        this.panel = panel;
    }

    public void setFw(FileReadWriter fw) {
        this.fw = fw;
    }
}

