/*
 * Decompiled with CFR 0.152.
 */
package com.essencerunning;

import com.essencerunning.EssenceRunningSession;
import com.google.common.collect.ArrayListMultimap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.util.Text;

public class EssenceRunningUtils {
    private static final String TRADING_WITH = "Trading with:<br>";

    public static void swap(Client client, ArrayListMultimap<String, Integer> optionIndexes, String optionA, String optionB, String target, int index, boolean strict) {
        MenuEntry[] menuEntries = client.getMenuEntries();
        int thisIndex = EssenceRunningUtils.findIndex(optionIndexes, menuEntries, index, optionB, target, strict);
        int optionIdx = EssenceRunningUtils.findIndex(optionIndexes, menuEntries, thisIndex, optionA, target, strict);
        if (thisIndex >= 0 && optionIdx >= 0) {
            EssenceRunningUtils.swap(client, optionIndexes, menuEntries, optionIdx, thisIndex);
        }
    }

    private static int findIndex(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int limit, String option, String target, boolean strict) {
        if (strict) {
            List indexes = optionIndexes.get((Object)option);
            for (int i = indexes.size() - 1; i >= 0; --i) {
                int idx = (Integer)indexes.get(i);
                MenuEntry entry = entries[idx];
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (idx > limit || !entryTarget.equals(target)) continue;
                return idx;
            }
        } else {
            for (int i = limit; i >= 0; --i) {
                MenuEntry entry = entries[i];
                String entryOption = Text.removeTags((String)entry.getOption()).toLowerCase();
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (!entryOption.contains(option.toLowerCase()) || !entryTarget.equals(target)) continue;
                return i;
            }
        }
        return -1;
    }

    private static void swap(Client client, ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry = entries[index1];
        entry.setType(entries[index2].getType());
        entries[index1] = entries[index2];
        entries[index2] = entry;
        client.setMenuEntries(entries);
        optionIndexes.clear();
        int idx = 0;
        for (MenuEntry menuEntry : entries) {
            String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
            optionIndexes.put((Object)option, (Object)idx++);
        }
    }

    public static void swapBankOp(Client client, MenuEntryAdded menuEntryAdded) {
        if (menuEntryAdded.getType() == MenuAction.CC_OP.getId() && menuEntryAdded.getIdentifier() == 2 && menuEntryAdded.getOption().startsWith("Deposit-")) {
            MenuEntry[] menuEntries = client.getMenuEntries();
            for (int i = menuEntries.length - 1; i >= 0; --i) {
                MenuEntry entry = menuEntries[i];
                if (entry.getType() != MenuAction.CC_OP_LOW_PRIORITY || entry.getIdentifier() != 9 || entry.getOption().equals("Empty")) continue;
                entry.setType(MenuAction.CC_OP);
                menuEntries[i] = menuEntries[menuEntries.length - 1];
                menuEntries[menuEntries.length - 1] = entry;
                client.setMenuEntries(menuEntries);
                break;
            }
        }
    }

    public static boolean itemEquipped(Client client, EquipmentInventorySlot slot) {
        ItemContainer equipment = client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment != null) {
            Item[] item = equipment.getItems();
            return item.length > slot.getSlotIdx() && item[slot.getSlotIdx()] != null && item[slot.getSlotIdx()].getId() > -1;
        }
        return false;
    }

    public static void computeItemsTraded(Client client, EssenceRunningSession session) {
        Widget tradingWith = client.getWidget(334, 30);
        String tradingPartnerRsn = tradingWith.getText().replace(TRADING_WITH, "");
        Widget partnerTrades = client.getWidget(334, 29);
        int pureEssenceTraded = 0;
        int bindingNecklaceTraded = 0;
        for (Widget widget : partnerTrades.getChildren()) {
            if (widget.getText().equals("Pure essence")) {
                ++pureEssenceTraded;
                continue;
            }
            if (!widget.getText().equals("Binding necklace")) continue;
            ++bindingNecklaceTraded;
        }
        session.updateRunnerStatistic(tradingPartnerRsn, pureEssenceTraded, bindingNecklaceTraded);
    }

    public static Map<Integer, String> getClanMessagesMap(final int size) {
        return new LinkedHashMap<Integer, String>(size){

            @Override
            public boolean removeEldestEntry(Map.Entry<Integer, String> eldest) {
                return this.size() > size;
            }
        };
    }
}

