/*
 * Decompiled with CFR 0.152.
 */
package com.essencerunning;

import com.essencerunning.EssenceRunningConfig;
import com.essencerunning.EssenceRunningPlugin;
import com.essencerunning.EssenceRunningSession;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class EssenceRunningStatisticsOverlay
extends Overlay {
    private final EssenceRunningPlugin plugin;
    private final EssenceRunningConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private EssenceRunningStatisticsOverlay(EssenceRunningPlugin plugin, EssenceRunningConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        if (this.config.enableRunecrafterMode() && this.config.sessionStatistics()) {
            EssenceRunningSession session = this.plugin.getSession();
            this.panelComponent.getChildren().add(LineComponent.builder().left("Runner").right("Ess/Neck").build());
            session.getRunners().forEach(runner -> this.panelComponent.getChildren().add(LineComponent.builder().left(runner.getRsn()).right(runner.getPureEssenceTraded() + "/" + runner.getBindingNecklaceTraded()).build()));
            if (session.getTotalFireRunesCrafted() > 0) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Fire Runes Crafted").right(Integer.toString(session.getTotalFireRunesCrafted())).build());
            }
        }
        return this.panelComponent.render(graphics);
    }
}

