/*
 * Decompiled with CFR 0.152.
 */
package com.essencerunning;

import com.essencerunning.EssenceRunner;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class EssenceRunningSession {
    private final Set<EssenceRunner> runners = new TreeSet<EssenceRunner>();
    private int totalFireRunesCrafted;

    public void updateRunnerStatistic(String rsn, int pureEssenceTraded, int bindingNecklaceTraded) {
        Optional<EssenceRunner> optional = this.runners.stream().filter(i -> i.getRsn().equals(rsn)).findFirst();
        EssenceRunner runner = optional.isPresent() ? optional.get() : new EssenceRunner(rsn);
        this.runners.remove(runner);
        runner.increasePureEssenceTraded(pureEssenceTraded);
        runner.increaseBindingNecklaceTraded(bindingNecklaceTraded);
        this.runners.add(runner);
    }

    public void updateCrafterStatistic(int fireRunesCrafted) {
        this.totalFireRunesCrafted += fireRunesCrafted;
    }

    public void reset() {
        this.runners.clear();
        this.totalFireRunesCrafted = 0;
    }

    public Set<EssenceRunner> getRunners() {
        return this.runners;
    }

    public int getTotalFireRunesCrafted() {
        return this.totalFireRunesCrafted;
    }
}

