/*
 * Decompiled with CFR 0.152.
 */
package com.essencerunning;

import com.essencerunning.EssenceRunningClanChatOverlay;
import com.essencerunning.EssenceRunningConfig;
import com.essencerunning.EssenceRunningItem;
import com.essencerunning.EssenceRunningOverlay;
import com.essencerunning.EssenceRunningSession;
import com.essencerunning.EssenceRunningStatisticsOverlay;
import com.essencerunning.EssenceRunningTickCounter;
import com.essencerunning.EssenceRunningUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatLineBuffer;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Essence Running")
public class EssenceRunningPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EssenceRunningPlugin.class);
    private static final String SENDING_TRADE_OFFER = "Sending trade offer...";
    private static final String ACCEPTED_TRADE = "Accepted trade.";
    private static final String CRAFTED_FIRE_RUNES = "You bind the temple's power into fire runes.";
    private static final String WAITING_OTHER_PLAYER = "Waiting for other player...";
    private static final int FIRE_RUNE_EXPERIENCE = 7;
    private static final String MAGIC_IMBUE_EXPIRED_MESSAGE = "Your Magic Imbue charge has ended.";
    private static final String MAGIC_IMBUE_MESSAGE = "You are charged to combine runes!";
    private static final String MAGIC_IMBUE_WARNING = "Your Magic Imbue spell charge is running out...";
    private static final int MAGIC_IMBUE_DURATION = 20;
    private static final int MAGIC_IMBUE_WARNING_DURATION = 10;
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EssenceRunningConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private EssenceRunningOverlay overlay;
    @Inject
    private EssenceRunningStatisticsOverlay statisticsOverlay;
    @Inject
    private EssenceRunningClanChatOverlay clanChatOverlay;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    private boolean shiftModifier = false;
    private EssenceRunningSession session;
    private boolean ringEquipped = false;
    private boolean amuletEquipped = false;
    private boolean tradeSent = false;
    private Map<Integer, String> clanMessages;
    private int MAX_ENTRIES = 0;
    private int runecraftXp = 0;
    private boolean craftedFireRunes = false;
    private EssenceRunningTickCounter counter;
    private boolean isFirstMessage = false;
    private boolean isCounting = false;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.statisticsOverlay);
        this.overlayManager.add((Overlay)this.clanChatOverlay);
        this.session = new EssenceRunningSession();
        this.MAX_ENTRIES = this.config.clanChatOverlayHeight().getOption();
        this.clanMessages = EssenceRunningUtils.getClanMessagesMap(this.MAX_ENTRIES);
    }

    protected void shutDown() {
        this.infoBoxManager.removeIf(t -> t instanceof EssenceRunningTickCounter);
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.statisticsOverlay);
        this.overlayManager.remove((Overlay)this.clanChatOverlay);
        this.session = null;
    }

    @Provides
    EssenceRunningConfig provideConfig(ConfigManager configManager) {
        return (EssenceRunningConfig)configManager.getConfig(EssenceRunningConfig.class);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int idx = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)idx++);
        }
        this.swapMenuEntry(menuEntries.length - 1, menuEntries[menuEntries.length - 1]);
    }

    private void swapMenuEntry(int index, MenuEntry menuEntry) {
        if (this.config.leftClickCustomization()) {
            String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
            String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
            if (this.config.swapOfferAll() && option.equals("offer")) {
                EssenceRunningUtils.swap(this.client, this.optionIndexes, "offer-all", option, target, index, true);
            }
            this.leftClickCustomization(target, option, index);
        }
    }

    private void leftClickCustomization(String target, String option, int index) {
        Object optionA = null;
        if (this.client.getWidget(WidgetInfo.BANK_CONTAINER) != null) {
            EssenceRunningItem item = EssenceRunningItem.of(target);
            if (this.config.swapBankWithdrawOp() && item != null) {
                optionA = "Withdraw-" + item.getWithdrawQuantity();
            }
        } else if (target.equals("small pouch") || target.equals("medium pouch") || target.equals("large pouch") || target.equals("giant pouch") || target.equals("colossal pouch")) {
            optionA = this.config.essencePouch().getOption();
        } else if (target.equals("binding necklace")) {
            optionA = this.config.bindingNecklace().getOption();
        } else if (target.startsWith("ring of the elements")) {
            optionA = "Fire Altar";
        } else if (target.startsWith("ring of dueling")) {
            optionA = "PvP Arena";
        } else if (target.startsWith("crafting cape")) {
            optionA = this.config.craftingCape().getOption();
        } else if (target.equals("amulet of eternal glory")) {
            optionA = "Edgeville";
        }
        if (optionA != null) {
            EssenceRunningUtils.swap(this.client, this.optionIndexes, ((String)optionA).toLowerCase(), option, target, index, true);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded menuEntryAdded) {
        String target;
        if (this.config.leftClickCustomization() && this.config.swapBankOp() && (!(target = Text.removeTags((String)menuEntryAdded.getTarget()).toLowerCase()).startsWith("binding necklace") || !this.config.excludeBindingNecklaceOp())) {
            EssenceRunningUtils.swapBankOp(this.client, menuEntryAdded);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (this.config.enableRunecrafterMode() && this.config.preventFireRunes() && menuOptionClicked.getId() == 34764 && menuOptionClicked.getMenuAction() == MenuAction.GAME_OBJECT_FIRST_OPTION) {
            menuOptionClicked.consume();
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Essence Running has prevented you from accidentally creating Fire Runes!", "");
        }
        if (this.config.enableRunnerMode() && this.config.preventTradeCancel()) {
            String option = Text.removeTags((String)menuOptionClicked.getMenuOption()).toLowerCase();
            String target = Text.removeTags((String)menuOptionClicked.getMenuTarget()).toLowerCase();
            Widget textField = this.client.getWidget(334, 4);
            if (textField != null && textField.getText().equals(WAITING_OTHER_PLAYER) && (target.startsWith("crafting cape") && option.equals("teleport") || target.startsWith("ring of dueling") && option.equals("pvp arena") || target.equals("ring of the elements") && (option.equals("last destination") || option.equals("fire altar")) || target.equals("amulet of eternal glory") && option.equals("edgeville") || target.equals("small pouch") && option.equals("empty") || target.equals("medium pouch") && option.equals("empty") || target.equals("large pouch") && option.equals("empty") || target.equals("giant pouch") && option.equals("empty") || target.equals("colossal pouch") && option.equals("empty"))) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Essence Running has prevented you from accidentally cancelling the Trade!", "");
                menuOptionClicked.consume();
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.tradeSent = false;
            this.session.reset();
            this.runecraftXp = 0;
            this.craftedFireRunes = false;
            this.clanMessages.clear();
        } else if (event.getGameState() == GameState.LOGGED_IN) {
            this.amuletEquipped = EssenceRunningUtils.itemEquipped(this.client, EquipmentInventorySlot.AMULET);
            this.ringEquipped = EssenceRunningUtils.itemEquipped(this.client, EquipmentInventorySlot.RING);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            this.amuletEquipped = EssenceRunningUtils.itemEquipped(this.client, EquipmentInventorySlot.AMULET);
            this.ringEquipped = EssenceRunningUtils.itemEquipped(this.client, EquipmentInventorySlot.RING);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getMessage().equals(SENDING_TRADE_OFFER)) {
            this.tradeSent = true;
        } else if (event.getMessage().equals(ACCEPTED_TRADE)) {
            if (this.config.enableRunecrafterMode() && this.config.sessionStatistics()) {
                EssenceRunningUtils.computeItemsTraded(this.client, this.session);
            }
        } else if (event.getMessage().equals(CRAFTED_FIRE_RUNES)) {
            this.craftedFireRunes = true;
        } else if (event.getSender() != null) {
            String message = event.getName() + ": " + event.getMessage();
            this.clanMessages.put(message.hashCode(), message);
        }
        if (this.config.filterTradeMessages() && event.getType() == ChatMessageType.TRADE) {
            ChatLineBuffer buffer = (ChatLineBuffer)this.client.getChatLineMap().get(ChatMessageType.TRADE.getType());
            buffer.removeMessageNode(event.getMessageNode());
            this.clientThread.invoke(() -> this.client.runScript(new Object[]{216}));
        }
        if (this.config.enableRunecrafterMode() && this.config.showAccurateMagicImbue() && event.getMessage().equals(MAGIC_IMBUE_MESSAGE)) {
            this.createTickCounter(20);
            this.isFirstMessage = true;
        }
        if (this.config.enableRunecrafterMode() && this.config.showAccurateMagicImbue() && event.getMessage().equals(MAGIC_IMBUE_WARNING) && this.isFirstMessage) {
            if (this.counter == null) {
                this.createTickCounter(10);
            } else {
                this.isCounting = true;
            }
            this.isFirstMessage = false;
        }
        if (event.getMessage().equals(MAGIC_IMBUE_EXPIRED_MESSAGE)) {
            this.removeTickCounter();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.counter == null) {
            return;
        }
        if (this.counter.getCount() > -1) {
            if (this.counter.getCount() == 0) {
                this.counter.setTextColor(Color.RED);
            }
            if (this.isCounting) {
                if (this.counter.getCount() == 11) {
                    this.isCounting = false;
                }
                this.counter.setCount(this.counter.getCount() - 1);
            }
        } else {
            this.removeTickCounter();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 335) {
            this.tradeSent = false;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("essencerunning")) {
            if (!(this.config.sessionStatistics() || this.session.getRunners().isEmpty() && this.session.getTotalFireRunesCrafted() == 0)) {
                this.session.reset();
            }
            if (this.MAX_ENTRIES != this.config.clanChatOverlayHeight().getOption()) {
                this.MAX_ENTRIES = this.config.clanChatOverlayHeight().getOption();
                Map<Integer, String> temp = EssenceRunningUtils.getClanMessagesMap(this.MAX_ENTRIES);
                temp.putAll(this.clanMessages);
                this.clanMessages = temp;
            }
            if (!this.config.showAccurateMagicImbue() || !this.config.enableRunecrafterMode()) {
                this.removeTickCounter();
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (statChanged.getSkill() == Skill.RUNECRAFT && this.config.enableRunecrafterMode() && this.config.sessionStatistics()) {
            if (this.craftedFireRunes) {
                this.session.updateCrafterStatistic((statChanged.getXp() - this.runecraftXp) / 7);
                this.craftedFireRunes = false;
            }
            this.runecraftXp = statChanged.getXp();
        }
    }

    private void createTickCounter(int duration) {
        if (this.counter == null) {
            this.counter = new EssenceRunningTickCounter(null, this, duration);
            this.spriteManager.getSpriteAsync(552, 0, (InfoBox)this.counter);
            this.counter.setTooltip("Magic imbue");
            this.infoBoxManager.addInfoBox((InfoBox)this.counter);
            this.isCounting = true;
        } else {
            this.counter.setCount(duration);
            this.counter.setTextColor(Color.WHITE);
        }
    }

    private void removeTickCounter() {
        if (this.counter == null) {
            return;
        }
        this.infoBoxManager.removeInfoBox((InfoBox)this.counter);
        this.counter = null;
        this.isCounting = false;
    }

    public void setShiftModifier(boolean shiftModifier) {
        this.shiftModifier = shiftModifier;
    }

    public EssenceRunningSession getSession() {
        return this.session;
    }

    public boolean isRingEquipped() {
        return this.ringEquipped;
    }

    public boolean isAmuletEquipped() {
        return this.amuletEquipped;
    }

    public boolean isTradeSent() {
        return this.tradeSent;
    }

    public Map<Integer, String> getClanMessages() {
        return this.clanMessages;
    }
}

