/*
 * Decompiled with CFR 0.152.
 */
package com.essencerunning;

import com.essencerunning.EssenceRunningConfig;
import com.essencerunning.EssenceRunningItemDropdown;
import com.essencerunning.EssenceRunningPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class EssenceRunningOverlay
extends Overlay {
    private static final String FREE_INVENTORY_SLOTS = " free inventory slots.";
    private final EssenceRunningPlugin plugin;
    private final Client client;
    private final EssenceRunningConfig config;

    @Inject
    private EssenceRunningOverlay(EssenceRunningPlugin plugin, Client client, EssenceRunningConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        this.renderBindingNecklace(graphics);
        if (this.config.enableRunnerMode()) {
            Widget chatbox = this.client.getWidget(WidgetInfo.CHATBOX);
            if (this.config.highlightTradeSent() && chatbox != null && !chatbox.isHidden()) {
                this.drawShape(graphics, chatbox.getBounds(), this.plugin.isTradeSent() ? Color.GREEN : Color.RED);
            }
            if (this.config.highlightRingOfDueling() && !this.plugin.isRingEquipped()) {
                this.drawWidgetChildren(graphics, this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER), 2552);
                this.drawWidgetChildren(graphics, this.client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER), 2552);
            }
        }
        return null;
    }

    private void renderBindingNecklace(Graphics2D graphics) {
        if (this.config.enableRunecrafterMode() && this.config.highlightEquipBindingNecklace() == EssenceRunningItemDropdown.HighlightEquipBindingNecklace.EQUIP && !this.plugin.isAmuletEquipped()) {
            this.drawWidgetChildren(graphics, this.client.getWidget(WidgetInfo.INVENTORY), 5521);
            this.drawWidgetChildren(graphics, this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER), 5521);
            this.drawWidgetChildren(graphics, this.client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER), 5521);
        }
        if (this.config.enableRunnerMode()) {
            switch (this.config.highlightTradeBindingNecklace()) {
                case TWENTY_FIVE: 
                case TWENTY_SIX: {
                    if (!this.matchFreeInventorySlots()) break;
                    this.drawWidgetChildren(graphics, this.client.getWidget(336, 0), 5521);
                    break;
                }
            }
        }
    }

    private void drawWidgetChildren(Graphics2D graphics, Widget widget, int itemId) {
        if (widget != null && widget.getChildren() != null) {
            for (Widget item : widget.getChildren()) {
                if (item.isHidden() || item.getItemId() != itemId) continue;
                this.drawShape(graphics, item.getBounds(), Color.RED);
            }
        }
    }

    private void drawShape(Graphics2D graphics, Shape shape, Color color) {
        Color previousColor = graphics.getColor();
        graphics.setColor(color);
        graphics.draw(shape);
        graphics.setColor(previousColor);
    }

    private boolean matchFreeInventorySlots() {
        Widget freeSlots = this.client.getWidget(335, 9);
        return freeSlots != null && freeSlots.getText().endsWith(this.config.highlightTradeBindingNecklace().getOption().split(" ")[0] + FREE_INVENTORY_SLOTS);
    }
}

