/*
 * Decompiled with CFR 0.152.
 */
package com.essencerunning;

import com.essencerunning.EssenceRunningConfig;
import com.essencerunning.EssenceRunningPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class EssenceRunningClanChatOverlay
extends Overlay {
    private final EssenceRunningPlugin plugin;
    private final Client client;
    private final EssenceRunningConfig config;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    public EssenceRunningClanChatOverlay(EssenceRunningPlugin plugin, Client client, EssenceRunningConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        Widget chatbox = this.client.getWidget(WidgetInfo.CHATBOX_TRANSPARENT_LINES);
        if (this.config.clanChatOverlayHeight().getOption() > 0 && chatbox != null && !chatbox.isHidden()) {
            this.panelComponent.setPreferredSize(new Dimension(chatbox.getWidth(), 0));
            this.plugin.getClanMessages().values().forEach(message -> this.panelComponent.getChildren().add(LineComponent.builder().left(message).build()));
        }
        return this.panelComponent.render(graphics);
    }
}

