/*
 * Decompiled with CFR 0.152.
 */
package xyz.evaan;

import com.google.inject.Provides;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.evaan.Sound;
import xyz.evaan.SoundEngine;
import xyz.evaan.SoundFileManager;
import xyz.evaan.TediousCollectionLogConfig;

@PluginDescriptor(name="Tedious Collection Log", description="Tedious announces new collection log slots", tags={"tedious", "announce", "collection", "log"})
public class TediousCollectionLogPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TediousCollectionLogPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SoundEngine soundEngine;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*");

    @Provides
    TediousCollectionLogConfig provideConfig(ConfigManager configManager) {
        return (TediousCollectionLogConfig)configManager.getConfig(TediousCollectionLogConfig.class);
    }

    protected void startUp() throws Exception {
        this.executor.submit(() -> {
            SoundFileManager.ensureDownloadDirectoryExists();
            SoundFileManager.downloadAllMissingSounds(this.okHttpClient);
        });
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE && chatMessage.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (COLLECTION_LOG_ITEM_REGEX.matcher(chatMessage.getMessage()).matches()) {
            this.client.addChatMessage(ChatMessageType.PUBLICCHAT, "Tedious", "The collection log.", null);
            this.soundEngine.playClip(Sound.COLLECTION_LOG_SLOT);
        }
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }
}

