/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.wikisync;

import com.andmcadams.wikisync.Manifest;
import com.andmcadams.wikisync.PlayerData;
import com.andmcadams.wikisync.PlayerDataSubmission;
import com.andmcadams.wikisync.PlayerProfile;
import com.andmcadams.wikisync.WikiSyncConfig;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.VarbitComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="WikiSync")
public class WikiSyncPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WikiSyncPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private WikiSyncConfig config;
    @Inject
    private Gson gson;
    @Inject
    private OkHttpClient okHttpClient;
    private static final int SECONDS_BETWEEN_UPLOADS = 10;
    private static final int SECONDS_BETWEEN_MANIFEST_CHECKS = 1200;
    private static final String MANIFEST_URL = "https://sync.runescape.wiki/runelite/manifest";
    private static final String SUBMIT_URL = "https://sync.runescape.wiki/runelite/submit";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final int VARBITS_ARCHIVE_ID = 14;
    private Map<Integer, VarbitComposition> varbitCompositions = new HashMap<Integer, VarbitComposition>();
    public static final String CONFIG_GROUP_KEY = "WikiSync";
    public static final int VERSION = 1;
    private Manifest manifest;
    private Map<PlayerProfile, PlayerData> playerDataMap = new HashMap<PlayerProfile, PlayerData>();

    @Provides
    WikiSyncConfig getConfig(ConfigManager configManager) {
        return (WikiSyncConfig)configManager.getConfig(WikiSyncConfig.class);
    }

    public void startUp() {
        this.clientThread.invoke(() -> {
            int[] varbitIds;
            if (this.client.getIndexConfig() == null || this.client.getGameState().ordinal() < GameState.LOGIN_SCREEN.ordinal()) {
                log.debug("Failed to get varbitComposition, state = {}", (Object)this.client.getGameState());
                return false;
            }
            for (int id : varbitIds = this.client.getIndexConfig().getFileIds(14)) {
                this.varbitCompositions.put(id, this.client.getVarbit(id));
            }
            return true;
        });
        this.checkManifest();
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void submitTask() {
        PlayerData oldPlayerData;
        if (this.client.getGameState() != GameState.LOGGED_IN || this.varbitCompositions.isEmpty()) {
            return;
        }
        if (this.manifest == null || this.client.getLocalPlayer() == null) {
            log.debug("Skipped due to bad manifest: {}", (Object)this.manifest);
            return;
        }
        String username = this.client.getLocalPlayer().getName();
        RuneScapeProfileType profileType = RuneScapeProfileType.getCurrent((Client)this.client);
        PlayerProfile profileKey = new PlayerProfile(username, profileType);
        PlayerData newPlayerData = this.getPlayerData();
        if (newPlayerData.equals(oldPlayerData = this.playerDataMap.computeIfAbsent(profileKey, k -> new PlayerData()))) {
            return;
        }
        this.subtract(newPlayerData, oldPlayerData);
        this.submitPlayerData(profileKey, newPlayerData, oldPlayerData);
    }

    @Schedule(period=1200L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void manifestTask() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.checkManifest();
        }
    }

    private int getVarbitValue(int varbitId) {
        VarbitComposition v = this.varbitCompositions.get(varbitId);
        if (v == null) {
            return -1;
        }
        int value = this.client.getVarpValue(v.getIndex());
        int lsb = v.getLeastSignificantBit();
        int msb = v.getMostSignificantBit();
        int mask = (1 << msb - lsb + 1) - 1;
        return value >> lsb & mask;
    }

    private PlayerData getPlayerData() {
        PlayerData out = new PlayerData();
        for (int varbitId : this.manifest.varbits) {
            out.varb.put(varbitId, this.getVarbitValue(varbitId));
        }
        for (int varpId : this.manifest.varps) {
            out.varp.put(varpId, this.client.getVarpValue(varpId));
        }
        for (Skill s : Skill.values()) {
            out.level.put(s.getName(), this.client.getRealSkillLevel(s));
        }
        return out;
    }

    private void subtract(PlayerData newPlayerData, PlayerData oldPlayerData) {
        oldPlayerData.varb.forEach(newPlayerData.varb::remove);
        oldPlayerData.varp.forEach(newPlayerData.varp::remove);
        oldPlayerData.level.forEach(newPlayerData.level::remove);
    }

    private void merge(PlayerData oldPlayerData, PlayerData delta) {
        oldPlayerData.varb.putAll(delta.varb);
        oldPlayerData.varp.putAll(delta.varp);
        oldPlayerData.level.putAll(delta.level);
    }

    private void submitPlayerData(PlayerProfile profileKey, final PlayerData delta, final PlayerData old) {
        PlayerDataSubmission submission = new PlayerDataSubmission(profileKey.getUsername(), profileKey.getProfileType().name(), delta);
        Request request = new Request.Builder().url(SUBMIT_URL).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)submission))).build();
        Call call = this.okHttpClient.newCall(request);
        call.timeout().timeout(3L, TimeUnit.SECONDS);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Failed to submit: ", (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                try {
                    if (!response.isSuccessful()) {
                        log.debug("Failed to submit: {}", (Object)response.code());
                        return;
                    }
                    WikiSyncPlugin.this.merge(old, delta);
                }
                finally {
                    response.close();
                }
            }
        });
    }

    private void checkManifest() {
        Request request = new Request.Builder().url(MANIFEST_URL).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Failed to get manifest: ", (Throwable)e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (!response.isSuccessful()) {
                        log.debug("Failed to get manifest: {}", (Object)response.code());
                        return;
                    }
                    InputStream in = response.body().byteStream();
                    WikiSyncPlugin.this.manifest = (Manifest)WikiSyncPlugin.this.gson.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), Manifest.class);
                }
                catch (JsonParseException e) {
                    log.debug("Failed to parse manifest: ", (Throwable)e);
                }
                finally {
                    response.close();
                }
            }
        });
    }
}

