/*
 * Decompiled with CFR 0.152.
 */
package tlk.jorva.glorycounter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.RuneLite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class LocalStorageHandler {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageHandler.class);
    private static final File DATA_FOLDER = new File(RuneLite.RUNELITE_DIR, "glory-counter");

    @Inject
    public LocalStorageHandler() {
        DATA_FOLDER.mkdir();
    }

    public synchronized boolean writeToFile(long hash, int amount) {
        try {
            File file = new File(DATA_FOLDER, "" + hash);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(file), false));
            writer.write("" + amount);
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            log.warn("Error writing glory data for {}: {}", (Object)hash, (Object)e.getMessage());
            return false;
        }
    }

    public synchronized int readFromFile(long hash) {
        try {
            File file = new File(DATA_FOLDER, "" + hash);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            reader.close();
            return Integer.parseInt(line);
        }
        catch (Exception e) {
            log.warn("Error reading glory data for {}: {}", (Object)hash, (Object)e.getMessage());
            return -1;
        }
    }
}

