/*
 * Decompiled with CFR 0.152.
 */
package tlk.jorva.glorycounter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tlk.jorva.glorycounter.LocalStorageHandler;

@PluginDescriptor(name="Glory Counter", description="Count how many glories you charge in the wilderness", tags={"eternal", "glory", "count", "counter"})
public class GloryCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GloryCounterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private LocalStorageHandler storageHandler;
    private static final List<Integer> GLORY_IDS = ImmutableList.of((Object)1704, (Object)1706, (Object)1708, (Object)1710, (Object)1712, (Object)11976, (Object)10362, (Object)10360, (Object)10358, (Object)10356, (Object)10354, (Object)11966, (Object[])new Integer[0]);
    private static final List<InventoryID> CONTAINER_IDS = ImmutableList.of((Object)InventoryID.INVENTORY, (Object)InventoryID.EQUIPMENT);
    private long userHash;
    private int chargeableGloryCount = 0;
    private int gloriesCharged = 0;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.save();
    }

    private void countGlories() {
        int glories = 0;
        for (InventoryID inventoryID : CONTAINER_IDS) {
            ItemContainer container = this.client.getItemContainer(inventoryID);
            if (container == null) continue;
            for (int id : GLORY_IDS) {
                glories += container.count(id);
            }
        }
        this.chargeableGloryCount = glories;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.userHash = this.client.getAccountHash();
            this.gloriesCharged = this.storageHandler.readFromFile(this.userHash);
            if (this.gloriesCharged == -1) {
                this.storageHandler.writeToFile(this.userHash, 0);
                this.gloriesCharged = 0;
            }
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted event) {
        if (event.getCommand().equalsIgnoreCase("glory")) {
            this.informPlayer();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.SPAM && event.getMessage().equalsIgnoreCase("You hold your jewellery against the fountain...")) {
            this.gloriesCharged += this.chargeableGloryCount;
            this.save();
            this.informPlayer();
            this.countGlories();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        this.countGlories();
    }

    private void _SendMessage(String msg) {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", msg, null);
    }

    private void informPlayer() {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", String.format("You've charged %s glor%s.", this.gloriesCharged, this.gloriesCharged == 1 ? "y" : "ies"), null);
    }

    private void save() {
        this.storageHandler.writeToFile(this.userHash, this.gloriesCharged);
    }
}

