/*
 * Decompiled with CFR 0.152.
 */
package com.itemretrievalwarning;

import com.google.inject.Provides;
import com.itemretrievalwarning.ItemRetrievalWarningConfig;
import com.itemretrievalwarning.ItemRetrievalWarningOverlay;
import com.itemretrievalwarning.ItemRetrievalWarningOverlayPanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Item Retrieval Service Warning")
public class ItemRetrievalWarningPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ItemRetrievalWarningPlugin.class);
    private static final int[] SAFE_REGIONS = new int[]{7508, 7509, 10322, 9520, 9620, 12889, 13136, 13137, 13138, 13139, 13140, 13141, 13145, 13393, 13394, 13395, 13396, 13397, 13401, 12621, 12622, 12623, 13130, 13131, 13133, 13134, 13135, 13386, 13387, 13390, 13641, 13642, 13643, 13644, 13645, 13646, 13647, 13899, 13900, 14155, 14156, 13362, 7499, 9043, 9806, 10062, 13658, 13659, 13660, 13914, 13915, 13916, 13918, 13919, 13920, 14174, 14175, 14176, 14430, 14431, 14432, 13462, 13463, 9033, 10536, 7513, 7514, 7769, 7770, 8493, 8749, 9005, 9551, 9552, 11854, 11855, 12110, 12111};
    private final int ITEM_RETRIEVAL_GROUP_ID = 602;
    private final int ITEM_RETRIEVAL_CHILD_NAME = 1;
    private final int ITEM_RETRIEVAL_CHILD_ITEMS = 3;
    private final int KEPT_ON_DEATH_ITEM_RETRIEVAL = 3;
    private boolean itemRetrievalInterfaceOpen = false;
    private boolean syncKeptItemsInterface = false;
    private boolean isDeathBanked = false;
    private boolean isWarning = false;
    private boolean deathBankStatusKnown = false;
    private int lastGameState = -1;
    private int currentRegion = -1;
    private ReminderInfobox infoBox;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemRetrievalWarningOverlayPanel overlayPanel;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ItemRetrievalWarningConfig config;
    @Inject
    private ItemRetrievalWarningOverlay overlay;

    @Provides
    ItemRetrievalWarningConfig provideConfig(ConfigManager configManager) {
        return (ItemRetrievalWarningConfig)configManager.getConfig(ItemRetrievalWarningConfig.class);
    }

    protected void startUp() throws Exception {
        this.infoBox = new ReminderInfobox((BufferedImage)this.itemManager.getImage(964), this);
        this.infoBox.setTooltip("You have items stored in an item retrieveal service.");
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.overlayPanel);
        this.confirmDeathbankStatusKnown(this.client.getGameState());
    }

    protected void shutDown() throws Exception {
        this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.overlayPanel);
        this.infoBox.showing = false;
        this.itemRetrievalInterfaceOpen = false;
        this.isWarning = false;
        this.deathBankStatusKnown = false;
        this.setDeathBanked(false);
        this.lastGameState = -1;
    }

    @Subscribe
    protected void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            if (chatMessage.getMessage().contains("retrieved some of your items") || chatMessage.getMessage().contains("items stored in an item retrieval service")) {
                this.setDeathBanked(true);
            } else if (chatMessage.getMessage().contains("You have died again") && chatMessage.getMessage().contains("lost the items")) {
                this.setDeathBanked(false);
            }
        }
    }

    @Subscribe
    protected void onWidgetLoaded(WidgetLoaded loaded) {
        if (loaded.getGroupId() == 602) {
            this.itemRetrievalInterfaceOpen = true;
            this.deathBankStatusKnown = true;
            this.processItemRetrievalInterface();
        } else if (loaded.getGroupId() == 4) {
            this.syncKeptItemsInterface = true;
        }
    }

    @Subscribe
    protected void onWidgetClosed(WidgetClosed closed) {
        if (closed.getGroupId() == 602) {
            this.itemRetrievalInterfaceOpen = false;
        }
    }

    @Subscribe
    protected void onGameTick(GameTick tick) {
        Widget npcDialog;
        this.currentRegion = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        this.checkHealth();
        this.refreshInfobox();
        if (this.itemRetrievalInterfaceOpen) {
            this.processItemRetrievalInterface();
        }
        if (this.syncKeptItemsInterface) {
            this.processKeptOnDeathInterface();
        }
        if (this.isWarning) {
            this.overlay.tick();
        }
        if (this.currentRegion == 8751 && (npcDialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT)) != null) {
            String message = npcDialog.getText().replace("<br>", " ");
            if (message.contains("You left some stuff at Zulrah's shrine when you left earlier") || message.contains("I've got some stuff you left at the shrine earlier")) {
                this.setDeathBanked(!message.contains("I've returned it to you now"));
            } else if (message.contains("I don't have anything for you to collect")) {
                this.setDeathBanked(false);
            }
        }
    }

    @Subscribe
    protected void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.confirmDeathbankStatusKnown(gameStateChanged.getGameState());
        this.lastGameState = gameStateChanged.getGameState().getState();
    }

    private void confirmDeathbankStatusKnown(GameState currentGameState) {
        this.deathBankStatusKnown = currentGameState.getState() != GameState.LOGGED_IN.getState() || this.lastGameState != -1;
    }

    private void processItemRetrievalInterface() {
        int itemCount = this.getItemRetrievalItemCount();
        this.setDeathBanked(itemCount != 0);
    }

    public void setDeathBanked(boolean deathBanked) {
        this.isDeathBanked = deathBanked;
    }

    private void processKeptOnDeathInterface() {
        this.syncKeptItemsInterface = false;
        Widget widget = this.client.getWidget(4, 3);
        if (widget != null) {
            if (widget.getChildren() != null) {
                for (Widget w : widget.getChildren()) {
                    if (w.getType() != 4 || !w.getText().contains("die again") || !w.getText().contains("before collecting") || !w.getText().contains("deleted")) continue;
                    this.deathBankStatusKnown = true;
                    this.setDeathBanked(true);
                    return;
                }
            } else {
                this.deathBankStatusKnown = true;
                this.setDeathBanked(false);
            }
        }
    }

    private void checkHealth() {
        int hp = (int)((double)this.client.getBoostedSkillLevel(Skill.HITPOINTS) / (double)this.client.getRealSkillLevel(Skill.HITPOINTS) * 100.0);
        boolean prevIsWarningValue = this.isWarning;
        boolean bl = this.isWarning = hp < this.config.warningThreshold() && this.riskingDeathBank();
        if (this.isWarning && !prevIsWarningValue) {
            this.notifier.notify("You are about to lose items you have stored in an item retrieval service!");
        }
    }

    private void refreshInfobox() {
        if (!(!this.infoBox.showing || this.isDeathBanked && this.config.displayInfobox())) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
            this.infoBox.showing = false;
        } else if (!this.infoBox.showing && this.isDeathBanked && this.config.displayInfobox()) {
            this.infoBoxManager.addInfoBox((InfoBox)this.infoBox);
            this.infoBox.showing = true;
        }
    }

    private int getItemRetrievalItemCount() {
        Widget[] widgets;
        int items = 0;
        Widget widget = this.client.getWidget(602, 3);
        if (widget != null && (widgets = widget.getChildren()) != null) {
            for (Widget w : widgets) {
                if (w == null || w.getItemId() == -1 || w.isHidden()) continue;
                ++items;
            }
        }
        return items;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public boolean isDeathBankStatusKnown() {
        return this.deathBankStatusKnown;
    }

    private boolean riskingDeathBank() {
        for (int region : SAFE_REGIONS) {
            if (region != this.currentRegion) continue;
            return false;
        }
        return this.isDeathBanked;
    }

    private class ReminderInfobox
    extends InfoBox {
        private boolean showing;

        private ReminderInfobox(BufferedImage image, ItemRetrievalWarningPlugin plugin) {
            super(image, (Plugin)plugin);
            this.showing = false;
        }

        public String getText() {
            return "";
        }

        public Color getTextColor() {
            return Color.WHITE;
        }
    }
}

