/*
 * Decompiled with CFR 0.152.
 */
package com.timetrackingreminder;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.timetrackingreminder.TimeTrackingReminderConfig;
import com.timetrackingreminder.TimeTrackingReminderGroupInfoBox;
import com.timetrackingreminder.TimeTrackingReminderInfoBox;
import com.timetrackingreminder.runelite.farming.CompostTracker;
import com.timetrackingreminder.runelite.farming.FarmingContractManager;
import com.timetrackingreminder.runelite.farming.FarmingTracker;
import com.timetrackingreminder.runelite.farming.FarmingWorld;
import com.timetrackingreminder.runelite.farming.PaymentTracker;
import com.timetrackingreminder.runelite.farming.Tab;
import com.timetrackingreminder.runelite.hunter.BirdHouseTracker;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.timetracking.SummaryState;
import net.runelite.client.plugins.timetracking.TimeTrackingConfig;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Time Tracking Reminder", description="Extend the \"Time Tracking\" plugin to show an infobox when bird houses or farming patches are ready.")
public class TimeTrackingReminderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TimeTrackingReminderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TimeTrackingReminderConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    private BirdHouseTracker birdHouseTracker;
    private FarmingTracker farmingTracker;
    private FarmingContractManager farmingContractManager;
    private TimeTrackingReminderInfoBox[] reminderInfoBoxes;
    private TimeTrackingReminderGroupInfoBox groupInfoBox;

    @Provides
    TimeTrackingReminderConfig provideConfig(ConfigManager configManager) {
        return (TimeTrackingReminderConfig)configManager.getConfig(TimeTrackingReminderConfig.class);
    }

    protected void startUp() throws Exception {
        log.info("Time Tracking Reminder started!");
        this.initializeTrackers();
        this.initializeReminderGroups();
    }

    private void initializeTrackers() {
        TimeTrackingConfig timeTrackingConfig = (TimeTrackingConfig)this.configManager.getConfig(TimeTrackingConfig.class);
        FarmingWorld farmingWorld = new FarmingWorld();
        CompostTracker compostTracker = new CompostTracker(this.client, farmingWorld, this.configManager);
        PaymentTracker paymentTracker = new PaymentTracker(this.client, this.configManager, farmingWorld);
        this.birdHouseTracker = new BirdHouseTracker(this.client, this.itemManager, this.configManager, timeTrackingConfig, this.notifier);
        this.farmingTracker = new FarmingTracker(this.client, this.itemManager, this.configManager, timeTrackingConfig, farmingWorld, this.notifier, compostTracker, paymentTracker);
        this.farmingContractManager = new FarmingContractManager(this.client, this.itemManager, this.configManager, timeTrackingConfig, farmingWorld, this.farmingTracker);
    }

    private void initializeReminderGroups() {
        for (TimeTrackingReminderInfoBox infoBox : this.reminderInfoBoxes = new TimeTrackingReminderInfoBox[]{new TimeTrackingReminderInfoBox(this, this.config, "bird houses", "Your bird houses are ready.", (BufferedImage)this.itemManager.getImage(21515), () -> this.config.birdHouses() && this.birdHouseTracker.getSummary() != SummaryState.IN_PROGRESS), new TimeTrackingReminderInfoBox(this, this.config, "herb patches", "Your herb patches are ready.", (BufferedImage)this.itemManager.getImage(207), () -> this.config.herbPatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.HERB) != false : this.farmingTracker.getSummary(Tab.HERB) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "allotment patches", "Your allotment patches are ready.", (BufferedImage)this.itemManager.getImage(1965), () -> this.config.allotmentPatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.ALLOTMENT) != false : this.farmingTracker.getSummary(Tab.ALLOTMENT) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "tree patches", "Your tree patches are ready.", (BufferedImage)this.itemManager.getImage(1515), () -> this.config.treePatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.TREE) != false : this.farmingTracker.getSummary(Tab.TREE) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "fruit tree patches", "Your fruit tree patches are ready.", (BufferedImage)this.itemManager.getImage(2114), () -> this.config.fruitTreePatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.FRUIT_TREE) != false : this.farmingTracker.getSummary(Tab.FRUIT_TREE) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "seaweed patches", "Your seaweed patches are ready.", (BufferedImage)this.itemManager.getImage(21504), () -> this.config.seaweedPatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.SEAWEED) != false : this.farmingTracker.getSummary(Tab.SEAWEED) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "bush patches", "Your bush patches are ready.", (BufferedImage)this.itemManager.getImage(239), () -> this.config.bushPatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.BUSH) != false : this.farmingTracker.getSummary(Tab.BUSH) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "farming contract", "Your farming contract is ready.", (BufferedImage)this.itemManager.getImage(22993), () -> {
            boolean isInProgress = this.farmingContractManager.getSummary() == SummaryState.IN_PROGRESS;
            boolean isOccupiedWrongSeed = this.farmingContractManager.getSummary() == SummaryState.OCCUPIED && this.farmingContractManager.getContractCropState() == null;
            boolean farmingContractReady = !isInProgress && !isOccupiedWrongSeed;
            return this.config.farmingContract() && farmingContractReady;
        }), new TimeTrackingReminderInfoBox(this, this.config, "Hespori patch", "Your Hespori patch is ready.", (BufferedImage)this.itemManager.getImage(20661), () -> this.config.hespori() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.HESPORI) != false : this.farmingTracker.getSummary(Tab.HESPORI) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "giant compost bin", "Your giant compost bin is ready.", (BufferedImage)this.itemManager.getImage(21483), () -> this.config.giantCompostBin() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.BIG_COMPOST) != false : this.farmingTracker.getSummary(Tab.BIG_COMPOST) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "calquat patch", "Your calquat patch is ready.", (BufferedImage)this.itemManager.getImage(5980), () -> this.config.calquatPatch() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.CALQUAT) != false : this.farmingTracker.getSummary(Tab.CALQUAT) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "hardwood patches", "Your hardwood patches are ready.", (BufferedImage)this.itemManager.getImage(6333), () -> this.config.hardwoodPatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.HARDWOOD) != false : this.farmingTracker.getSummary(Tab.HARDWOOD) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "hops patches", "Your hops patches are ready.", (BufferedImage)this.itemManager.getImage(6006), () -> this.config.hopsPatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.HOPS) != false : this.farmingTracker.getSummary(Tab.HOPS) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "cactus patches", "Your cactus patches are ready.", (BufferedImage)this.itemManager.getImage(3138), () -> this.config.cactusPatches() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.CACTUS) != false : this.farmingTracker.getSummary(Tab.CACTUS) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "redwood patch", "Your redwood patch is ready.", (BufferedImage)this.itemManager.getImage(19669), () -> this.config.redwoodPatch() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.REDWOOD) != false : this.farmingTracker.getSummary(Tab.REDWOOD) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "mushroom patch", "Your mushroom patch is ready.", (BufferedImage)this.itemManager.getImage(6004), () -> this.config.mushroomPatch() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.MUSHROOM) != false : this.farmingTracker.getSummary(Tab.MUSHROOM) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "belladonna patch", "Your belladonna patch is ready.", (BufferedImage)this.itemManager.getImage(27790), () -> this.config.belladonnaPatch() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.BELLADONNA) != false : this.farmingTracker.getSummary(Tab.BELLADONNA) != SummaryState.IN_PROGRESS)), new TimeTrackingReminderInfoBox(this, this.config, "Crystal patch", "Your Crystal patch is ready.", (BufferedImage)this.itemManager.getImage(23962), () -> this.config.crystalPatch() && (this.config.onlyHarvestable() ? this.farmingTracker.getHarvestable(Tab.CRYSTAL) != false : this.farmingTracker.getSummary(Tab.CRYSTAL) != SummaryState.IN_PROGRESS && this.farmingTracker.getSummary(Tab.CRYSTAL) != SummaryState.EMPTY))}) {
            this.infoBoxManager.addInfoBox((InfoBox)infoBox);
        }
        this.groupInfoBox = new TimeTrackingReminderGroupInfoBox(this, this.config, (BufferedImage)this.itemManager.getImage(2575));
        this.infoBoxManager.addInfoBox((InfoBox)this.groupInfoBox);
    }

    protected void shutDown() throws Exception {
        log.info("Time Tracking Reminder stopped!");
        for (TimeTrackingReminderInfoBox infoBox : this.reminderInfoBoxes) {
            this.infoBoxManager.removeInfoBox((InfoBox)infoBox);
        }
        this.infoBoxManager.removeInfoBox((InfoBox)this.groupInfoBox);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.birdHouseTracker.loadFromConfig();
        this.farmingTracker.loadCompletionTimes();
        this.farmingContractManager.loadContractFromConfig();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("timetracking")) {
            return;
        }
        this.birdHouseTracker.loadFromConfig();
        this.farmingTracker.loadCompletionTimes();
        this.farmingContractManager.loadContractFromConfig();
    }

    @Subscribe
    public void onGameTick(GameTick t) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.birdHouseTracker.updateCompletionTime();
        this.farmingTracker.updateCompletionTime();
        this.farmingContractManager.handleContractState();
    }

    public boolean showInfoboxInInstance() {
        return this.config.showInInstances() || !this.client.isInInstancedRegion();
    }

    public TimeTrackingReminderInfoBox[] getReminderInfoBoxes() {
        return this.reminderInfoBoxes;
    }
}

