/*
 * Decompiled with CFR 0.152.
 */
package com.timetrackingreminder;

import com.timetrackingreminder.TimeTrackingReminderConfig;
import com.timetrackingreminder.TimeTrackingReminderPlugin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.function.BooleanSupplier;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;

class TimeTrackingReminderInfoBox
extends InfoBox {
    private final TimeTrackingReminderPlugin plugin;
    private final TimeTrackingReminderConfig config;
    private final String tooltip;
    private final BooleanSupplier shouldShowInfoBox;
    private final String shortName;

    TimeTrackingReminderInfoBox(TimeTrackingReminderPlugin plugin, TimeTrackingReminderConfig config, String shortName, String tooltip, BufferedImage image, BooleanSupplier shouldShowInfoBox) {
        super(image, (Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.shortName = shortName;
        this.tooltip = tooltip;
        this.shouldShowInfoBox = shouldShowInfoBox;
    }

    public String getName() {
        String id = this.tooltip.toLowerCase().replaceAll("\\W+", "_");
        return ((Object)((Object)this.plugin)).getClass().getSimpleName() + "_" + ((Object)((Object)this)).getClass().getSimpleName() + "_" + id;
    }

    public String getText() {
        return this.config.customMessage();
    }

    public Color getTextColor() {
        return Color.GREEN;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean render() {
        if (!this.plugin.showInfoboxInInstance() || this.config.groupBoxesTogether()) {
            return false;
        }
        return this.shouldShowInfoBox.getAsBoolean();
    }

    public BooleanSupplier getShouldShowInfoBox() {
        return this.shouldShowInfoBox;
    }

    public String getShortName() {
        return this.shortName;
    }
}

