/*
 * Decompiled with CFR 0.152.
 */
package de0.nmtimers;

import de0.nmtimers.NightmarePlugin;
import de0.util.MiscUtil;
import java.awt.Color;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.ImageUtil;

public class NightmareInfoBox
extends InfoBox {
    private NightmarePlugin plugin;
    private Client client;

    public NightmareInfoBox(Client client, NightmarePlugin plugin) {
        super(ImageUtil.loadImageResource(NightmareInfoBox.class, (String)"nightmare.png"), (Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
    }

    public String getText() {
        Object str = this.plugin.phase_splits[0] != -1 ? MiscUtil.to_mmss(this.plugin.phase_splits[0]) : MiscUtil.to_mmss(this.client.getTickCount() - this.plugin.fight_timer);
        if (this.plugin.dirty) {
            str = (String)str + "*";
        }
        return str;
    }

    public Color getTextColor() {
        return this.plugin.phase_splits[0] == -1 ? Color.WHITE : Color.GREEN;
    }

    public String getTooltip() {
        StringBuilder builder = new StringBuilder();
        builder.append("Elapsed nightmare time: ");
        if (this.plugin.phase_splits[0] != -1) {
            builder.append(MiscUtil.to_mmss_precise_short(this.plugin.phase_splits[0]));
        } else {
            builder.append(MiscUtil.to_mmss_precise_short(this.client.getTickCount() - this.plugin.fight_timer));
        }
        if (this.plugin.phase_splits[1] != -1) {
            builder.append("</br>First phase: ");
            builder.append(MiscUtil.to_mmss_precise_short(this.plugin.phase_splits[1]));
        }
        if (this.plugin.phase_splits[2] != -1) {
            builder.append("</br>Second phase: ");
            builder.append(MiscUtil.to_mmss_precise_short(this.plugin.phase_splits[2]));
        }
        if (this.plugin.phase_splits[3] != -1) {
            builder.append("</br>Third phase: ");
            builder.append(MiscUtil.to_mmss_precise_short(this.plugin.phase_splits[3]));
        }
        if (this.plugin.phase_splits[4] != -1) {
            builder.append("</br>Fourth phase: ");
            builder.append(MiscUtil.to_mmss_precise_short(this.plugin.phase_splits[4]));
        }
        if (this.plugin.phase_splits[5] != -1) {
            builder.append("</br>Final phase: ");
            builder.append(MiscUtil.to_mmss_precise_short(this.plugin.phase_splits[5]));
        }
        return builder.toString();
    }
}

