/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import com.google.inject.Provides;
import eu.jodelahithit.Utils;
import eu.jodelahithit.WintertodtActivity;
import eu.jodelahithit.WintertodtInterruptType;
import eu.jodelahithit.WintertodtNotificationsConfig;
import eu.jodelahithit.WintertodtNotificationsOverlay;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Wintertodt Notifications", description="Visual notifications for Wintertodt", tags={"notifications", "wintertodt"})
public class WintertodtNotificationsPlugin
extends Plugin {
    private static final int WINTERTODT_REGION = 6462;
    private boolean isInWintertodt;
    private Instant walkingInstant = Instant.now();
    private Instant lastActionTime = Instant.now();
    private WintertodtActivity currentActivity = WintertodtActivity.IDLE;
    private int timerValue;
    private LocalPoint lastPlayerLocation;
    @Inject
    Client client;
    @Inject
    private WintertodtNotificationsConfig config;
    @Inject
    private WintertodtNotificationsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    WintertodtNotificationsConfig getConfig(ConfigManager configManager) {
        return (WintertodtNotificationsConfig)configManager.getConfig(WintertodtNotificationsConfig.class);
    }

    protected void startUp() throws Exception {
        this.currentActivity = WintertodtActivity.IDLE;
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.currentActivity = WintertodtActivity.IDLE;
    }

    private boolean isInWintertodtRegion() {
        if (this.client.getLocalPlayer() != null) {
            return this.client.getLocalPlayer().getWorldLocation().getRegionID() == 6462;
        }
        return false;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.isInWintertodtRegion()) {
            if (this.isInWintertodt) {
                this.currentActivity = WintertodtActivity.IDLE;
            }
            this.isInWintertodt = false;
            return;
        }
        if (!this.isInWintertodt) {
            this.currentActivity = WintertodtActivity.IDLE;
        }
        this.isInWintertodt = true;
        Player player = this.client.getLocalPlayer();
        if (player != null) {
            LocalPoint playerLocation = player.getLocalLocation();
            if (!playerLocation.equals((Object)this.lastPlayerLocation)) {
                this.walkingInstant = Instant.now();
            }
            this.lastPlayerLocation = playerLocation;
        }
        this.checkActionTimeout();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.timerValue = this.client.getVar(7980);
    }

    private void checkActionTimeout() {
        int currentAnimation;
        if (this.currentActivity == WintertodtActivity.IDLE) {
            return;
        }
        int n = currentAnimation = this.client.getLocalPlayer() != null ? this.client.getLocalPlayer().getAnimation() : -1;
        if (currentAnimation != -1 || this.lastActionTime == null) {
            return;
        }
        Duration actionTimeout = Duration.ofSeconds(3L);
        Duration sinceAction = Duration.between(this.lastActionTime, Instant.now());
        if (sinceAction.compareTo(actionTimeout) >= 0) {
            this.currentActivity = WintertodtActivity.IDLE;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        WintertodtInterruptType interruptType;
        if (!this.isInWintertodt) {
            return;
        }
        ChatMessageType chatMessageType = chatMessage.getType();
        if (chatMessageType != ChatMessageType.GAMEMESSAGE && chatMessageType != ChatMessageType.SPAM) {
            return;
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        if (messageNode.getValue().startsWith("You carefully fletch the root")) {
            this.setActivity(WintertodtActivity.FLETCHING);
            return;
        }
        if (messageNode.getValue().startsWith("The cold of")) {
            interruptType = WintertodtInterruptType.COLD;
        } else if (messageNode.getValue().startsWith("The freezing cold attack")) {
            interruptType = WintertodtInterruptType.SNOWFALL;
        } else if (messageNode.getValue().startsWith("The brazier is broken and shrapnel")) {
            interruptType = WintertodtInterruptType.BRAZIER;
        } else if (messageNode.getValue().startsWith("You have run out of bruma roots")) {
            interruptType = WintertodtInterruptType.OUT_OF_ROOTS;
        } else if (messageNode.getValue().startsWith("Your inventory is too full")) {
            interruptType = WintertodtInterruptType.INVENTORY_FULL;
        } else if (messageNode.getValue().startsWith("You fix the brazier")) {
            interruptType = WintertodtInterruptType.FIXED_BRAZIER;
        } else if (messageNode.getValue().startsWith("You light the brazier")) {
            interruptType = WintertodtInterruptType.LIT_BRAZIER;
        } else if (messageNode.getValue().startsWith("The brazier has gone out.")) {
            interruptType = WintertodtInterruptType.BRAZIER_WENT_OUT;
        } else if (messageNode.getValue().startsWith("Congratulations, you've just advanced your")) {
            interruptType = WintertodtInterruptType.LEVEL_UP;
        } else {
            return;
        }
        boolean wasInterrupted = false;
        if (interruptType == WintertodtInterruptType.SNOWFALL || interruptType == WintertodtInterruptType.COLD || interruptType == WintertodtInterruptType.BRAZIER) {
            if (this.currentActivity != WintertodtActivity.WOODCUTTING && this.currentActivity != WintertodtActivity.IDLE) {
                wasInterrupted = true;
            }
        } else {
            wasInterrupted = true;
        }
        if (wasInterrupted) {
            this.currentActivity = WintertodtActivity.IDLE;
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!this.isInWintertodt) {
            return;
        }
        Player local = this.client.getLocalPlayer();
        if (event.getActor() != local) {
            return;
        }
        int animId = local.getAnimation();
        switch (animId) {
            case 24: 
            case 867: 
            case 869: 
            case 871: 
            case 873: 
            case 875: 
            case 877: 
            case 879: 
            case 2117: 
            case 2846: 
            case 7264: 
            case 8303: 
            case 8324: 
            case 8778: {
                this.setActivity(WintertodtActivity.WOODCUTTING);
                break;
            }
            case 1248: {
                this.setActivity(WintertodtActivity.FLETCHING);
                break;
            }
            case 832: {
                this.setActivity(WintertodtActivity.FEEDING_BRAZIER);
                break;
            }
            case 733: {
                this.setActivity(WintertodtActivity.LIGHTING_BRAZIER);
                break;
            }
            case 3676: 
            case 8912: {
                this.setActivity(WintertodtActivity.FIXING_BRAZIER);
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        Item[] inv;
        ItemContainer container = event.getItemContainer();
        if (!this.isInWintertodt || container != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        int numLogs = 0;
        int numKindling = 0;
        block4: for (Item item : inv = container.getItems()) {
            switch (item.getId()) {
                case 20695: {
                    ++numLogs;
                    continue block4;
                }
                case 20696: {
                    ++numKindling;
                }
            }
        }
        if (numLogs == 0 && this.currentActivity == WintertodtActivity.FLETCHING) {
            this.currentActivity = WintertodtActivity.IDLE;
        } else if (numLogs == 0 && numKindling == 0 && this.currentActivity == WintertodtActivity.FEEDING_BRAZIER) {
            this.currentActivity = WintertodtActivity.IDLE;
        }
    }

    private void setActivity(WintertodtActivity action) {
        if (action != WintertodtActivity.IDLE) {
            this.walkingInstant = this.walkingInstant.minus(1L, ChronoUnit.MINUTES);
        }
        this.currentActivity = action;
        this.lastActionTime = Instant.now();
    }

    public boolean shouldRenderOverlay() {
        return this.isInWintertodt && this.currentActivity == WintertodtActivity.IDLE && this.timerValue == 0 && !Utils.checkInstant(this.walkingInstant, 1.0f);
    }
}

