/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import eu.jodelahithit.Utils;
import eu.jodelahithit.WintertodtNotificationsConfig;
import eu.jodelahithit.WintertodtNotificationsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ColorUtil;

class WintertodtNotificationsOverlay
extends Overlay {
    private final Client client;
    private final WintertodtNotificationsPlugin plugin;
    private final WintertodtNotificationsConfig config;
    private final float TEXT_COLOR_LERP = 0.75f;

    @Inject
    private WintertodtNotificationsOverlay(Client client, WintertodtNotificationsPlugin plugin, WintertodtNotificationsConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.shouldRenderOverlay()) {
            if (this.config.flash() && this.client.getGameCycle() % 40 >= 20) {
                return null;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.config.overlayColor());
            graphics.fill(new Rectangle(this.client.getCanvas().getSize()));
            graphics.setColor(color);
            if (!this.config.disableOverlayText()) {
                Point location = new Point(this.client.getCanvasWidth() / 2, this.client.getCanvasHeight() / 8);
                Utils.renderTextCentered(graphics, location, "Wintertodt Notification", ColorUtil.colorLerp((Color)Color.white, (Color)this.config.overlayColor(), (double)0.75));
            }
        }
        return null;
    }
}

