/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import net.runelite.api.Point;
import net.runelite.client.util.ColorUtil;

public class Utils {
    public static int getStringWidth(Graphics graphics, String text) {
        FontMetrics metrics = graphics.getFontMetrics();
        return metrics.stringWidth(text);
    }

    public static void renderTextCentered(Graphics2D graphics, Point txtLoc, String text, Color color) {
        if (!Strings.isNullOrEmpty((String)text)) {
            int x = txtLoc.getX();
            int y = txtLoc.getY();
            int halfStringWidth = Utils.getStringWidth(graphics, text) / 2;
            graphics.setColor(Color.BLACK);
            graphics.drawString(text, x - halfStringWidth + 1, y + 1);
            graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)255));
            graphics.drawString(text, x - halfStringWidth, y);
        }
    }

    public static boolean checkInstant(Instant instant, float timeout) {
        return (float)Duration.between(instant, Instant.now()).toMillis() < timeout * 1000.0f;
    }
}

