/*
 * Decompiled with CFR 0.152.
 */
package com.commitorquit;

import com.commitorquit.ApiTool;
import com.commitorquit.DiscordRecruitmentConfig;
import com.commitorquit.discord.Author;
import com.commitorquit.discord.Embed;
import com.commitorquit.discord.Field;
import com.commitorquit.discord.Webhook;
import com.google.inject.Provides;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Recruitment Notificater", description="Sends a  notification via Discord webhooks whenever you invite someone to your clan.", tags={"discord", "clan", "recruitment", "notification"})
public class DiscordRecruitmentPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordRecruitmentPlugin.class);
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private DiscordRecruitmentConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private DrawManager drawManager;
    private CompletableFuture<Image> queuedScreenshot = null;
    private ApiTool apiTool;

    @Provides
    DiscordRecruitmentConfig provideConfig(ConfigManager configManager) {
        return (DiscordRecruitmentConfig)configManager.getConfig(DiscordRecruitmentConfig.class);
    }

    protected void startUp() throws Exception {
        this.apiTool = new ApiTool(this.httpClient);
        super.startUp();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) throws ExecutionException, InterruptedException {
        String target_str;
        if (event.getType() != ChatMessageType.CLAN_MESSAGE) {
            return;
        }
        String msg = event.getMessage();
        if (!(msg = Text.removeTags((String)msg).replace('\u00a0', ' ').trim()).contains(target_str = " has been invited into the clan by ")) {
            Object invited = null;
            Object recruiter = null;
            return;
        }
        String tosplit = msg.replace(target_str, ":");
        log.info("tosplit: " + tosplit);
        String[] splitted = tosplit.split(":");
        String invited = Text.toJagexName((String)splitted[0]);
        String recruiter = Text.toJagexName((String)splitted[1]);
        log.error(Arrays.toString(recruiter.split(".")));
        log.info("splitted: " + invited + " " + recruiter);
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "clan recruitment plugin", msg + " event type: " + event.getType(), null);
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "clan recruitment plugin", "invited: " + invited + " recruiter " + recruiter, null);
        log.error("invited: " + invited + " recruiter: " + recruiter);
        this.sendWebhookData(this.getWebhookUrls(), this.createRecruitmentNotification(msg, recruiter, invited)).get();
    }

    private void queueScreenshot() {
        if (this.queuedScreenshot == null && this.config.sendScreenshot()) {
            this.queuedScreenshot = this.getScreenshot();
        }
    }

    private Webhook createRecruitmentNotification(String msg, String recruiter_name, String invited_name) {
        Author author = new Author();
        author.setName(recruiter_name);
        Embed embed = new Embed();
        embed.setAuthor(author);
        Field recruiter = new Field();
        recruiter.setName("Recruiter");
        recruiter.setValue(recruiter_name);
        recruiter.setInline(false);
        Field invited = new Field();
        invited.setName("Invited/Joined");
        invited.setValue(invited_name);
        invited.setInline(false);
        embed.setFields(new Field[]{recruiter, invited});
        embed.setDescription(msg);
        Webhook webhookData = new Webhook();
        webhookData.setEmbeds(new Embed[]{embed});
        return webhookData;
    }

    private CompletableFuture<Image> getScreenshot() {
        CompletableFuture<Image> f = new CompletableFuture<Image>();
        this.drawManager.requestNextFrameListener(screenshotImage -> f.complete((Image)screenshotImage));
        return f;
    }

    private CompletableFuture<Void> sendWebhookData(List<String> webhookUrls, Webhook webhookData) {
        JSONObject json = new JSONObject(webhookData);
        String jsonStr = json.toString();
        ArrayList exceptions = new ArrayList();
        List<CompletableFuture> sends = webhookUrls.stream().map(url -> ((CompletableFuture)this.apiTool.postRaw((String)url, jsonStr, "application/json").handle((_v, e) -> {
            if (e != null) {
                exceptions.add(e);
            }
            return null;
        })).thenAccept(_v -> {})).collect(Collectors.toList());
        return CompletableFuture.allOf(sends.toArray(new CompletableFuture[sends.size()])).thenCompose(_v -> {
            if (exceptions.size() > 0) {
                log.error(String.format("sendWebhookData got %d error(s)", exceptions.size()));
                exceptions.forEach(t -> log.error(t.getMessage()));
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally((Throwable)exceptions.get(0));
                return f;
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private void sendScreenshot(Image screenshot) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)((BufferedImage)screenshot), "png", baos);
            byte[] imageBytes = baos.toByteArray();
            this.apiTool.postFormImage(this.config.webhookUrl(), imageBytes, "image/png").get();
        }
        catch (Exception e) {
            log.error("sendScreenshot error: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getPlayerName() {
        return this.client.getLocalPlayer().getName();
    }

    private List<String> getWebhookUrls() {
        return Arrays.asList(this.config.webhookUrl().split("\n")).stream().filter(u -> u.length() > 0).map(u -> u.trim()).collect(Collectors.toList());
    }
}

