/*
 * Decompiled with CFR 0.152.
 */
package com.commitorquit;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ApiTool {
    private static ApiTool _instance;
    @Inject
    private OkHttpClient httpClient;

    public ApiTool(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getIconUrl(int id) {
        return String.format("https://static.runelite.net/cache/item/icon/%d.png", id);
    }

    public CompletableFuture<ResponseBody> postRaw(String url, String data, String type) {
        Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)type), (String)data)).build();
        return this.callRequest(request);
    }

    public CompletableFuture<Void> postFormImage(String url, byte[] imageBytes, String type) {
        MultipartBody.Builder requestBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)type), (byte[])imageBytes));
        Request request = new Request.Builder().url(url).post((RequestBody)requestBuilder.build()).build();
        return this.callRequest(request).thenAccept(rb -> {});
    }

    private CompletableFuture<ResponseBody> callRequest(Request request) {
        final CompletableFuture<ResponseBody> future = new CompletableFuture<ResponseBody>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (!response.isSuccessful()) {
                        future.completeExceptionally(new IOException("Unexpected code " + response));
                    } else {
                        future.complete(responseBody);
                    }
                }
                response.close();
            }
        });
        return future;
    }
}

