/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcbelanger.spacebar;

import com.github.jcbelanger.spacebar.SpacebarCheckerConfig;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.Counter;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Spacebar Checker", description="Counts consecutive spacebar messages in chats.")
public class SpacebarCheckerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpacebarCheckerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SpacebarCheckerConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private Notifier notifier;
    private final Pattern allWhitespace = Pattern.compile("^\\s*$");
    private final EnumMap<ChatMessageType, Set<String>> chatRunContributors = new EnumMap(ChatMessageType.class);
    private final EnumMap<ChatMessageType, Counter> chatRunCounters = new EnumMap(ChatMessageType.class);
    private final EnumSet<ChatMessageType> trackedChats = EnumSet.of(ChatMessageType.PUBLICCHAT, ChatMessageType.FRIENDSCHAT, ChatMessageType.CLAN_CHAT, ChatMessageType.CLAN_GUEST_CHAT);

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        boolean isRunStarted;
        boolean isRunContinued;
        ChatMessageType chatType = chatMessage.getType();
        if (!this.trackedChats.contains(chatType)) {
            return;
        }
        Set chatContributors = this.chatRunContributors.computeIfAbsent(chatType, key -> new HashSet());
        Counter chatRunCounter = this.chatRunCounters.computeIfAbsent(chatType, key -> {
            BufferedImage image = ImageUtil.loadImageResource(SpacebarCheckerPlugin.class, (String)"spacebar.png");
            String text = String.format("%s spacebar check", this.chatName(chatType));
            Counter counter = new Counter(image, (Plugin)this, 0);
            counter.setTooltip(text);
            return counter;
        });
        boolean isAllWhitespace = this.allWhitespace.matcher(chatMessage.getMessage()).find();
        boolean isContributorAllowed = this.config.isDuplicatesAllowed() || !chatContributors.contains(chatMessage.getName());
        boolean bl = isRunContinued = isAllWhitespace && isContributorAllowed;
        if (isRunContinued) {
            chatRunCounter.setCount(chatRunCounter.getCount() + 1);
            chatContributors.add(chatMessage.getName());
        } else {
            boolean bl2 = isRunStarted = chatRunCounter.getCount() > 0 && chatRunCounter.getCount() >= this.config.minRunStart();
            if (isRunStarted) {
                String reason = !isAllWhitespace ? "" : (!isContributorAllowed ? " for already contributing" : " for unknown reasons");
                String text = String.format("%s ended the %s spacebar check with run of %d%s.", chatMessage.getMessageNode().getName(), this.chatName(chatType), chatRunCounter.getCount(), reason);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", text, null);
            }
            this.reset(chatType);
        }
        boolean bl3 = isRunStarted = chatRunCounter.getCount() > 0 && chatRunCounter.getCount() == this.config.minRunStart();
        if (isRunStarted) {
            if (!this.infoBoxManager.getInfoBoxes().contains(chatRunCounter)) {
                this.infoBoxManager.addInfoBox((InfoBox)chatRunCounter);
            }
            if (this.config.isNotifyOnStart()) {
                String text = String.format("A new spacebar check started in %s!", this.chatName(chatType));
                this.notifier.notify(text);
            }
        }
    }

    protected void reset(ChatMessageType chatType) {
        this.chatRunContributors.remove(chatType);
        Counter counter = this.chatRunCounters.remove(chatType);
        counter.setCount(0);
        this.infoBoxManager.removeInfoBox((InfoBox)counter);
    }

    protected void reset() {
        this.chatRunCounters.keySet().forEach(this::reset);
    }

    protected void startUp() throws Exception {
        this.reset();
    }

    protected void shutDown() throws Exception {
        this.reset();
    }

    protected String chatName(ChatMessageType chatType) {
        switch (chatType) {
            case PUBLICCHAT: {
                return "Public Chat";
            }
            case FRIENDSCHAT: {
                return "Friends Chat";
            }
            case CLAN_CHAT: {
                return "Clan Chat";
            }
            case CLAN_GUEST_CHAT: {
                return "Clan Guest Chat";
            }
        }
        return "Chat";
    }

    @Provides
    SpacebarCheckerConfig provideConfig(ConfigManager configManager) {
        return (SpacebarCheckerConfig)configManager.getConfig(SpacebarCheckerConfig.class);
    }
}

