/*
 * Decompiled with CFR 0.152.
 */
package com.lowdetailraids;

import com.google.inject.Provides;
import com.lowdetailraids.AutomaticLowDetailConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.lowmemory.LowMemoryConfig;
import net.runelite.client.plugins.lowmemory.LowMemoryPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Automatic Low Detail", description="Automatically turn off ground decorations while inside certain areas (like raids)", tags={"memory", "ground", "decorations", "cox", "xeric", "tob", "theatre", "toa", "amascut", "sepulchre", "inferno"}, configName="LowDetailRaidsPlugin")
public class AutomaticLowDetailPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AutomaticLowDetailPlugin.class);
    public static final String CONFIG_NAME = "LowDetailRaidsPlugin";
    private static final int VARP_IN_RAID_ENCOUNTER = 2926;
    private static final int VARBIT_IN_PARTY_TOMBS_OF_AMASCUT = 14345;
    private static final int VARBIT_IN_INFERNO = 11878;
    private static final int VARBIT_IN_HALLOWED_SEPULCHRE = 10392;
    private static final Set<Integer> RELEVANT_EVENT_VARPS = new HashSet<Integer>(Collections.singletonList(2926));
    private static final Set<Integer> RELEVANT_EVENT_VARBITS = new HashSet<Integer>(Arrays.asList(5432, 6440, 14345, 11878, 10392));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private AutomaticLowDetailConfig config;
    private boolean lowDetailModeEnabled = false;

    protected void startUp() {
        this.lowDetailModeEnabled = this.lowDetailPluginEnabled();
        this.updateLowDetailMode();
    }

    protected void shutDown() {
        if (!this.lowDetailPluginEnabled()) {
            this.clientThread.invoke(() -> this.client.changeMemoryMode(false));
        }
    }

    @Provides
    AutomaticLowDetailConfig getConfig(ConfigManager configManager) {
        return (AutomaticLowDetailConfig)configManager.getConfig(AutomaticLowDetailConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("lowdetailraids")) {
            this.updateLowDetailMode();
        } else if (event.getGroup().equals("lowmemory")) {
            this.lowDetailModeEnabled = this.lowDetailPluginEnabled();
            this.clientThread.invokeAtTickEnd(() -> this.clientThread.invokeLater(this::updateLowDetailMode));
        }
    }

    @Subscribe
    public void onPluginChanged(PluginChanged event) {
        if (event.getPlugin() instanceof LowMemoryPlugin) {
            this.lowDetailModeEnabled = this.lowDetailPluginEnabled();
            this.updateLowDetailMode();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.varbitChangedEventIsRelevant(event)) {
            this.updateLowDetailMode();
        }
    }

    private boolean varbitChangedEventIsRelevant(VarbitChanged event) {
        return RELEVANT_EVENT_VARPS.contains(event.getVarpId()) || RELEVANT_EVENT_VARBITS.contains(event.getVarbitId());
    }

    private void updateLowDetailMode() {
        this.clientThread.invoke(() -> {
            if (!this.lowDetailModeEnabled && this.canEnableLowDetailMode()) {
                this.client.changeMemoryMode(true);
                this.lowDetailModeEnabled = true;
                log.debug("Automatically enabled Low Detail Mode");
                return true;
            }
            if (this.canDisableLowDetailMode()) {
                this.client.changeMemoryMode(false);
                this.lowDetailModeEnabled = false;
                log.debug("Automatically disabled Low Detail Mode");
                return true;
            }
            return true;
        });
    }

    private boolean canEnableLowDetailMode() {
        if (this.client.getGameState().getState() < GameState.LOGIN_SCREEN.getState()) {
            return false;
        }
        if (this.insideChambersOfXeric()) {
            return this.config.chambersOfXeric();
        }
        if (this.insideTheatreOfBlood()) {
            return this.config.theatreOfBlood();
        }
        if (this.insideTombsOfAmascut()) {
            return this.config.tombsOfAmascut();
        }
        if (this.insideInferno()) {
            return this.config.inferno();
        }
        if (this.insideHallowedSepulchre()) {
            return this.config.hallowedSepulchre();
        }
        return false;
    }

    private boolean canDisableLowDetailMode() {
        return !this.lowDetailPluginEnabled() && !this.canEnableLowDetailMode();
    }

    private boolean insideRaidEncounter() {
        return this.client.getVarpValue(2926) != 0;
    }

    private boolean insideChambersOfXeric() {
        return this.client.getVarbitValue(5432) != 0;
    }

    private boolean insideTheatreOfBlood() {
        return this.client.getVarbitValue(6440) > 1;
    }

    private boolean insideTombsOfAmascut() {
        return this.insideRaidEncounter() && this.client.getVarbitValue(14345) != 0;
    }

    private boolean insideInferno() {
        return this.client.getVarbitValue(11878) == 1;
    }

    private boolean insideHallowedSepulchre() {
        return this.client.getVarbitValue(10392) > 0;
    }

    private boolean lowDetailPluginEnabled() {
        String pluginEnabled = this.configManager.getConfiguration("runelite", "lowmemoryplugin");
        if (!Boolean.parseBoolean(pluginEnabled)) {
            return false;
        }
        return ((LowMemoryConfig)this.configManager.getConfig(LowMemoryConfig.class)).lowDetail();
    }
}

