/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.money.bag.tracker;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.infinite.money.bag.tracker.InfiniteMoneyBagTrackerHoverOverlay;
import com.infinite.money.bag.tracker.InfiniteMoneyBagTrackerItemOverlay;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Infinite Money Bag Tracker", description="", tags={"Infinite money bag"})
public class InfiniteMoneyBagTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InfiniteMoneyBagTrackerPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    private static final String CONFIG_GROUP = "infinitemoneybagtracker";
    private static final String CONFIG_KEY = "tracker";
    private InfiniteMoneyBagTrackerItemOverlay itemOverlay;
    private InfiniteMoneyBagTrackerHoverOverlay hoverOverlay;
    Map<String, Integer> tracker;
    private int thisSession = 0;

    protected void startUp() throws Exception {
        this.loadFromConfig();
        this.itemOverlay = new InfiniteMoneyBagTrackerItemOverlay(this);
        this.overlayManager.add((Overlay)this.itemOverlay);
        this.hoverOverlay = new InfiniteMoneyBagTrackerHoverOverlay(this, this.client, this.tooltipManager);
        this.overlayManager.add((Overlay)this.hoverOverlay);
        this.thisSession = 0;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.itemOverlay);
        this.overlayManager.remove((Overlay)this.hoverOverlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.thisSession = 0;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chat) {
        if (chat.getMessage().equals("You've obtained a single coin! Wow!")) {
            this.iterate();
        }
    }

    private void iterate() {
        Integer globalCount = this.tracker.get("global");
        int newGlobalCount = globalCount == null ? 1 : globalCount + 1;
        this.tracker.put("global", newGlobalCount);
        String hash = String.valueOf(this.client.getAccountHash());
        Integer account = this.tracker.get(hash);
        int newHashCount = account == null ? 1 : account + 1;
        this.tracker.put(hash, newHashCount);
        ++this.thisSession;
        this.saveToConfig();
    }

    public int getThisSession() {
        return this.thisSession;
    }

    public int getGlobal() {
        Integer value = this.tracker.get("global");
        return value == null ? 0 : value;
    }

    private void loadFromConfig() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY);
        this.tracker = this.stringToTracker(json);
        if (this.tracker == null) {
            this.tracker = new HashMap<String, Integer>();
        }
        this.saveToConfig();
    }

    private void saveToConfig() {
        this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY);
        String json = this.gson.toJson(this.tracker);
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY, json);
    }

    private Map<String, Integer> stringToTracker(String string) {
        TypeToken<HashMap<String, Integer>> typeToken = new TypeToken<HashMap<String, Integer>>(){};
        HashMap hashMap = (HashMap)this.gson.fromJson(string, typeToken.getType());
        return hashMap;
    }
}

