/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.money.bag.tracker;

import com.infinite.money.bag.tracker.Helper;
import com.infinite.money.bag.tracker.InfiniteMoneyBagTrackerPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

public class InfiniteMoneyBagTrackerItemOverlay
extends WidgetItemOverlay {
    private InfiniteMoneyBagTrackerPlugin plugin;

    public InfiniteMoneyBagTrackerItemOverlay(InfiniteMoneyBagTrackerPlugin plugin) {
        this.plugin = plugin;
        this.showOnInventory();
        this.showOnBank();
        this.showOnInterfaces(new int[]{4, 81, 387});
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (itemId == Helper.MONEY_BAG_ITEM_ID) {
            graphics.setFont(FontManager.getRunescapeSmallFont());
            int count = this.plugin.getGlobal();
            this.renderText(graphics, widgetItem.getCanvasBounds(), Helper.formatCount(count), Helper.getCountColor(count));
        }
    }

    private void renderText(Graphics2D graphics, Rectangle bounds, String text, Color color) {
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x + 0, bounds.y + 10));
        textComponent.setColor(color);
        textComponent.setText(text);
        textComponent.render(graphics);
    }
}

