/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.money.bag.tracker;

import com.infinite.money.bag.tracker.Helper;
import com.infinite.money.bag.tracker.InfiniteMoneyBagTrackerPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.QuantityFormatter;

public class InfiniteMoneyBagTrackerHoverOverlay
extends Overlay {
    private InfiniteMoneyBagTrackerPlugin plugin;
    private TooltipManager tooltipManager;
    private Client client;

    public InfiniteMoneyBagTrackerHoverOverlay(InfiniteMoneyBagTrackerPlugin plugin, Client client, TooltipManager tooltipManager) {
        this.plugin = plugin;
        this.client = client;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize <= 0) {
            return null;
        }
        MenuEntry entry = menu[menuSize - 1];
        Widget widget = entry.getWidget();
        if (widget == null) {
            return null;
        }
        int group = WidgetInfo.TO_GROUP((int)widget.getId());
        int itemId = -1;
        if (group == WidgetInfo.EQUIPMENT.getGroupId() || group == 12 && widget.getParentId() == WidgetInfo.BANK_EQUIPMENT_CONTAINER.getId()) {
            Widget widgetItem = widget.getChild(1);
            if (widgetItem != null) {
                itemId = widgetItem.getItemId();
            }
        } else if (widget.getId() == WidgetInfo.INVENTORY.getId() || group == WidgetInfo.EQUIPMENT_INVENTORY_ITEMS_CONTAINER.getGroupId() || widget.getId() == WidgetInfo.BANK_ITEM_CONTAINER.getId() || group == WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getGroupId() || widget.getId() == WidgetInfo.GROUP_STORAGE_ITEM_CONTAINER.getId() || group == 725) {
            itemId = widget.getItemId();
        }
        if (itemId == -1) {
            return null;
        }
        if (itemId == Helper.MONEY_BAG_ITEM_ID) {
            this.tooltipManager.add(new Tooltip(String.format("Global: %s", QuantityFormatter.formatNumber((long)this.plugin.getGlobal()))));
            this.tooltipManager.add(new Tooltip(String.format("Session: %s", QuantityFormatter.formatNumber((long)this.plugin.getThisSession()))));
        }
        return null;
    }
}

