/*
 * Decompiled with CFR 0.152.
 */
package com.visualmetronome;

import com.visualmetronome.FontTypes;
import com.visualmetronome.VisualMetronomeConfig;
import com.visualmetronome.VisualMetronomePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class FullResizableVisualMetronomeOverlay
extends Overlay {
    private final VisualMetronomeConfig config;
    private final VisualMetronomePlugin plugin;
    private static int TITLE_PADDING = 10;
    private static final int MINIMUM_SIZE = 16;

    @Inject
    public FullResizableVisualMetronomeOverlay(VisualMetronomeConfig config, VisualMetronomePlugin plugin) {
        super((Plugin)plugin);
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setMinimumSize(16);
        this.setResizable(true);
    }

    public Dimension render(Graphics2D graphics) {
        Dimension preferredSize = this.getPreferredSize();
        if (preferredSize == null) {
            preferredSize = this.plugin.DEFAULT_SIZE;
            this.setPreferredSize(preferredSize);
        }
        if (this.config.enableMetronome()) {
            graphics.setColor(this.plugin.currentColor);
            graphics.fillRect(0, 0, preferredSize.width, preferredSize.height);
            TITLE_PADDING = Math.min(preferredSize.width, preferredSize.height) / 2 - 4;
            if (this.config.showTick()) {
                if (this.config.disableFontScaling()) {
                    graphics.setColor(this.config.NumberColor());
                    if (this.config.tickCount() == 1) {
                        graphics.drawString(String.valueOf(this.plugin.currentColorIndex), TITLE_PADDING, preferredSize.height - TITLE_PADDING);
                    } else {
                        graphics.drawString(String.valueOf(this.plugin.tickCounter), TITLE_PADDING, preferredSize.height - TITLE_PADDING);
                    }
                } else {
                    if (this.config.fontType() == FontTypes.REGULAR) {
                        graphics.setFont(new Font(FontManager.getRunescapeFont().getName(), 0, Math.min(preferredSize.width, preferredSize.height)));
                    } else {
                        graphics.setFont(new Font(this.config.fontType().toString(), 0, Math.min(preferredSize.width, Math.min(preferredSize.width, preferredSize.height))));
                    }
                    Point tickCounterPoint = new Point(preferredSize.width / 3, preferredSize.height);
                    if (this.config.tickCount() == 1) {
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)tickCounterPoint, (String)String.valueOf(this.plugin.currentColorIndex), (Color)this.config.NumberColor());
                    } else {
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)tickCounterPoint, (String)String.valueOf(this.plugin.tickCounter), (Color)this.config.NumberColor());
                    }
                }
            }
        }
        return preferredSize;
    }
}

