/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui.notification;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.condition.EmptyCondition;
import com.github.zakru.advancednotifications.condition.ItemCondition;
import com.github.zakru.advancednotifications.notification.EmptyNotification;
import com.github.zakru.advancednotifications.notification.ItemNotification;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.notification.NotificationGroup;
import com.github.zakru.advancednotifications.ui.DropSpace;
import com.github.zakru.advancednotifications.ui.DropSpaceSystem;
import com.github.zakru.advancednotifications.ui.EnabledButton;
import com.github.zakru.advancednotifications.ui.notification.EmptyNotificationPanel;
import com.github.zakru.advancednotifications.ui.notification.ItemNotificationPanel;
import com.github.zakru.advancednotifications.ui.notification.NotificationGroupPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public abstract class NotificationPanel<N extends Notification>
extends JPanel
implements MouseListener {
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private static final ImageIcon CONFIGURE_ICON;
    private static final ImageIcon CONFIGURE_HOVER_ICON;
    private static final ImageIcon CONFIGURE_ACTIVE_ICON;
    private static final ImageIcon CONFIGURE_ACTIVE_HOVER_ICON;
    protected final N notification;
    protected final DraggableContainer<Notification> container;
    protected final DropSpaceSystem<Notification> system;
    protected final AdvancedNotificationsPlugin plugin;
    private JPopupMenu menuPopup = new JPopupMenu();

    public NotificationPanel(N notification, DropSpaceSystem<Notification> system, DraggableContainer<Notification> container) {
        this.menuPopup.add(new JMenuItem(new AbstractAction("Clone"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationPanel.this.container.getDraggableItems().add(((Notification)NotificationPanel.this.notification).clone());
                NotificationPanel.this.plugin.rebuildPluginPanel();
            }
        }));
        this.notification = notification;
        this.system = system;
        this.container = container;
        this.plugin = ((Notification)notification).getPlugin();
        this.addMouseListener(this);
    }

    public static NotificationPanel<?> buildPanel(Notification notif, DropSpaceSystem<Notification> system, DraggableContainer<Notification> container, DropSpaceSystem<Condition> conditionSystem) {
        if (notif instanceof ItemNotification) {
            return new ItemNotificationPanel((ItemNotification)notif, system, container, conditionSystem);
        }
        if (notif instanceof EmptyNotification) {
            return new EmptyNotificationPanel((EmptyNotification)notif, system, container, conditionSystem);
        }
        if (notif instanceof NotificationGroup) {
            return new NotificationGroupPanel((NotificationGroup)notif, system, container, conditionSystem);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleClick(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleClick(e);
    }

    private void handleClick(MouseEvent e) {
        if (e.isPopupTrigger() && !e.isConsumed()) {
            this.menuPopup.show(this, e.getX(), e.getY());
            e.consume();
        }
    }

    protected static JPanel createDefaultActions(final NotificationPanel<?> panel) {
        JPanel actions = new JPanel(new FlowLayout(2, 4, 0));
        actions.setOpaque(false);
        actions.setBorder(BorderFactory.createEmptyBorder(0, -4, 0, -4));
        final JLabel deleteButton = new JLabel(DELETE_ICON);
        deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    panel.container.getDraggableItems().remove(panel.notification);
                    panel.plugin.updateConfig();
                    panel.plugin.rebuildPluginPanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteButton.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteButton.setIcon(DELETE_ICON);
            }
        });
        final JLabel configureButton = new JLabel(((Notification)panel.notification).getCondition() != null ? CONFIGURE_ACTIVE_ICON : CONFIGURE_ICON);
        if (((Notification)panel.notification).isConfiguring()) {
            configureButton.setOpaque(true);
            configureButton.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        }
        configureButton.setToolTipText(((Notification)panel.notification).getCondition() != null ? "Toggle condition configuration" : "Add condition");
        final JPopupMenu addPopup = NotificationPanel.createAddConditionMenu(panel);
        configureButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (((Notification)panel.notification).getCondition() == null) {
                    addPopup.show(configureButton, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((Notification)panel.notification).getCondition() != null && e.getButton() == 1) {
                    ((Notification)panel.notification).setConfiguring(!((Notification)panel.notification).isConfiguring());
                    panel.plugin.rebuildPluginPanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                configureButton.setIcon(((Notification)panel.notification).getCondition() != null ? CONFIGURE_ACTIVE_HOVER_ICON : CONFIGURE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                configureButton.setIcon(((Notification)panel.notification).getCondition() != null ? CONFIGURE_ACTIVE_ICON : CONFIGURE_ICON);
            }
        });
        actions.add(configureButton);
        actions.add(new EnabledButton(panel.plugin, (Notification)panel.notification));
        actions.add(deleteButton);
        return actions;
    }

    protected static JPopupMenu createAddConditionMenu(final NotificationPanel<?> panel) {
        JPopupMenu addPopup = new JPopupMenu();
        addPopup.add(new JMenuItem(new AbstractAction("Inventory"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Notification)panel.notification).setCondition(new ItemCondition(panel.plugin));
                ((Notification)panel.notification).setConfiguring(true);
                panel.plugin.updateConfig();
                panel.plugin.rebuildPluginPanel();
            }
        }));
        addPopup.add(new JMenuItem(new AbstractAction("Empty Space"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Notification)panel.notification).setCondition(new EmptyCondition(panel.plugin));
                ((Notification)panel.notification).setConfiguring(true);
                panel.plugin.updateConfig();
                panel.plugin.rebuildPluginPanel();
            }
        }));
        return addPopup;
    }

    static {
        BufferedImage deleteIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteIcon);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteIcon, (float)0.53f));
        BufferedImage configureIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"configure_icon.png");
        CONFIGURE_ICON = new ImageIcon(configureIcon);
        CONFIGURE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)configureIcon, (float)0.53f));
        BufferedImage configureActiveIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"configure_active_icon.png");
        CONFIGURE_ACTIVE_ICON = new ImageIcon(configureActiveIcon);
        CONFIGURE_ACTIVE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)configureActiveIcon, (float)0.53f));
    }

    protected static class DefaultTypePanel
    extends JPanel {
        private static final Border TYPE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(8, 8, 8, 8));

        public DefaultTypePanel(NotificationPanel<?> panel, String typeName) {
            super(new BorderLayout());
            this.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            this.setOpaque(false);
            this.setBorder(TYPE_BORDER);
            this.addMouseListener(new DragStarter(panel));
            this.addMouseListener(panel);
            JLabel typeLabel = new JLabel(typeName);
            typeLabel.setForeground(Color.WHITE);
            this.add((Component)typeLabel, "West");
            this.add((Component)NotificationPanel.createDefaultActions(panel), "East");
        }

        public void addDefaultVisualListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ((DefaultTypePanel)e.getComponent()).setOpaque(true);
                        e.getComponent().repaint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ((DefaultTypePanel)e.getComponent()).setOpaque(false);
                        e.getComponent().repaint();
                    }
                }
            });
        }
    }

    protected static class DragStarter
    extends MouseAdapter {
        private final NotificationPanel<?> panel;

        public DragStarter(NotificationPanel<?> panel) {
            this.panel = panel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.panel.system.setDragging((Notification)this.panel.notification, this.panel.container);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                if (this.panel.system.getDragHovering() == null) {
                    this.panel.system.setDragging(null, null);
                } else {
                    DropSpaceSystem<Notification> system = this.panel.system;
                    DropSpace<Notification> space = system.getDragHovering();
                    Object notif = this.panel.notification;
                    if (!(notif instanceof DraggableContainer) || !(space.getContainer() instanceof Notification) || notif != space.getContainer() && !DragStarter.containerContains((DraggableContainer)notif, (Notification)((Object)space.getContainer()))) {
                        if (system.getDraggingFrom() != space.getContainer()) {
                            system.getDraggingFrom().getDraggableItems().remove(system.getDragging());
                            space.getContainer().getDraggableItems().add(space.getIndex(), system.getDragging());
                        } else {
                            List<Notification> notifications = this.panel.container.getDraggableItems();
                            int originalIndex = notifications.indexOf(this.panel.notification);
                            notifications.remove(this.panel.notification);
                            int index = space.getIndex();
                            if (index > originalIndex) {
                                --index;
                            }
                            notifications.add(index, (Notification)this.panel.notification);
                        }
                        this.panel.plugin.updateConfig();
                        this.panel.plugin.rebuildPluginPanel();
                    }
                    space.setBackground(ColorScheme.DARK_GRAY_COLOR);
                    system.setDragging(null, null);
                    system.setDragHovering(null);
                }
            }
        }

        private static boolean containerContains(DraggableContainer<Notification> parent, Notification child) {
            if (parent.getDraggableItems().contains(child)) {
                return true;
            }
            for (Notification n : parent.getDraggableItems()) {
                if (!(n instanceof DraggableContainer) || !DragStarter.containerContains((DraggableContainer)((Object)n), child)) continue;
                return true;
            }
            return false;
        }
    }
}

