/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui.notification;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.notification.NotificationGroup;
import com.github.zakru.advancednotifications.ui.DropSpace;
import com.github.zakru.advancednotifications.ui.DropSpaceSystem;
import com.github.zakru.advancednotifications.ui.condition.ConditionPanel;
import com.github.zakru.advancednotifications.ui.notification.NotificationPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class NotificationGroupPanel
extends NotificationPanel<NotificationGroup> {
    private static final ImageIcon RENAME_ICON;
    private static final ImageIcon RENAME_HOVER_ICON;
    private static final ImageIcon COLLAPSE_ICON;
    private static final ImageIcon COLLAPSE_HOVER_ICON;
    private static final ImageIcon EXPAND_ICON;
    private static final ImageIcon EXPAND_HOVER_ICON;
    private final JTextField nameLabel;
    private final JLabel rename;

    public NotificationGroupPanel(final NotificationGroup notification, DropSpaceSystem<Notification> system, DraggableContainer<Notification> container, DropSpaceSystem<Condition> conditionSystem) {
        super(notification, system, container);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        final JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        northPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        northPanel.addMouseListener(new NotificationPanel.DragStarter(this));
        northPanel.addMouseListener(this);
        northPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    northPanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    northPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                }
            }
        });
        this.nameLabel = new JTextField();
        this.nameLabel.setForeground(Color.WHITE);
        this.nameLabel.setDisabledTextColor(Color.WHITE);
        this.nameLabel.setEnabled(false);
        this.nameLabel.setBorder(null);
        this.nameLabel.setBackground(null);
        this.nameLabel.setOpaque(false);
        this.nameLabel.setText(notification.getName());
        this.nameLabel.addActionListener(e -> this.finishRename());
        this.nameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                for (MouseListener l : northPanel.getMouseListeners()) {
                    l.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                for (MouseListener l : northPanel.getMouseListeners()) {
                    l.mouseReleased(e);
                }
            }
        });
        this.nameLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NotificationGroupPanel.this.finishRename();
            }
        });
        JPanel actions = NotificationGroupPanel.createDefaultActions(this);
        this.rename = new JLabel(RENAME_ICON);
        this.rename.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    NotificationGroupPanel.this.nameLabel.setEnabled(true);
                    NotificationGroupPanel.this.nameLabel.requestFocusInWindow();
                    NotificationGroupPanel.this.nameLabel.selectAll();
                    NotificationGroupPanel.this.rename.setEnabled(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                NotificationGroupPanel.this.rename.setIcon(RENAME_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NotificationGroupPanel.this.rename.setIcon(RENAME_ICON);
            }
        });
        actions.add((Component)this.rename, 0);
        final JLabel collapseOrExpand = new JLabel(notification.isCollapsed() ? EXPAND_ICON : COLLAPSE_ICON);
        collapseOrExpand.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    notification.setCollapsed(!notification.isCollapsed());
                    notification.getPlugin().updateConfig();
                    notification.getPlugin().rebuildPluginPanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                collapseOrExpand.setIcon(notification.isCollapsed() ? EXPAND_HOVER_ICON : COLLAPSE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                collapseOrExpand.setIcon(notification.isCollapsed() ? EXPAND_ICON : COLLAPSE_ICON);
            }
        });
        northPanel.add((Component)collapseOrExpand, "West");
        northPanel.add((Component)this.nameLabel, "Center");
        northPanel.add((Component)actions, "East");
        this.add((Component)northPanel, "North");
        if (notification.isConfiguring()) {
            ConditionPanel<?> cond = ConditionPanel.buildPanel(notification.getCondition(), conditionSystem, notification.getConditionContainer());
            cond.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR));
            this.add(cond, "Center");
        }
        if (!notification.isCollapsed()) {
            JPanel notificationView = new JPanel();
            notificationView.setLayout(new BoxLayout(notificationView, 1));
            notificationView.setOpaque(false);
            notificationView.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, ColorScheme.DARKER_GRAY_COLOR), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
            int index = 0;
            notificationView.add(new DropSpace<Notification>(system, notification, index++));
            for (Notification notif : notification.getDraggableItems()) {
                NotificationPanel<?> panel = NotificationPanel.buildPanel(notif, system, notification, conditionSystem);
                if (panel == null) continue;
                notificationView.add(panel);
                notificationView.add(new DropSpace<Notification>(system, notification, index++));
            }
            this.add((Component)notificationView, "South");
        }
    }

    public void resetScroll() {
        this.nameLabel.setScrollOffset(0);
    }

    private void finishRename() {
        if (!this.nameLabel.isEnabled()) {
            return;
        }
        this.nameLabel.setEnabled(false);
        this.nameLabel.requestFocusInWindow();
        ((NotificationGroup)this.notification).setName(this.nameLabel.getText());
        this.plugin.updateConfig();
        this.rename.setEnabled(true);
    }

    static {
        BufferedImage renameIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"rename_icon.png");
        RENAME_ICON = new ImageIcon(renameIcon);
        RENAME_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)renameIcon, (float)0.53f));
        BufferedImage collapseIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"collapse_icon.png");
        COLLAPSE_ICON = new ImageIcon(collapseIcon);
        COLLAPSE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)collapseIcon, (float)0.53f));
        BufferedImage expandIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"expand_icon.png");
        EXPAND_ICON = new ImageIcon(expandIcon);
        EXPAND_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)expandIcon, (float)0.53f));
    }
}

