/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui.notification;

import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.notification.InventoryComparator;
import com.github.zakru.advancednotifications.notification.ItemNotification;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.ui.DropSpaceSystem;
import com.github.zakru.advancednotifications.ui.condition.ConditionPanel;
import com.github.zakru.advancednotifications.ui.notification.NotificationPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.ui.ColorScheme;

public class ItemNotificationPanel
extends NotificationPanel<ItemNotification> {
    private final SpinnerModel spinnerModel = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
    private final JSpinner countSpinner = new JSpinner(this.spinnerModel);

    public ItemNotificationPanel(ItemNotification notification, DropSpaceSystem<Notification> system, DraggableContainer<Notification> container, DropSpaceSystem<Condition> conditionSystem) {
        super(notification, system, container);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        NotificationPanel.DefaultTypePanel typePanel = new NotificationPanel.DefaultTypePanel(this, "Inventory");
        typePanel.addDefaultVisualListener();
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPanel.setOpaque(false);
        final JTextField nameField = new JTextField(notification.getItem());
        nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ItemNotificationPanel.this.updateItem(nameField);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ItemNotificationPanel.this.updateItem(nameField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ItemNotificationPanel.this.updateItem(nameField);
            }
        });
        JPanel paramsPanel = new JPanel(new FlowLayout(0));
        paramsPanel.setOpaque(false);
        JLabel countLabel = new JLabel("Count ");
        countLabel.setForeground(Color.WHITE);
        JComboBox<InventoryComparator> comparatorBox = new JComboBox<InventoryComparator>(InventoryComparator.COMPARATORS);
        comparatorBox.setSelectedItem(notification.getComparator().object);
        comparatorBox.setPreferredSize(new Dimension(50, 20));
        comparatorBox.setMaximumRowCount(9);
        comparatorBox.addItemListener(e -> {
            notification.getComparator().object = (InventoryComparator)comparatorBox.getSelectedItem();
            notification.getPlugin().updateConfig();
            this.countSpinner.setVisible(notification.getComparator().object.takesParam());
        });
        this.countSpinner.setValue(notification.getComparatorParam());
        this.countSpinner.setPreferredSize(new Dimension(64, 20));
        this.countSpinner.setVisible(notification.getComparator().object.takesParam());
        this.countSpinner.addChangeListener(e -> {
            notification.setComparatorParam((Integer)this.countSpinner.getValue());
            notification.getPlugin().updateConfig();
        });
        paramsPanel.add(countLabel);
        paramsPanel.add(comparatorBox);
        paramsPanel.add(this.countSpinner);
        contentPanel.add((Component)nameField, "North");
        contentPanel.add((Component)paramsPanel, "South");
        this.add((Component)typePanel, "North");
        if (notification.isConfiguring()) {
            ConditionPanel<?> cond = ConditionPanel.buildPanel(notification.getCondition(), conditionSystem, notification.getConditionContainer());
            cond.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR));
            this.add(cond, "Center");
        }
        this.add((Component)contentPanel, "South");
    }

    private void updateItem(JTextField field) {
        ((ItemNotification)this.notification).setItem(field.getText());
        ((ItemNotification)this.notification).getPlugin().updateConfig();
    }
}

