/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui.condition;

import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.condition.InventoryChecker;
import com.github.zakru.advancednotifications.condition.ItemCondition;
import com.github.zakru.advancednotifications.ui.DropSpaceSystem;
import com.github.zakru.advancednotifications.ui.condition.ConditionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.ui.ColorScheme;

public class ItemConditionPanel
extends ConditionPanel<ItemCondition> {
    private final SpinnerModel spinnerModel = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
    private final JSpinner countSpinner = new JSpinner(this.spinnerModel);

    public ItemConditionPanel(ItemCondition condition, DropSpaceSystem<Condition> system, DraggableContainer<Condition> container) {
        super(condition, system, container);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        ConditionPanel.DefaultTypePanel typePanel = new ConditionPanel.DefaultTypePanel(this, "Inventory Condition");
        typePanel.addDefaultVisualListener();
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPanel.setOpaque(false);
        final JTextField nameField = new JTextField(condition.getItem());
        nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ItemConditionPanel.this.updateItem(nameField);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ItemConditionPanel.this.updateItem(nameField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ItemConditionPanel.this.updateItem(nameField);
            }
        });
        JPanel paramsPanel = new JPanel(new FlowLayout(0));
        paramsPanel.setOpaque(false);
        JLabel countLabel = new JLabel("Count ");
        countLabel.setForeground(Color.WHITE);
        JComboBox<InventoryChecker> comparatorBox = new JComboBox<InventoryChecker>(InventoryChecker.CHECKERS);
        comparatorBox.setSelectedItem(condition.getChecker().object);
        comparatorBox.setPreferredSize(new Dimension(50, 20));
        comparatorBox.setMaximumRowCount(9);
        comparatorBox.addItemListener(e -> {
            condition.getChecker().object = (InventoryChecker)comparatorBox.getSelectedItem();
            condition.getPlugin().updateConfig();
            this.countSpinner.setVisible(condition.getChecker().object.takesParam());
        });
        this.countSpinner.setValue(condition.getCheckerParam());
        this.countSpinner.setPreferredSize(new Dimension(64, 20));
        this.countSpinner.setVisible(condition.getChecker().object.takesParam());
        this.countSpinner.addChangeListener(e -> {
            condition.setCheckerParam((Integer)this.countSpinner.getValue());
            condition.getPlugin().updateConfig();
        });
        paramsPanel.add(countLabel);
        paramsPanel.add(comparatorBox);
        paramsPanel.add(this.countSpinner);
        contentPanel.add((Component)nameField, "North");
        contentPanel.add((Component)paramsPanel, "South");
        this.add((Component)typePanel, "North");
        this.add((Component)contentPanel, "Center");
    }

    private void updateItem(JTextField field) {
        ((ItemCondition)this.condition).setItem(field.getText());
        ((ItemCondition)this.condition).getPlugin().updateConfig();
    }
}

