/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui.condition;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.condition.EmptyCondition;
import com.github.zakru.advancednotifications.condition.ItemCondition;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.ui.DropSpace;
import com.github.zakru.advancednotifications.ui.DropSpaceSystem;
import com.github.zakru.advancednotifications.ui.condition.EmptyConditionPanel;
import com.github.zakru.advancednotifications.ui.condition.ItemConditionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public abstract class ConditionPanel<C extends Condition>
extends JPanel
implements MouseListener {
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    protected final C condition;
    protected final DraggableContainer<Condition> container;
    protected final DropSpaceSystem<Condition> system;
    protected final AdvancedNotificationsPlugin plugin;
    private JPopupMenu menuPopup = new JPopupMenu();

    public ConditionPanel(C condition, DropSpaceSystem<Condition> system, DraggableContainer<Condition> container) {
        this.menuPopup.add(new JMenuItem(new AbstractAction("Clone"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionPanel.this.container.getDraggableItems().add(((Condition)ConditionPanel.this.condition).clone());
                ConditionPanel.this.plugin.rebuildPluginPanel();
            }
        }));
        this.condition = condition;
        this.system = system;
        this.container = container;
        this.plugin = ((Condition)condition).getPlugin();
        this.addMouseListener(this);
    }

    public static ConditionPanel<?> buildPanel(Condition cond, DropSpaceSystem<Condition> system, DraggableContainer<Condition> container) {
        if (cond instanceof ItemCondition) {
            return new ItemConditionPanel((ItemCondition)cond, system, container);
        }
        if (cond instanceof EmptyCondition) {
            return new EmptyConditionPanel((EmptyCondition)cond, system, container);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleClick(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleClick(e);
    }

    private void handleClick(MouseEvent e) {
        if (e.isPopupTrigger() && !e.isConsumed()) {
            this.menuPopup.show(this, e.getX(), e.getY());
            e.consume();
        }
    }

    protected static JPanel createDefaultActions(final ConditionPanel<?> panel) {
        JPanel actions = new JPanel(new FlowLayout(2, 4, 0));
        actions.setOpaque(false);
        actions.setBorder(BorderFactory.createEmptyBorder(0, -4, 0, -4));
        final JLabel deleteButton = new JLabel(DELETE_ICON);
        deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    Notification root = panel.container.getRoot();
                    if (root != null) {
                        root.setCondition(null);
                        root.setConfiguring(false);
                    } else {
                        panel.container.getDraggableItems().remove(panel.condition);
                    }
                    panel.plugin.updateConfig();
                    panel.plugin.rebuildPluginPanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                deleteButton.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                deleteButton.setIcon(DELETE_ICON);
            }
        });
        actions.add(deleteButton);
        return actions;
    }

    static {
        BufferedImage deleteIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteIcon);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteIcon, (float)0.53f));
    }

    protected static class DefaultTypePanel
    extends JPanel {
        private static final Border TYPE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(8, 8, 8, 8));

        public DefaultTypePanel(ConditionPanel<?> panel, String typeName) {
            super(new BorderLayout());
            this.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            this.setOpaque(false);
            this.setBorder(TYPE_BORDER);
            this.addMouseListener(new DragStarter(panel));
            this.addMouseListener(panel);
            JLabel typeLabel = new JLabel(typeName);
            typeLabel.setForeground(Color.WHITE);
            this.add((Component)typeLabel, "West");
            this.add((Component)ConditionPanel.createDefaultActions(panel), "East");
        }

        public void addDefaultVisualListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ((DefaultTypePanel)e.getComponent()).setOpaque(true);
                        e.getComponent().repaint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ((DefaultTypePanel)e.getComponent()).setOpaque(false);
                        e.getComponent().repaint();
                    }
                }
            });
        }
    }

    protected static class DragStarter
    extends MouseAdapter {
        private final ConditionPanel<?> panel;

        public DragStarter(ConditionPanel<?> panel) {
            this.panel = panel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.panel.system.setDragging((Condition)this.panel.condition, this.panel.container);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                if (this.panel.system.getDragHovering() == null) {
                    this.panel.system.setDragging(null, null);
                } else {
                    DropSpaceSystem<Condition> system = this.panel.system;
                    DropSpace<Condition> space = system.getDragHovering();
                    Object cond = this.panel.condition;
                    if (!(cond instanceof DraggableContainer) || !(space.getContainer() instanceof Condition) || cond != space.getContainer() && !DragStarter.containerContains((DraggableContainer)cond, (Condition)((Object)space.getContainer()))) {
                        if (system.getDraggingFrom() != space.getContainer()) {
                            system.getDraggingFrom().getDraggableItems().remove(system.getDragging());
                            space.getContainer().getDraggableItems().add(space.getIndex(), system.getDragging());
                        } else {
                            List<Condition> conditions = this.panel.container.getDraggableItems();
                            int originalIndex = conditions.indexOf(this.panel.condition);
                            conditions.remove(this.panel.condition);
                            int index = space.getIndex();
                            if (index > originalIndex) {
                                --index;
                            }
                            conditions.add(index, (Condition)this.panel.condition);
                        }
                        this.panel.plugin.updateConfig();
                        this.panel.plugin.rebuildPluginPanel();
                    }
                    space.setBackground(ColorScheme.DARK_GRAY_COLOR);
                    system.setDragging(null, null);
                    system.setDragHovering(null);
                }
            }
        }

        private static boolean containerContains(DraggableContainer<Condition> parent, Condition child) {
            if (parent.getDraggableItems().contains(child)) {
                return true;
            }
            for (Condition c : parent.getDraggableItems()) {
                if (!(c instanceof DraggableContainer) || !DragStarter.containerContains((DraggableContainer)((Object)c), child)) continue;
                return true;
            }
            return false;
        }
    }
}

