/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.notification.Notification;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.runelite.client.util.ImageUtil;

public class EnabledButton
extends JLabel {
    private static final ImageIcon ENABLED_ICON;
    private static final ImageIcon ENABLED_HOVER_ICON;
    private static final ImageIcon DISABLED_ICON;
    private static final ImageIcon DISABLED_HOVER_ICON;
    private final Notification notification;

    public EnabledButton(final AdvancedNotificationsPlugin plugin, final Notification notification) {
        this.notification = notification;
        this.setIcon(notification.isEnabled() ? ENABLED_ICON : DISABLED_ICON);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    notification.setEnabled(!notification.isEnabled());
                    EnabledButton.this.updateIcon();
                    plugin.updateConfig();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                EnabledButton.this.setIcon(notification.isEnabled() ? ENABLED_HOVER_ICON : DISABLED_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EnabledButton.this.setIcon(notification.isEnabled() ? ENABLED_ICON : DISABLED_ICON);
            }
        });
    }

    private void updateIcon() {
        if (this.getIcon() == ENABLED_ICON || this.getIcon() == DISABLED_ICON) {
            this.setIcon(this.notification.isEnabled() ? ENABLED_ICON : DISABLED_ICON);
        } else {
            this.setIcon(this.notification.isEnabled() ? ENABLED_HOVER_ICON : DISABLED_HOVER_ICON);
        }
    }

    static {
        BufferedImage enabledIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"enabled_icon.png");
        ENABLED_ICON = new ImageIcon(enabledIcon);
        ENABLED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)enabledIcon, (float)0.53f));
        BufferedImage disabledIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"disabled_icon.png");
        DISABLED_ICON = new ImageIcon(disabledIcon);
        DISABLED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)disabledIcon, (float)0.53f));
    }
}

