/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui;

import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.ui.DropSpaceSystem;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class DropSpace<T>
extends JPanel {
    private final MouseAdapter listener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            DropSpace space = (DropSpace)e.getComponent();
            if (space.system.getDragging() != null) {
                space.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
                space.system.setDragHovering(space);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DropSpace space = (DropSpace)e.getComponent();
            if (space.system.getDragging() != null) {
                space.setBackground(ColorScheme.DARK_GRAY_COLOR);
                space.system.setDragHovering(null);
            }
        }
    };
    private final DropSpaceSystem<T> system;
    private final DraggableContainer<T> container;
    private final int index;

    public DropSpace(DropSpaceSystem<T> system, DraggableContainer<T> container, int index) {
        this.system = system;
        this.container = container;
        this.index = index;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setPreferredSize(new Dimension(0, 10));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.addMouseListener(this.listener);
    }

    public DraggableContainer<T> getContainer() {
        return this.container;
    }

    public int getIndex() {
        return this.index;
    }
}

