/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.ui;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.notification.EmptyNotification;
import com.github.zakru.advancednotifications.notification.ItemNotification;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.notification.NotificationGroup;
import com.github.zakru.advancednotifications.ui.DropSpace;
import com.github.zakru.advancednotifications.ui.DropSpaceSystem;
import com.github.zakru.advancednotifications.ui.notification.NotificationGroupPanel;
import com.github.zakru.advancednotifications.ui.notification.NotificationPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

public class AdvancedNotificationsPluginPanel
extends PluginPanel
implements DropSpaceSystem<Notification> {
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private final AdvancedNotificationsPlugin plugin;
    private final JPanel notificationView;
    private Notification dragging;
    private DraggableContainer<Notification> draggingFrom;
    private DropSpace<Notification> dragHovering;
    private Condition draggingCondition;
    private DraggableContainer<Condition> draggingFromCondition;
    private DropSpace<Condition> dragHoveringCondition;
    private DropSpaceSystem<Condition> conditionSystem = new DropSpaceSystem<Condition>(){

        @Override
        public Condition getDragging() {
            return AdvancedNotificationsPluginPanel.this.draggingCondition;
        }

        @Override
        public void setDragging(Condition c, DraggableContainer from) {
            AdvancedNotificationsPluginPanel.this.draggingCondition = c;
            AdvancedNotificationsPluginPanel.this.draggingFromCondition = from;
        }

        @Override
        public DraggableContainer getDraggingFrom() {
            return AdvancedNotificationsPluginPanel.this.draggingFromCondition;
        }

        @Override
        public DropSpace getDragHovering() {
            return AdvancedNotificationsPluginPanel.this.dragHoveringCondition;
        }

        @Override
        public void setDragHovering(DropSpace space) {
            AdvancedNotificationsPluginPanel.this.dragHoveringCondition = space;
        }
    };

    public AdvancedNotificationsPluginPanel(final AdvancedNotificationsPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JLabel title = new JLabel("Notifications");
        title.setForeground(Color.WHITE);
        final JPopupMenu addPopup = new JPopupMenu();
        addPopup.add(new JMenuItem(new AbstractAction("Inventory"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.getDraggableItems().add(new ItemNotification(plugin));
                plugin.updateConfig();
                AdvancedNotificationsPluginPanel.this.rebuild();
            }
        }));
        addPopup.add(new JMenuItem(new AbstractAction("Empty Space"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.getDraggableItems().add(new EmptyNotification(plugin));
                plugin.updateConfig();
                AdvancedNotificationsPluginPanel.this.rebuild();
            }
        }));
        addPopup.add(new JMenuItem(new AbstractAction("Group"){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.getDraggableItems().add(new NotificationGroup(plugin));
                plugin.updateConfig();
                AdvancedNotificationsPluginPanel.this.rebuild();
            }
        }));
        final JLabel addNotification = new JLabel(ADD_ICON);
        addNotification.setToolTipText("Add a notification");
        addNotification.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                addPopup.show(addNotification, e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                addNotification.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                addNotification.setIcon(ADD_ICON);
            }
        });
        northPanel.add((Component)title, "West");
        northPanel.add((Component)addNotification, "East");
        this.notificationView = new JPanel();
        this.notificationView.setLayout(new BoxLayout(this.notificationView, 1));
        this.add(northPanel, "North");
        this.add(this.notificationView, "Center");
    }

    public void rebuild() {
        this.notificationView.removeAll();
        int index = 0;
        this.notificationView.add(new DropSpace<Notification>(this, this.plugin, index++));
        for (Notification notif : this.plugin.getDraggableItems()) {
            NotificationPanel<?> panel = NotificationPanel.buildPanel(notif, this, this.plugin, this.conditionSystem);
            if (panel == null) continue;
            this.notificationView.add(panel);
            this.notificationView.add(new DropSpace<Notification>(this, this.plugin, index++));
        }
        this.repaint();
        this.revalidate();
        for (Component n : this.notificationView.getComponents()) {
            if (!(n instanceof NotificationGroupPanel)) continue;
            ((NotificationGroupPanel)n).resetScroll();
        }
    }

    @Override
    public void setDragging(Notification n, DraggableContainer<Notification> from) {
        this.dragging = n;
        this.draggingFrom = from;
    }

    @Override
    public Notification getDragging() {
        return this.dragging;
    }

    @Override
    public DraggableContainer<Notification> getDraggingFrom() {
        return this.draggingFrom;
    }

    @Override
    public DropSpace<Notification> getDragHovering() {
        return this.dragHovering;
    }

    @Override
    public void setDragHovering(DropSpace<Notification> dragHovering) {
        this.dragHovering = dragHovering;
    }

    public Condition getDraggingCondition() {
        return this.draggingCondition;
    }

    public DraggableContainer<Condition> getDraggingFromCondition() {
        return this.draggingFromCondition;
    }

    public DropSpace<Condition> getDragHoveringCondition() {
        return this.dragHoveringCondition;
    }

    public void setDragHoveringCondition(DropSpace<Condition> dragHoveringCondition) {
        this.dragHoveringCondition = dragHoveringCondition;
    }

    static {
        BufferedImage addIcon = ImageUtil.getResourceStreamFromClass(AdvancedNotificationsPlugin.class, (String)"add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
    }
}

