/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.notification;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.condition.ConditionAdapter;
import com.github.zakru.advancednotifications.notification.ComparatorAdapter;
import com.github.zakru.advancednotifications.notification.InventoryComparator;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.notification.NotificationType;
import com.github.zakru.advancednotifications.notification.NotificationTypes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class NotificationAdapter
extends TypeAdapter<Notification> {
    private final AdvancedNotificationsPlugin plugin;
    private final Gson gson;

    public NotificationAdapter(AdvancedNotificationsPlugin plugin) {
        this.plugin = plugin;
        this.gson = new GsonBuilder().registerTypeAdapter(Notification.class, (Object)this).registerTypeAdapter(InventoryComparator.Pointer.class, (Object)new ComparatorAdapter()).registerTypeAdapter(Condition.class, (Object)new ConditionAdapter(plugin)).create();
    }

    public void write(JsonWriter out, Notification o) throws IOException {
        JsonObject jo = this.gson.toJsonTree((Object)o).getAsJsonObject();
        jo.addProperty("type", this.idOf(o));
        this.gson.toJson((JsonElement)jo, out);
    }

    public Notification read(JsonReader in) throws IOException {
        JsonObject jo = (JsonObject)this.gson.fromJson(in, JsonObject.class);
        String notificationType = jo.get("type").getAsString();
        jo.remove("type");
        Notification notification = this.ofType((JsonElement)jo, notificationType);
        notification.setPlugin(this.plugin);
        return notification;
    }

    private Notification ofType(JsonElement in, String type) throws IOException {
        NotificationType t = NotificationTypes.REGISTRY.entrySet().stream().filter(e -> ((String)e.getKey()).equals(type)).map(Map.Entry::getValue).findAny().orElse(null);
        if (t != null) {
            return (Notification)this.gson.fromJson(in, t.getTargetClass());
        }
        throw new RuntimeException("Unknown notification type " + type);
    }

    private String idOf(Notification o) {
        Optional<String> id = NotificationTypes.REGISTRY.entrySet().stream().filter(e -> ((NotificationType)e.getValue()).getTargetClass() == o.getClass()).map(Map.Entry::getKey).findAny();
        if (id.isPresent()) {
            return id.get();
        }
        throw new RuntimeException("Unknown notification class " + o.getClass());
    }
}

