/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.notification;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.condition.Condition;
import java.util.Collections;
import java.util.List;

public abstract class Notification {
    private transient AdvancedNotificationsPlugin plugin;
    private boolean enabled = true;
    private transient boolean configuring = false;
    private Condition condition = null;
    private final transient DraggableContainer<Condition> conditionContainer = new DraggableContainer<Condition>(){

        @Override
        public List<Condition> getDraggableItems() {
            return Collections.singletonList(Notification.this.condition);
        }

        @Override
        public Notification getRoot() {
            return Notification.this;
        }
    };

    public Notification(AdvancedNotificationsPlugin plugin) {
        this.plugin = plugin;
    }

    public void tryNotify(Object event) {
        if (!this.enabled || this.condition != null && !this.condition.isFulfilled()) {
            return;
        }
        this.notify(event);
    }

    protected abstract void notify(Object var1);

    protected void doNotification(String message) {
        this.plugin.getNotifier().notify(message);
    }

    public abstract Notification clone();

    public Notification() {
    }

    public AdvancedNotificationsPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(AdvancedNotificationsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isConfiguring() {
        return this.configuring;
    }

    public void setConfiguring(boolean configuring) {
        this.configuring = configuring;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public DraggableContainer<Condition> getConditionContainer() {
        return this.conditionContainer;
    }
}

