/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.notification;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.notification.ComparatorAdapter;
import com.github.zakru.advancednotifications.notification.EmptyNotification;
import com.github.zakru.advancednotifications.notification.InventoryComparator;
import com.github.zakru.advancednotifications.notification.ItemNotification;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.notification.NotificationGroup;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class LegacyNotificationAdapter
extends TypeAdapter<Notification> {
    private final AdvancedNotificationsPlugin plugin;
    private final Gson gson;

    public LegacyNotificationAdapter(AdvancedNotificationsPlugin plugin) {
        this.plugin = plugin;
        this.gson = new GsonBuilder().registerTypeAdapter(Notification.class, (Object)this).registerTypeAdapter(InventoryComparator.Pointer.class, (Object)new ComparatorAdapter()).create();
    }

    public void write(JsonWriter out, Notification o) throws IOException {
        out.beginObject();
        out.name("type").value((long)this.idOf(o));
        out.name("data");
        this.outTyped(out, o);
        out.endObject();
    }

    public Notification read(JsonReader in) throws IOException {
        int notificationType = -1;
        Notification notification = null;
        in.beginObject();
        block8: while (in.hasNext()) {
            switch (in.nextName()) {
                case "type": {
                    notificationType = in.nextInt();
                    continue block8;
                }
                case "data": {
                    notification = this.ofType(in, notificationType);
                    continue block8;
                }
            }
            in.skipValue();
        }
        in.endObject();
        notification.setPlugin(this.plugin);
        return notification;
    }

    private Notification ofType(JsonReader in, int type) throws IOException {
        switch (type) {
            case 0: {
                return (Notification)this.gson.fromJson(in, ItemNotification.class);
            }
            case 1: {
                return (Notification)this.gson.fromJson(in, EmptyNotification.class);
            }
            case 2: {
                return (Notification)this.gson.fromJson(in, NotificationGroup.class);
            }
        }
        return null;
    }

    private void outTyped(JsonWriter out, Notification o) throws IOException {
        if (o instanceof ItemNotification) {
            this.gson.toJson((Object)o, ItemNotification.class, out);
        } else if (o instanceof EmptyNotification) {
            this.gson.toJson((Object)o, EmptyNotification.class, out);
        } else if (o instanceof NotificationGroup) {
            this.gson.toJson((Object)o, NotificationGroup.class, out);
        }
    }

    private int idOf(Notification o) {
        if (o instanceof ItemNotification) {
            return 0;
        }
        if (o instanceof EmptyNotification) {
            return 1;
        }
        if (o instanceof NotificationGroup) {
            return 2;
        }
        return -1;
    }
}

