/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.notification;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.InventoryEvent;
import com.github.zakru.advancednotifications.notification.InventoryComparator;
import com.github.zakru.advancednotifications.notification.Notification;

public class ItemNotification
extends Notification {
    private String item = "Coins";
    private InventoryComparator.Pointer comparator = new InventoryComparator.Pointer(InventoryComparator.COMPARATORS[0]);
    private int comparatorParam = 0;

    public ItemNotification(AdvancedNotificationsPlugin plugin) {
        super(plugin);
    }

    @Override
    public void notify(Object event) {
        if (!(event instanceof InventoryEvent)) {
            return;
        }
        InventoryEvent e = (InventoryEvent)event;
        if (this.getPlugin().getItemManager().getItemComposition(e.getItemID()).getName().equalsIgnoreCase(this.item) && this.comparator.object.shouldNotify(e.getPreviousCount(), e.getCount(), this.comparatorParam)) {
            this.doNotification(this.comparator.object.notification(this.item, this.comparatorParam));
        }
    }

    @Override
    public ItemNotification clone() {
        ItemNotification n = new ItemNotification(this.getPlugin());
        n.item = this.item;
        n.comparator = new InventoryComparator.Pointer(this.comparator.object);
        n.comparatorParam = this.comparatorParam;
        return n;
    }

    public ItemNotification() {
    }

    public String getItem() {
        return this.item;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public InventoryComparator.Pointer getComparator() {
        return this.comparator;
    }

    public void setComparator(InventoryComparator.Pointer comparator) {
        this.comparator = comparator;
    }

    public int getComparatorParam() {
        return this.comparatorParam;
    }

    public void setComparatorParam(int comparatorParam) {
        this.comparatorParam = comparatorParam;
    }
}

