/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.notification;

public interface InventoryComparator {
    public static final InventoryComparator COUNT_CHANGED = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount != previousCount;
        }

        @Override
        public boolean takesParam() {
            return false;
        }

        @Override
        public String notification(String item, int param) {
            return "Your amount of " + item + " changed";
        }

        public String toString() {
            return "+-";
        }
    };
    public static final InventoryComparator COUNT_INCREASED = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount > previousCount;
        }

        @Override
        public boolean takesParam() {
            return false;
        }

        @Override
        public String notification(String item, int param) {
            return "You got " + item;
        }

        public String toString() {
            return "+";
        }
    };
    public static final InventoryComparator COUNT_DECREASED = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount < previousCount;
        }

        @Override
        public boolean takesParam() {
            return false;
        }

        @Override
        public String notification(String item, int param) {
            return "You lost " + item;
        }

        public String toString() {
            return "-";
        }
    };
    public static final InventoryComparator EQUAL = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount == param && previousCount != param;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        @Override
        public String notification(String item, int param) {
            return "You now have " + param + " " + item;
        }

        public String toString() {
            return "=";
        }
    };
    public static final InventoryComparator NOT_EQUAL = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount != param && previousCount == param;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        @Override
        public String notification(String item, int param) {
            return "You no longer have " + param + " " + item;
        }

        public String toString() {
            return "\u2260";
        }
    };
    public static final InventoryComparator LESS_THAN = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount < param && previousCount >= param;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        @Override
        public String notification(String item, int param) {
            return "You now have less than " + param + " " + item;
        }

        public String toString() {
            return "<";
        }
    };
    public static final InventoryComparator GREATER_THAN = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount > param && previousCount <= param;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        @Override
        public String notification(String item, int param) {
            return "You now have more than " + param + " " + item;
        }

        public String toString() {
            return ">";
        }
    };
    public static final InventoryComparator LESS_OR_EQUAL = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount <= param && previousCount > param;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        @Override
        public String notification(String item, int param) {
            return "You now have at most " + param + " " + item;
        }

        public String toString() {
            return "\u2264";
        }
    };
    public static final InventoryComparator GREATER_OR_EQUAL = new InventoryComparator(){

        @Override
        public boolean shouldNotify(int previousCount, int newCount, int param) {
            return newCount >= param && previousCount < param;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        @Override
        public String notification(String item, int param) {
            return "You now have at least " + param + " " + item;
        }

        public String toString() {
            return "\u2265";
        }
    };
    public static final InventoryComparator[] COMPARATORS = new InventoryComparator[]{COUNT_CHANGED, COUNT_INCREASED, COUNT_DECREASED, EQUAL, NOT_EQUAL, LESS_THAN, GREATER_THAN, LESS_OR_EQUAL, GREATER_OR_EQUAL};

    public boolean shouldNotify(int var1, int var2, int var3);

    public boolean takesParam();

    public String notification(String var1, int var2);

    public static class Pointer {
        public InventoryComparator object;

        public Pointer(InventoryComparator object) {
            this.object = object;
        }
    }
}

